/*
 * Decompiled with CFR 0.152.
 */
package dev.cephelo.spartancataclysm;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.items.Tooltier;
import com.mojang.logging.LogUtils;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import dev.cephelo.spartancataclysm.Config;
import dev.cephelo.spartancataclysm.effects.SCEffects;
import dev.cephelo.spartancataclysm.sounds.SCSounds;
import dev.cephelo.spartancataclysm.traits.AccursedRageTrait;
import dev.cephelo.spartancataclysm.traits.BlazingBrandTrait;
import dev.cephelo.spartancataclysm.traits.MechaPulseTrait;
import dev.cephelo.spartancataclysm.traits.MechaSmiteTrait;
import dev.cephelo.spartancataclysm.traits.UnbreakableTrait;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import krelox.spartantoolkit.SpartanAddon;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponMap;
import krelox.spartantoolkit.WeaponType;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="spartancataclysm")
public class SpartanCataclysm
extends SpartanAddon {
    public static final String MODID = "spartancataclysm";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final WeaponMap WEAPONS = new WeaponMap();
    public static final DeferredRegister<Item> ITEMS = SpartanCataclysm.itemRegister((String)"spartancataclysm");
    public static final DeferredRegister<WeaponTrait> TRAITS = SpartanCataclysm.traitRegister((String)"spartancataclysm");
    public static final DeferredRegister<CreativeModeTab> TABS = SpartanCataclysm.tabRegister((String)"spartancataclysm");
    public static final Tier IGNITIUM_TIER = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, -1, 9.0f, 7.0f, 20, BlockTags.create((ResourceLocation)new ResourceLocation("spartancataclysm", "needs_ignitium_tool")), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.IGNITIUM_INGOT.get()})), (ResourceLocation)new ResourceLocation("cataclysm", "ignitium_ingot"), List.of(Tiers.NETHERITE), List.of());
    public static final Tier CURSIUM_TIER = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, -1, 9.0f, 6.0f, 20, BlockTags.create((ResourceLocation)new ResourceLocation("spartancataclysm", "needs_cursium_tool")), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CURSIUM_INGOT.get()})), (ResourceLocation)new ResourceLocation("cataclysm", "cursium_ingot"), List.of(Tiers.NETHERITE), List.of());
    public static final Tier WITHERITE_TIER = TierSortingRegistry.registerTier((Tier)new ForgeTier(5, -1, 7.0f, 6.0f, 18, BlockTags.create((ResourceLocation)new ResourceLocation("spartancataclysm", "needs_witherite_tool")), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WITHERITE_INGOT.get()})), (ResourceLocation)new ResourceLocation("cataclysm", "witherite_ingot"), List.of(Tiers.NETHERITE), List.of());
    public static final RegistryObject<WeaponTrait> BLAZING_BRAND = SpartanCataclysm.registerTrait(TRAITS, (WeaponTrait)new BlazingBrandTrait());
    public static final RegistryObject<WeaponTrait> ACCURSED_RAGE = SpartanCataclysm.registerTrait(TRAITS, (WeaponTrait)new AccursedRageTrait());
    public static final RegistryObject<WeaponTrait> MECHA_PULSE = SpartanCataclysm.registerTrait(TRAITS, (WeaponTrait)new MechaPulseTrait());
    public static final RegistryObject<WeaponTrait> MECHA_SMITE = SpartanCataclysm.registerTrait(TRAITS, (WeaponTrait)new MechaSmiteTrait());
    public static final RegistryObject<WeaponTrait> UNBREAKABLE = SpartanCataclysm.registerTrait(TRAITS, (WeaponTrait)new UnbreakableTrait());
    public static final ArrayList<SpartanMaterial> MATERIALS = new ArrayList();
    public static final SpartanMaterial ANCIENT_METAL = SpartanCataclysm.material("ancient_metal", Tooltier.ANCIENT_METAL, "spartancataclysm:ancient_metal_ingots", new RegistryObject[0]);
    public static final SpartanMaterial BLACK_STEEL = SpartanCataclysm.material("black_steel", Tooltier.BLACK_STEEL, "spartancataclysm:black_steel_ingots", new RegistryObject[0]);
    public static final SpartanMaterial CURSIUM = SpartanCataclysm.material("cursium", CURSIUM_TIER, "spartancataclysm:cursium_ingots", ACCURSED_RAGE, WeaponTraits.FIREPROOF, UNBREAKABLE).setRarity(Rarity.EPIC);
    public static final SpartanMaterial IGNITIUM = SpartanCataclysm.material("ignitium", IGNITIUM_TIER, "spartancataclysm:ignitium_ingots", BLAZING_BRAND, WeaponTraits.FIREPROOF, UNBREAKABLE).setRarity(Rarity.EPIC);
    public static final SpartanMaterial WITHERITE = SpartanCataclysm.material("witherite", WITHERITE_TIER, "spartancataclysm:witherite_ingots", MECHA_SMITE, MECHA_PULSE, WeaponTraits.FIREPROOF, UNBREAKABLE).setRarity(Rarity.EPIC);
    public static final RegistryObject<CreativeModeTab> SPARTAN_CATACLYSM_TAB = SpartanCataclysm.registerTab(TABS, (String)"spartancataclysm", () -> (Item)WEAPONS.get(IGNITIUM, WeaponType.GREATSWORD).get(), (parameters, output) -> ITEMS.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get())));
    public static final TagKey<Item> ANCIENT_METAL_WEAPONS = SpartanCataclysm.registerItemTag("ancient_metal_weapons");
    public static final TagKey<Item> BLACK_STEEL_WEAPONS = SpartanCataclysm.registerItemTag("black_steel_weapons");
    public static final TagKey<Item> CURSIUM_WEAPONS = SpartanCataclysm.registerItemTag("cursium_weapons");
    public static final TagKey<Item> IGNITIUM_WEAPONS = SpartanCataclysm.registerItemTag("ignitium_weapons");
    public static final TagKey<Item> WITHERITE_WEAPONS = SpartanCataclysm.registerItemTag("witherite_weapons");

    @SafeVarargs
    private static SpartanMaterial material(String name, Tier tier, String tagPath, RegistryObject<WeaponTrait> ... traits) {
        SpartanMaterial material = new SpartanMaterial(name, MODID, tier, ItemTags.create((ResourceLocation)new ResourceLocation(tagPath)), traits);
        MATERIALS.add(material);
        return material;
    }

    public SpartanCataclysm() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SCEffects.register(bus);
        SCSounds.register(bus);
        this.registerSpartanWeapons(ITEMS);
        ITEMS.register(bus);
        TRAITS.register(bus);
        TABS.register(bus);
    }

    private static TagKey<Item> registerItemTag(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(MODID, name));
    }

    private void generateSmeltingRecipes(Consumer<FinishedRecipe> consumer, TagKey<Item> tag, Item result, String key) {
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(tag), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)1.0f, (int)100).m_126132_("criteria", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)ResourceLocation.m_135820_((String)("spartancataclysm:" + key + "_nugget_from_blasting_" + key + "_weapons")))).m_176500_(consumer, "spartancataclysm:" + key + "_nugget_from_blasting_" + key + "_weapons");
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(tag), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)1.0f, (int)200).m_126132_("criteria", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)ResourceLocation.m_135820_((String)("spartancataclysm:" + key + "_nugget_from_smelting_" + key + "_weapons")))).m_176500_(consumer, "spartancataclysm:" + key + "_nugget_from_smelting_" + key + "_weapons");
    }

    protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        this.generateSmeltingRecipes(consumer, ANCIENT_METAL_WEAPONS, (Item)ModItems.ANCIENT_METAL_NUGGET.get(), "ancient_metal");
        this.generateSmeltingRecipes(consumer, BLACK_STEEL_WEAPONS, (Item)ModItems.BLACK_STEEL_NUGGET.get(), "black_steel");
        this.generateSmeltingRecipes(consumer, WITHERITE_WEAPONS, (Item)ModItems.WITHERITE_INGOT.get(), "witherite");
        WEAPONS.forEach((key, item) -> {
            SpartanMaterial material = (SpartanMaterial)key.first();
            WeaponType type = (WeaponType)key.second();
            if (material.equals(IGNITIUM)) {
                SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.IGNITIUM_UPGARDE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)("spartanweaponry:netherite_" + type.toString().toLowerCase())))}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.IGNITIUM_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)item.get())).m_266439_("has_" + ModItems.IGNITIUM_UPGARDE_SMITHING_TEMPLATE.getId().m_135815_(), (CriterionTriggerInstance)SpartanCataclysm.has((ItemLike)((ItemLike)ModItems.IGNITIUM_UPGARDE_SMITHING_TEMPLATE.get()))).m_266371_(consumer, item.getId().m_266382_("_smithing"));
            } else if (material.equals(CURSIUM)) {
                SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CURSIUM_UPGARDE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)("spartanweaponry:netherite_" + type.toString().toLowerCase())))}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CURSIUM_INGOT.get()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)((Item)item.get())).m_266439_("has_" + ModItems.CURSIUM_UPGARDE_SMITHING_TEMPLATE.getId().m_135815_(), (CriterionTriggerInstance)SpartanCataclysm.has((ItemLike)((ItemLike)ModItems.CURSIUM_UPGARDE_SMITHING_TEMPLATE.get()))).m_266371_(consumer, item.getId().m_266382_("_smithing"));
            } else {
                type.recipe.accept((Object)WEAPONS, (Object)consumer, (Object)material);
            }
        });
    }

    protected void addTranslations(LanguageProvider provider, Function<RegistryObject<?>, String> formatName) {
        super.addTranslations(provider, formatName);
        provider.addEffect(SCEffects.ACCURSED_RAGE, "Accursed Rage");
        provider.addEffect(SCEffects.PULSE_CHARGE, "Pulse Charge");
        provider.addEffect(SCEffects.PULSE_COOLDOWN, "Pulse Cooldown");
        provider.add("effect.spartancataclysm.accursed_rage.desc", "You deal more damage with Cursium weapons.");
        provider.add("effect.cataclysm.blazing_brand.desc", "Reduces armor proportional to the amplifier.  Attackers gain lifesteal.");
        provider.add("effect.spartancataclysm.blazing_brand.desc", "Reduces armor proportional to the amplifier.  Attackers gain lifesteal.");
        provider.add("effect.spartancataclysm.pulse_charge.desc", "A shockwave is released at a sufficient amplifier.");
        provider.add("effect.spartancataclysm.pulse_cooldown.desc", "Pulse Charge cannot be accumulated until this effect ceases.");
        provider.add("sounds.spartancataclysm.accursed_rage_max", "Accursed Rage reaches maximum");
        provider.add("sounds.spartancataclysm.mecha_pulse_shockwave", "Shockwave released");
    }

    public String modid() {
        return MODID;
    }

    public List<SpartanMaterial> getMaterials() {
        return MATERIALS;
    }

    public WeaponMap getWeaponMap() {
        return WEAPONS;
    }
}

