/*
 * Decompiled with CFR 0.152.
 */
package dev.cephelo.spartancataclysm.traits;

import com.github.L_Ender.cataclysm.init.ModParticle;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import dev.cephelo.spartancataclysm.Config;
import dev.cephelo.spartancataclysm.SpartanCataclysm;
import dev.cephelo.spartancataclysm.effects.SCEffects;
import dev.cephelo.spartancataclysm.sounds.SCSounds;
import krelox.spartantoolkit.BetterWeaponTrait;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AccursedRageTrait
extends BetterWeaponTrait {
    public AccursedRageTrait() {
        super("accursed_rage", "spartancataclysm", WeaponTrait.TraitQuality.POSITIVE);
        this.setUniversal();
    }

    public String getDescription() {
        return "Can stack Accursed Rage on the user.  Attackers with Accursed Rage do more damage with Cursium weapons based on the amplifier.";
    }

    public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        float addedDamage = this.calculateRage(attacker, victim);
        return super.modifyDamageDealt(material, baseDamage += addedDamage, source, attacker, victim);
    }

    public float modifyRangedDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        float addedDamage = this.calculateRage(attacker, victim);
        return super.modifyRangedDamageDealt(material, baseDamage += addedDamage, source, attacker, victim);
    }

    private float calculateRage(LivingEntity attacker, LivingEntity target) {
        if (attacker != null) {
            try {
                MobEffectInstance newEffect;
                ServerLevel serverLevel;
                MobEffect rageEffect = (MobEffect)SCEffects.ACCURSED_RAGE.get();
                MobEffectInstance oldEffect = attacker.m_21124_(rageEffect);
                int i = oldEffect == null ? 0 : Math.min(Config.accursedRageMaximum, oldEffect.m_19564_() + 1);
                boolean reachedMax = i >= Config.accursedRageMaximum && oldEffect.m_19564_() == i - 1;
                Level level = attacker.m_9236_();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    if (i >= Config.accursedRageMaximum) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.SMALL_CURSED_FLAME.get()), target.m_20185_(), target.m_20186_() + (double)target.m_20192_() - 1.0, target.m_20189_(), 8, 0.4, 0.7, 0.4, 0.02);
                    }
                }
                if (Math.random() <= Config.accursedRageChance) {
                    attacker.m_7292_(new MobEffectInstance(rageEffect, Config.accursedRageDuration, i));
                    level = attacker.m_9236_();
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        if (reachedMax) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.CURSED_FLAME.get()), attacker.m_20185_(), attacker.m_20186_() + 1.0, attacker.m_20189_(), 15, 0.3, 0.6, 0.3, 0.02);
                        } else if (i < Config.accursedRageMaximum) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.SMALL_CURSED_FLAME.get()), attacker.m_20185_(), attacker.m_20186_() + 1.0, attacker.m_20189_(), 9, 0.3, 0.6, 0.3, 0.01);
                        }
                    }
                    if (Config.customSounds && reachedMax) {
                        attacker.m_9236_().m_214150_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)SCSounds.ACCURSED_RAGE_MAX.get(), SoundSource.PLAYERS, 1.0f, 1.0f, 0L);
                    }
                }
                if ((newEffect = attacker.m_21124_(rageEffect)) != null) {
                    if (Config.customSounds) {
                        attacker.m_9236_().m_214150_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)SCSounds.CURSIUM_HIT.get(), SoundSource.PLAYERS, 1.0f, Config.getRandomPitch(), 0L);
                    }
                    return (float)(newEffect.m_19564_() + 1) * (float)Config.accursedRageExtraDamage;
                }
            }
            catch (Throwable e) {
                SpartanCataclysm.LOGGER.error(String.valueOf(e));
            }
        }
        return 0.0f;
    }
}

