/*
 * Decompiled with CFR 0.152.
 */
package dev.cephelo.spartancataclysm.traits;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import dev.cephelo.spartancataclysm.Config;
import dev.cephelo.spartancataclysm.SpartanCataclysm;
import dev.cephelo.spartancataclysm.effects.SCEffects;
import dev.cephelo.spartancataclysm.sounds.SCSounds;
import krelox.spartantoolkit.BetterWeaponTrait;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BlazingBrandTrait
extends BetterWeaponTrait {
    public BlazingBrandTrait() {
        super("blazing_brand", "spartancataclysm", WeaponTrait.TraitQuality.POSITIVE);
        this.setUniversal();
    }

    public String getDescription() {
        return "Can stack Blazing Brand on the target, reducing armor based on the amplifier.  Attackers gain a small amount of lifesteal.";
    }

    public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        BlazingBrandTrait.calculateBlazingBrand(attacker, victim);
        return super.modifyDamageDealt(material, baseDamage, source, attacker, victim);
    }

    public float modifyRangedDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        BlazingBrandTrait.calculateBlazingBrand(attacker, victim);
        return super.modifyDamageDealt(material, baseDamage, source, attacker, victim);
    }

    private static void calculateBlazingBrand(LivingEntity attacker, LivingEntity victim) {
        if (attacker != null && victim != null && Math.random() <= Config.blazingBrandChance) {
            float factor = (float)Config.lifestealMultiplier;
            if (factor > 0.0f && attacker instanceof Player) {
                Player player = (Player)attacker;
                float speed = (float)player.m_21133_(Attributes.f_22283_);
                factor /= Mth.m_14036_((float)speed, (float)0.5f, (float)2.0f);
            }
            BlazingBrandTrait.stackBlazingBrand(attacker, victim, factor);
        }
    }

    private static void stackBlazingBrand(LivingEntity attacker, LivingEntity target, float factor) {
        try {
            ServerLevel serverLevel;
            Level level;
            MobEffect brandEffect = (MobEffect)SCEffects.BLAZING_BRAND_CUSTOM.get();
            MobEffectInstance oldEffect = target.m_21124_(brandEffect);
            int i = oldEffect == null ? 0 : Math.min(Config.blazingBrandMaximum, oldEffect.m_19564_() + 1);
            target.m_7292_(new MobEffectInstance(brandEffect, Config.blazingBrandDuration, i));
            if (factor > 0.0f && Math.random() <= Config.blazingBrandLifestealChance) {
                attacker.m_5634_(factor * (float)(i + 1));
                level = attacker.m_9236_();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175834_, attacker.m_20185_(), attacker.m_20186_() + 1.0, attacker.m_20189_(), 6, 0.3, 0.6, 0.3, 0.02);
                }
            }
            if ((level = attacker.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)(i == Config.blazingBrandMaximum ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), target.m_20185_(), target.m_20186_() + (double)target.m_20192_() - 1.0, target.m_20189_(), 10, 0.4, 0.7, 0.4, 0.02);
            }
            if (Config.customSounds) {
                attacker.m_9236_().m_214150_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)SCSounds.IGNITIUM_HIT.get(), SoundSource.PLAYERS, 1.0f, Config.getRandomPitch(), 0L);
            }
        }
        catch (Throwable e) {
            SpartanCataclysm.LOGGER.error(String.valueOf(e));
        }
    }
}

