/*
 * Decompiled with CFR 0.152.
 */
package dev.cephelo.spartancataclysm.traits;

import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import dev.cephelo.spartancataclysm.Config;
import dev.cephelo.spartancataclysm.SpartanCataclysm;
import dev.cephelo.spartancataclysm.effects.SCEffects;
import dev.cephelo.spartancataclysm.sounds.SCSounds;
import krelox.spartantoolkit.BetterWeaponTrait;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MechaPulseTrait
extends BetterWeaponTrait {
    public MechaPulseTrait() {
        super("mecha_pulse", "spartancataclysm", WeaponTrait.TraitQuality.POSITIVE);
        this.setUniversal();
    }

    public String getDescription() {
        return "Can stack Pulse Charge on the attacker.  Upon reaching a sufficient amplifier, a shockwave stuns and deals damage to the target";
    }

    public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        float addedDamage = this.chargeStunPulse(attacker, victim);
        return super.modifyDamageDealt(material, baseDamage += addedDamage, source, attacker, victim);
    }

    public float modifyRangedDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        float addedDamage = this.chargeStunPulse(attacker, victim);
        return super.modifyRangedDamageDealt(material, baseDamage += addedDamage, source, attacker, victim);
    }

    private float chargeStunPulse(LivingEntity attacker, LivingEntity target) {
        if (attacker != null) {
            try {
                boolean reachedMax;
                MobEffect cooldownEffect = (MobEffect)SCEffects.PULSE_COOLDOWN.get();
                MobEffectInstance oldCooldownEffect = attacker.m_21124_(cooldownEffect);
                if (oldCooldownEffect != null) {
                    return 0.0f;
                }
                MobEffect chargeEffect = (MobEffect)SCEffects.PULSE_CHARGE.get();
                MobEffectInstance oldChargeEffect = attacker.m_21124_(chargeEffect);
                int i = oldChargeEffect == null ? 0 : Math.min(Config.mechaPulseStunThreshold, oldChargeEffect.m_19564_() + 1);
                boolean bl = reachedMax = i >= Config.mechaPulseStunThreshold && oldChargeEffect.m_19564_() == i - 1;
                if (Math.random() <= Config.mechaPulseChargeChance) {
                    ServerLevel serverLevel;
                    attacker.m_7292_(new MobEffectInstance(chargeEffect, Config.mechaPulseEffectDuration, i));
                    Level level = attacker.m_9236_();
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, attacker.m_20185_(), attacker.m_20186_() + 1.4, attacker.m_20189_(), 3, 0.4, 0.4, 0.4, 0.0);
                    }
                    if (reachedMax) {
                        attacker.m_21195_(chargeEffect);
                        attacker.m_7292_(new MobEffectInstance(cooldownEffect, Config.mechaPulseCooldown, 0, false, false, true));
                        target.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), Config.mechaPulseStunDuration, 0));
                        level = attacker.m_9236_();
                        if (level instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.EM_PULSE.get()), target.m_20185_(), target.m_20186_() + (double)target.m_20192_() - 1.25, target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        if (Config.customSounds) {
                            attacker.m_9236_().m_214150_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)SCSounds.MECHA_PULSE_SHOCKWAVE.get(), SoundSource.PLAYERS, 1.0f, 1.0f, 0L);
                            attacker.m_9236_().m_214150_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)SCSounds.WITHERITE_HIT.get(), SoundSource.PLAYERS, 2.0f, 1.0f, 0L);
                        }
                        return (float)Config.mechaPulseExtraDamage;
                    }
                }
            }
            catch (Throwable e) {
                SpartanCataclysm.LOGGER.error(String.valueOf(e));
            }
        }
        return 0.0f;
    }
}

