/*
 * Decompiled with CFR 0.152.
 */
package dev.cephelo.spartancataclysm.traits;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import dev.cephelo.spartancataclysm.Config;
import dev.cephelo.spartancataclysm.SpartanCataclysm;
import dev.cephelo.spartancataclysm.sounds.SCSounds;
import krelox.spartantoolkit.BetterWeaponTrait;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class MechaSmiteTrait
extends BetterWeaponTrait {
    public MechaSmiteTrait() {
        super("mecha_smite", "spartancataclysm", WeaponTrait.TraitQuality.POSITIVE);
        this.setUniversal();
    }

    public String getDescription() {
        return "Ignites targets and inflicts them with Wither.  Can grant Regeneration when attacking while below half health.";
    }

    public void onHitEntity(WeaponMaterial material, ItemStack stack, LivingEntity target, LivingEntity attacker, Entity projectile) {
        this.applyMechaEffects(target, attacker);
        super.onHitEntity(material, stack, target, attacker, projectile);
    }

    public void onRangedHitEntity(WeaponMaterial material, ItemStack stack, LivingEntity target, LivingEntity attacker, Entity projectile) {
        this.applyMechaEffects(target, attacker);
        super.onHitEntity(material, stack, target, attacker, projectile);
    }

    private void applyMechaEffects(LivingEntity target, LivingEntity attacker) {
        if (attacker != null) {
            try {
                if (target != null && Math.random() <= Config.mechaSmiteChance) {
                    if (Config.mechaSmiteWitherDuration > 0) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, Config.mechaSmiteWitherDuration, Config.mechaSmiteWitherAmplifier));
                    }
                    if (Config.mechaSmiteFireDuration > 0) {
                        target.m_20254_(Config.mechaSmiteFireDuration);
                    }
                    if (Config.customSounds) {
                        attacker.m_9236_().m_214150_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)SCSounds.WITHERITE_HIT.get(), SoundSource.PLAYERS, 1.0f, Config.getRandomPitch(), 0L);
                    }
                }
                if (Math.random() <= Config.mechaSmiteRegenChance) {
                    double d = attacker.m_21223_();
                    double d2 = Config.mechaSmiteRegenThresholdType ? (double)attacker.m_21233_() * Config.mechaSmiteRegenThresholdPercent : (double)Config.mechaSmiteRegenThreshold;
                    if (d < d2) {
                        attacker.m_7292_(new MobEffectInstance(MobEffects.f_19605_, Config.mechaSmiteRegenDuration, Config.mechaSmiteRegenAmplifier));
                    }
                }
            }
            catch (Throwable e) {
                SpartanCataclysm.LOGGER.error(String.valueOf(e));
            }
        }
    }
}

