/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartanfire;

import com.github.alexthe666.iceandfire.item.DragonSteelTier;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemGeneric;
import com.mojang.datafixers.util.Either;
import com.oblivioussp.spartanweaponry.api.crafting.condition.TypeDisabledCondition;
import com.oblivioussp.spartanweaponry.api.data.model.ModelGenerator;
import com.oblivioussp.spartanweaponry.api.data.recipe.ConditionalShapelessRecipeBuilder;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import krelox.spartanfire.trait.FireDragonDamageBonusTrait;
import krelox.spartanfire.trait.FlamedTrait;
import krelox.spartanfire.trait.IceDragonDamageBonusTrait;
import krelox.spartanfire.trait.IcedTrait;
import krelox.spartanfire.trait.NonArthropodDamageBonusTrait;
import krelox.spartanfire.trait.PoisonedTrait;
import krelox.spartanfire.trait.ShockedTrait;
import krelox.spartantoolkit.SpartanAddon;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponItem;
import krelox.spartantoolkit.WeaponMap;
import krelox.spartantoolkit.WeaponType;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.util.TriConsumer;

@Mod(value="spartanfire")
public class SpartanFire
extends SpartanAddon {
    public static final String MODID = "spartanfire";
    public static final WeaponMap WEAPONS = new WeaponMap();
    public static final DeferredRegister<Item> ITEMS = SpartanFire.itemRegister((String)"spartanfire");
    public static final DeferredRegister<WeaponTrait> TRAITS = SpartanFire.traitRegister((String)"spartanfire");
    public static final DeferredRegister<CreativeModeTab> TABS = SpartanFire.tabRegister((String)"spartanfire");
    public static final RegistryObject<WeaponTrait> ICE_DRAGON_DAMAGE_BONUS_I = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new IceDragonDamageBonusTrait().setLevel(1));
    public static final RegistryObject<WeaponTrait> ICE_DRAGON_DAMAGE_BONUS_II = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new IceDragonDamageBonusTrait().setLevel(2));
    public static final RegistryObject<WeaponTrait> FIRE_DRAGON_DAMAGE_BONUS_I = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new FireDragonDamageBonusTrait().setLevel(1));
    public static final RegistryObject<WeaponTrait> FIRE_DRAGON_DAMAGE_BONUS_II = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new FireDragonDamageBonusTrait().setLevel(2));
    public static final RegistryObject<WeaponTrait> FLAMED_I = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new FlamedTrait().setLevel(1).setMagnitude(5.0f));
    public static final RegistryObject<WeaponTrait> FLAMED_II = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new FlamedTrait().setLevel(2).setMagnitude(15.0f));
    public static final RegistryObject<WeaponTrait> ICED_I = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new IcedTrait().setLevel(1));
    public static final RegistryObject<WeaponTrait> ICED_II = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new IcedTrait().setLevel(2));
    public static final RegistryObject<WeaponTrait> SHOCKED = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new ShockedTrait());
    public static final RegistryObject<WeaponTrait> NON_ARTHROPOD_DAMAGE_BONUS = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new NonArthropodDamageBonusTrait());
    public static final RegistryObject<WeaponTrait> POISONED = SpartanFire.registerTrait(TRAITS, (WeaponTrait)new PoisonedTrait());
    public static final ArrayList<SpartanMaterial> MATERIALS = new ArrayList();
    public static final SpartanMaterial DRAGON_BONE = SpartanFire.material("dragon_bone", (Tier)IafItemRegistry.DRAGONBONE_TOOL_MATERIAL, "forge:bones/dragon", new RegistryObject[0]);
    public static final SpartanMaterial FLAMED_DRAGON_BONE = SpartanFire.material("flamed_dragon_bone", (Tier)IafItemRegistry.FIRE_DRAGONBONE_TOOL_MATERIAL, "forge:bones/dragon", ICE_DRAGON_DAMAGE_BONUS_II, FLAMED_I);
    public static final SpartanMaterial ICED_DRAGON_BONE = SpartanFire.material("iced_dragon_bone", (Tier)IafItemRegistry.ICE_DRAGONBONE_TOOL_MATERIAL, "forge:bones/dragon", FIRE_DRAGON_DAMAGE_BONUS_II, ICED_I);
    public static final SpartanMaterial LIGHTNING_DRAGON_BONE = SpartanFire.material("lightning_dragon_bone", (Tier)IafItemRegistry.LIGHTNING_DRAGONBONE_TOOL_MATERIAL, "forge:bones/dragon", ICE_DRAGON_DAMAGE_BONUS_I, FIRE_DRAGON_DAMAGE_BONUS_I, SHOCKED);
    public static final SpartanMaterial DESERT_MYRMEX_CHITIN = SpartanFire.material("desert_myrmex_chitin", (Tier)IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL, "forge:chitin_desert", NON_ARTHROPOD_DAMAGE_BONUS);
    public static final SpartanMaterial DESERT_MYRMEX_STINGER = SpartanFire.material("desert_myrmex_stinger", (Tier)IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL, "forge:chitin_desert", NON_ARTHROPOD_DAMAGE_BONUS, POISONED);
    public static final SpartanMaterial JUNGLE_MYRMEX_CHITIN = SpartanFire.material("jungle_myrmex_chitin", (Tier)IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL, "forge:chitin_jungle", NON_ARTHROPOD_DAMAGE_BONUS);
    public static final SpartanMaterial JUNGLE_MYRMEX_STINGER = SpartanFire.material("jungle_myrmex_stinger", (Tier)IafItemRegistry.MYRMEX_CHITIN_TOOL_MATERIAL, "forge:chitin_jungle", NON_ARTHROPOD_DAMAGE_BONUS, POISONED);
    public static final SpartanMaterial FIRE_DRAGONSTEEL = SpartanFire.material("fire_dragonsteel", DragonSteelTier.DRAGONSTEEL_TIER_FIRE, "forge:ingots/fire_dragonsteel", FLAMED_II);
    public static final SpartanMaterial ICE_DRAGONSTEEL = SpartanFire.material("ice_dragonsteel", DragonSteelTier.DRAGONSTEEL_TIER_ICE, "forge:ingots/ice_dragonsteel", ICED_II);
    public static final SpartanMaterial LIGHTNING_DRAGONSTEEL = SpartanFire.material("lightning_dragonsteel", DragonSteelTier.DRAGONSTEEL_TIER_LIGHTNING, "forge:ingots/lightning_dragonsteel", SHOCKED);
    public static final RegistryObject<CreativeModeTab> SPARTAN_FIRE_TAB = SpartanFire.registerTab(TABS, (String)"spartanfire", () -> (Item)WEAPONS.get(FLAMED_DRAGON_BONE, WeaponType.GREATSWORD).get(), (parameters, output) -> ITEMS.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get())));
    public static final RegistryObject<Item> WITHERBONE_HANDLE = ITEMS.register("witherbone_handle", ItemGeneric::new);
    public static final RegistryObject<Item> WITHERBONE_POLE = ITEMS.register("witherbone_pole", ItemGeneric::new);
    private static final TagKey<Item> WITHERBONE = ItemTags.create((ResourceLocation)new ResourceLocation("forge:bones/wither"));

    @SafeVarargs
    private static SpartanMaterial material(String name, Tier tier, String tagPath, RegistryObject<WeaponTrait> ... traits) {
        SpartanMaterial material = new SpartanMaterial(name, MODID, tier, ItemTags.create((ResourceLocation)new ResourceLocation(tagPath)), traits){

            public TagKey<Item> getStick() {
                return WITHERBONE;
            }

            public ItemLike getHandle() {
                return (ItemLike)WITHERBONE_HANDLE.get();
            }

            public ItemLike getPole() {
                return (ItemLike)WITHERBONE_POLE.get();
            }
        };
        MATERIALS.add(material);
        return material;
    }

    public SpartanFire() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerSpartanWeapons(ITEMS);
        ITEMS.register(bus);
        TRAITS.register(bus);
        TABS.register(bus);
    }

    @SubscribeEvent
    public void gatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        WeaponItem weapon;
        Item item = event.getItemStack().m_41720_();
        if (item instanceof WeaponItem && ((weapon = (WeaponItem)item).getMaterial().equals(FLAMED_DRAGON_BONE) || weapon.getMaterial().equals(ICED_DRAGON_BONE) || weapon.getMaterial().equals(LIGHTNING_DRAGON_BONE))) {
            event.getTooltipElements().add(1, Either.left((Object)Component.m_237115_((String)"item.iceandfire.legendary_weapon.desc").m_130940_(ChatFormatting.GOLD)));
        }
    }

    protected void addTranslations(LanguageProvider provider, Function<RegistryObject<?>, String> formatName) {
        super.addTranslations(provider, formatName);
        provider.add((Item)WITHERBONE_HANDLE.get(), "Witherbone Handle");
        provider.add((Item)WITHERBONE_POLE.get(), "Witherbone Pole");
    }

    protected void registerModels(ItemModelProvider provider, ModelGenerator generator) {
        super.registerModels(provider, generator);
        provider.basicItem((Item)WITHERBONE_HANDLE.get());
        generator.createSimpleModel((Item)WITHERBONE_POLE.get(), new ResourceLocation("spartanweaponry", "item/base/pole"));
    }

    protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        TriConsumer witherboneRecipe = (builder, witherboneCount, ingredient) -> builder.m_126186_(Ingredient.m_204132_(WITHERBONE), witherboneCount.intValue()).m_206419_(ingredient).m_126145_(ForgeRegistries.ITEMS.getKey((Object)builder.m_142372_()).toString()).m_126132_("has_witherbone", (CriterionTriggerInstance)SpartanFire.has(WITHERBONE)).m_126140_(consumer, ForgeRegistries.ITEMS.getKey((Object)builder.m_142372_()).m_266382_("_from_" + ingredient.f_203868_().m_135815_()));
        witherboneRecipe.accept((Object)ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WITHERBONE_HANDLE.get())), (Object)1, (Object)Tags.Items.STRING);
        witherboneRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WITHERBONE_HANDLE.get()), (int)4), (Object)4, (Object)ItemTags.f_13167_);
        witherboneRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WITHERBONE_HANDLE.get()), (int)4), (Object)4, (Object)Tags.Items.LEATHER);
        witherboneRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WITHERBONE_POLE.get()), (int)4), (Object)8, (Object)ItemTags.f_13167_);
        witherboneRecipe.accept((Object)ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WITHERBONE_POLE.get()), (int)4), (Object)8, (Object)Tags.Items.LEATHER);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)WITHERBONE_POLE.get())).m_206416_(Character.valueOf('|'), WITHERBONE).m_206416_(Character.valueOf('#'), Tags.Items.STRING).m_126130_("| ").m_126130_("|#").m_126130_("| ").m_126145_(WITHERBONE_POLE.getId().toString()).m_126132_("has_witherbone", (CriterionTriggerInstance)SpartanFire.has(WITHERBONE)).m_176500_(consumer, WITHERBONE_POLE.getId() + "_from_string");
        Map<SpartanMaterial, RegistryObject> dragonBlood = Map.of(FLAMED_DRAGON_BONE, IafItemRegistry.FIRE_DRAGON_BLOOD, ICED_DRAGON_BONE, IafItemRegistry.ICE_DRAGON_BLOOD, LIGHTNING_DRAGON_BONE, IafItemRegistry.LIGHTNING_DRAGON_BLOOD);
        WEAPONS.forEach((key, item) -> {
            SpartanMaterial material = (SpartanMaterial)key.first();
            WeaponType type = (WeaponType)key.second();
            if (material.equals(DESERT_MYRMEX_STINGER) || material.equals(JUNGLE_MYRMEX_STINGER)) {
                WEAPONS.keySet().stream().map(Pair::first).filter(material1 -> material1.getMaterialName().equals(material.getMaterialName().replace("stinger", "chitin"))).findAny().ifPresent(baseMaterial -> ConditionalShapelessRecipeBuilder.shapeless((ItemLike)((ItemLike)item.get())).requires((ItemLike)WEAPONS.get(baseMaterial, type).get()).requires((ItemLike)IafItemRegistry.MYRMEX_STINGER.get()).group("spartanweaponry:" + type.name().toLowerCase()).condition((ICondition)new TypeDisabledCondition(List.of(type.name().toLowerCase()))).unlockedBy("has_myrmex_stinger", (CriterionTriggerInstance)SpartanFire.has((ItemLike)((ItemLike)IafItemRegistry.MYRMEX_STINGER.get()))).save(consumer));
            } else if (material.equals(FLAMED_DRAGON_BONE) || material.equals(ICED_DRAGON_BONE) || material.equals(LIGHTNING_DRAGON_BONE)) {
                RegistryObject blood = (RegistryObject)dragonBlood.get(material);
                ConditionalShapelessRecipeBuilder.shapeless((ItemLike)((ItemLike)item.get())).requires((ItemLike)WEAPONS.get(DRAGON_BONE, type).get()).requires((ItemLike)blood.get()).group("spartanweaponry:" + type.name().toLowerCase()).condition((ICondition)new TypeDisabledCondition(List.of(type.name().toLowerCase()))).unlockedBy("has_" + blood.getId().m_135815_(), (CriterionTriggerInstance)SpartanFire.has((ItemLike)((ItemLike)blood.get()))).save(consumer);
            } else {
                type.recipe.accept((Object)this.getWeaponMap(), (Object)consumer, (Object)material);
            }
        });
    }

    public String modid() {
        return MODID;
    }

    public List<SpartanMaterial> getMaterials() {
        return MATERIALS;
    }

    public WeaponMap getWeaponMap() {
        return WEAPONS;
    }
}

