/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.IActionTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IRangedTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IThrowingTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.List;
import java.util.Optional;
import krelox.spartantoolkit.IBetterWeaponTrait;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryManager;

public class BetterWeaponTrait
extends WeaponTrait
implements IBetterWeaponTrait,
IMeleeTraitCallback,
IThrowingTraitCallback,
IRangedTraitCallback,
IActionTraitCallback {
    public BetterWeaponTrait(String typeIn, String modIdIn, WeaponTrait.TraitQuality qualityIn) {
        super(typeIn, modIdIn, qualityIn);
    }

    public String getDescription() {
        return "The author of this trait should provide a description or set it to null";
    }

    public Optional<IMeleeTraitCallback> getMeleeCallback() {
        if (this.isMelee) {
            return Optional.of(this);
        }
        return super.getMeleeCallback();
    }

    public Optional<IRangedTraitCallback> getRangedCallback() {
        if (this.isRanged) {
            return Optional.of(this);
        }
        return super.getRangedCallback();
    }

    public Optional<IThrowingTraitCallback> getThrowingCallback() {
        if (this.isThrowing) {
            return Optional.of(this);
        }
        return super.getThrowingCallback();
    }

    public Optional<IActionTraitCallback> getActionCallback() {
        if (this.isAction) {
            return Optional.of(this);
        }
        return super.getActionCallback();
    }

    @Override
    public float modifyRangedDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        if (this.getMeleeCallback().isPresent()) {
            return this.getMeleeCallback().get().modifyDamageDealt(material, baseDamage, source, attacker, victim);
        }
        return baseDamage;
    }

    @Override
    public float modifyRangedDamageTaken(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        if (this.getMeleeCallback().isPresent()) {
            return this.getMeleeCallback().get().modifyDamageTaken(material, baseDamage, source, attacker, victim);
        }
        return baseDamage;
    }

    @Override
    public void onRangedItemUpdate(WeaponMaterial material, ItemStack stack, Level level, LivingEntity entity, int itemSlot, boolean isSelected) {
        this.getMeleeCallback().ifPresent(callback -> callback.onItemUpdate(material, stack, level, entity, itemSlot, isSelected));
    }

    @Override
    public void onRangedHitEntity(WeaponMaterial material, ItemStack stack, LivingEntity target, LivingEntity attacker, Entity projectile) {
        this.getMeleeCallback().ifPresent(callback -> callback.onHitEntity(material, stack, target, attacker, projectile));
    }

    public InteractionResultHolder<ItemStack> use(ItemStack stack, Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected void addTooltipTitle(ItemStack stack, List<Component> tooltip, ChatFormatting ... formatting) {
        if (this.level == 0) {
            super.addTooltipTitle(stack, tooltip, formatting);
            return;
        }
        MutableComponent titleText = Component.m_237113_((String)"- ").m_130944_(formatting);
        tooltip.add((Component)titleText.m_7220_((Component)Component.m_237115_((String)String.format("tooltip.%s.trait.%s", this.modId, this.type))).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + this.level))));
    }

    protected void addTooltipDescription(ItemStack stack, List<Component> tooltip) {
        if (this.getDescription() == null) {
            return;
        }
        String registryName = RegistryManager.FROZEN.getRegistry(WeaponTraits.REGISTRY_KEY).getKey((Object)this).m_135815_();
        tooltip.add((Component)BetterWeaponTrait.tooltipIndent().m_7220_((Component)Component.m_237115_((String)String.format("tooltip.%s.trait.%s.desc", this.modId, registryName)).m_130944_(DESCRIPTION_FORMAT)));
    }
}

