/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit;

import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.data.model.ModelGenerator;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.data.ModWeaponTraitTagsProvider;
import com.oblivioussp.spartanweaponry.init.ModCreativeTabs;
import it.unimi.dsi.fastutil.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import krelox.spartantoolkit.BetterWeaponTrait;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponAttributeProvider;
import krelox.spartantoolkit.WeaponMap;
import krelox.spartantoolkit.WeaponType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public abstract class SpartanAddon {
    protected final List<SpartanMaterial> materials = this.getMaterials();

    protected final void registerSpartanWeapons(DeferredRegister<Item> items) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        for (WeaponType type : WeaponType.values()) {
            for (SpartanMaterial material : this.materials) {
                if (this.getBlacklist().contains(Pair.of((Object)((Object)material), (Object)((Object)type)))) continue;
                this.registerSpartanWeapon(items, material, type);
            }
        }
        bus.addListener(this::gatherData);
    }

    protected final void registerSpartanWeapon(DeferredRegister<Item> items, SpartanMaterial material, WeaponType type) {
        String name = material.getMaterialName() + "_" + type.name().toLowerCase(Locale.US);
        RegistryObject item = items.register(name, () -> type.createItem.apply(material));
        this.getWeaponMap().put(material, type, (RegistryObject<Item>)item);
    }

    public static DeferredRegister<Item> itemRegister(String modid) {
        return DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid);
    }

    public static DeferredRegister<WeaponTrait> traitRegister(String modid) {
        return DeferredRegister.create((ResourceKey)WeaponTraits.REGISTRY_KEY, (String)modid);
    }

    public static RegistryObject<WeaponTrait> registerTrait(DeferredRegister<WeaponTrait> traitRegister, WeaponTrait trait) {
        return traitRegister.register(trait.getType() + (String)(trait.getLevel() == 0 ? "" : "_" + trait.getLevel()), () -> trait);
    }

    public static DeferredRegister<CreativeModeTab> tabRegister(String modid) {
        return DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)modid);
    }

    public static RegistryObject<CreativeModeTab> registerTab(DeferredRegister<CreativeModeTab> tabs, String label, Supplier<Item> icon, CreativeModeTab.DisplayItemsGenerator displayItemsGenerator) {
        return tabs.register(label, () -> CreativeModeTab.builder().m_257737_(() -> SpartanAddon.lambda$registerTab$2((Supplier)icon)).m_257941_((Component)Component.m_237115_((String)("itemGroup." + label))).m_257501_(displayItemsGenerator).withTabsBefore(new ResourceLocation[]{ModCreativeTabs.MODDED.getId()}).withTabsAfter(new ResourceLocation[]{ModCreativeTabs.ARROWS_BOLTS.getId()}).m_257652_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike itemLike) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemLike}).m_45077_()});
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()});
    }

    protected void addTranslations(LanguageProvider provider, Function<RegistryObject<?>, String> formatName) {
        ModList.get().getModContainerById(this.modid()).ifPresent(mod -> provider.add("itemGroup." + this.modid(), mod.getModInfo().getDisplayName()));
        this.getWeaponMap().values().forEach(item -> provider.add((Item)item.get(), (String)formatName.apply((RegistryObject<?>)item)));
        this.getTraitDescriptions().forEach((trait, description) -> {
            provider.add("tooltip.%s.trait.%s".formatted(this.modid(), ((WeaponTrait)trait.get()).getType()), (String)formatName.apply((RegistryObject<?>)trait));
            provider.add("tooltip.%s.trait.%s.desc".formatted(this.modid(), trait.getId().m_135815_()), description);
        });
    }

    protected void registerModels(ItemModelProvider provider, ModelGenerator generator) {
        this.getWeaponMap().forEach((pair, item) -> ((WeaponType)((Object)((Object)pair.second()))).createModel.apply(generator, (Item)item.get()));
    }

    protected void addBlockTags(BlockTagsProvider provider, Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tag) {
    }

    protected void addItemTags(ItemTagsProvider provider, Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag) {
    }

    protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        this.getWeaponMap().forEach((pair, item) -> ((WeaponType)((Object)((Object)pair.second()))).recipe.accept((Object)this.getWeaponMap(), (Object)consumer, (Object)((SpartanMaterial)((Object)((Object)pair.first())))));
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        Consumer<DataProvider> client = provider -> generator.addProvider(event.includeClient(), provider);
        Consumer<DataProvider> server = provider -> generator.addProvider(event.includeServer(), provider);
        client.accept((DataProvider)new LanguageProvider(packOutput, this.modid(), "en_us"){

            protected void addTranslations() {
                SpartanAddon.this.addTranslations(this, registryObject -> Arrays.stream(registryObject.getId().m_135815_().replace("_heavy", "-Strengthened_heavy").replace("_longbow", "-Strengthened_longbow").split("_")).map(s -> NumberUtils.isParsable((String)s) ? "" : s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" ")).trim());
            }

            public void add(String key, String value) {
                try {
                    super.add(key, value);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
        client.accept((DataProvider)new ItemModelProvider(packOutput, this.modid(), fileHelper){

            protected void registerModels() {
                SpartanAddon.this.registerModels(this, new ModelGenerator((ItemModelProvider)this));
            }
        });
        server.accept((DataProvider)new ModWeaponTraitTagsProvider(packOutput, lookupProvider, fileHelper){

            protected void m_6577_(HolderLookup.Provider registry) {
                SpartanAddon.this.materials.forEach(material -> this.m_206424_(material.getTraitsTag()).m_255179_((Object[])((WeaponTrait[])material.traits.stream().map(RegistryObject::get).toArray(WeaponTrait[]::new))));
            }
        });
        BlockTagsProvider blockTags = new BlockTagsProvider(packOutput, lookupProvider, this.modid(), fileHelper){

            protected void m_6577_(@NotNull HolderLookup.Provider provider) {
                SpartanAddon.this.addBlockTags(this, x$0 -> this.m_206424_((TagKey)x$0));
            }
        };
        server.accept((DataProvider)blockTags);
        server.accept((DataProvider)new ItemTagsProvider(packOutput, lookupProvider, blockTags.m_274426_(), this.modid(), fileHelper){

            protected void m_6577_(@NotNull HolderLookup.Provider provider) {
                SpartanAddon.this.getWeaponMap().forEach((pair, item) -> this.m_206424_(((WeaponType)((Object)((Object)pair.second()))).tag).m_255245_((Object)((Item)item.get())));
                SpartanAddon.this.addItemTags(this, x$0 -> this.m_206424_((TagKey)x$0));
            }
        });
        server.accept((DataProvider)new RecipeProvider(packOutput){

            protected void m_245200_(@NotNull Consumer<FinishedRecipe> consumer) {
                SpartanAddon.this.buildCraftingRecipes(consumer);
            }
        });
        server.accept(new WeaponAttributeProvider(packOutput, fileHelper){

            @Override
            protected void registerAttributes() {
                this.spartanAttributes(SpartanAddon.this.getWeaponMap());
            }
        });
    }

    protected Set<Pair<SpartanMaterial, WeaponType>> getBlacklist() {
        return Set.of();
    }

    protected Map<RegistryObject<WeaponTrait>, String> getTraitDescriptions() {
        HashMap<RegistryObject<WeaponTrait>, String> map = new HashMap<RegistryObject<WeaponTrait>, String>();
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(WeaponTraits.REGISTRY_KEY);
        registry.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modid())).filter(entry -> entry.getValue() instanceof BetterWeaponTrait).forEach(entry -> map.put(RegistryObject.create((ResourceLocation)((ResourceKey)entry.getKey()).m_135782_(), (IForgeRegistry)registry), ((BetterWeaponTrait)entry.getValue()).getDescription()));
        return map;
    }

    public abstract String modid();

    public abstract List<SpartanMaterial> getMaterials();

    public abstract WeaponMap getWeaponMap();

    private static /* synthetic */ ItemStack lambda$registerTab$2(Supplier icon) {
        return ((Item)icon.get()).m_7968_();
    }
}

