/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.tags.ModWeaponTraitTags;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.init.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class SpartanMaterial
extends WeaponMaterial {
    public final Collection<RegistryObject<WeaponTrait>> traits;
    public final Map<Supplier<Enchantment>, Integer> enchantments;
    private float attackDamageModifier;
    private double attackSpeedModifier;
    private Rarity rarity = Rarity.COMMON;
    private TagKey<Item> planks = ItemTags.f_13168_;
    private TagKey<Item> stick = Tags.Items.RODS_WOODEN;
    private TagKey<Item> string = Tags.Items.STRING;
    private Supplier<? extends ItemLike> bow = () -> Items.f_42411_;
    private Supplier<? extends ItemLike> handle = ModItems.HANDLE;
    private Supplier<? extends ItemLike> pole = ModItems.POLE;

    public SpartanMaterial(String name, String modid, Tier tier, TagKey<Item> repairMaterial, Collection<RegistryObject<WeaponTrait>> traits, Map<Supplier<Enchantment>, Integer> enchantments) {
        super(name, modid, tier, repairMaterial, ModWeaponTraitTags.create((ResourceLocation)new ResourceLocation(modid, name)));
        this.traits = traits;
        this.enchantments = enchantments;
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public SpartanMaterial(String name, String modid, Tier tier, TagKey<Item> repairMaterial, Set<RegistryObject<WeaponTrait>> traits, Map<Supplier<Enchantment>, Integer> enchantments) {
        this(name, modid, tier, repairMaterial, (Collection<RegistryObject<WeaponTrait>>)traits, enchantments);
    }

    @SafeVarargs
    public SpartanMaterial(String name, String modid, Tier tier, TagKey<Item> repairMaterial, RegistryObject<WeaponTrait> ... traits) {
        this(name, modid, tier, repairMaterial, List.of(traits), Map.of());
    }

    public float m_6631_() {
        return super.m_6631_() + this.attackDamageModifier;
    }

    public SpartanMaterial setAttackDamageModifier(float attackDamageModifier) {
        this.attackDamageModifier = attackDamageModifier;
        return this;
    }

    public SpartanMaterial setAttackSpeedModifier(double attackSpeedModifier) {
        this.attackSpeedModifier = attackSpeedModifier;
        return this;
    }

    public SpartanMaterial setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public SpartanMaterial setPlanks(TagKey<Item> planks) {
        this.planks = planks;
        return this;
    }

    public SpartanMaterial setStick(TagKey<Item> stick) {
        this.stick = stick;
        return this;
    }

    public SpartanMaterial setString(TagKey<Item> string) {
        this.string = string;
        return this;
    }

    public SpartanMaterial setBow(Supplier<? extends ItemLike> bow) {
        this.bow = bow;
        return this;
    }

    public SpartanMaterial setHandle(Supplier<? extends ItemLike> handle) {
        this.handle = handle;
        return this;
    }

    public SpartanMaterial setPole(Supplier<? extends ItemLike> pole) {
        this.pole = pole;
        return this;
    }

    public float getAttackDamageModifier() {
        return this.attackDamageModifier;
    }

    public double getAttackSpeedModifier() {
        return this.attackSpeedModifier;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public TagKey<Item> getPlanks() {
        return this.planks;
    }

    public TagKey<Item> getStick() {
        return this.stick;
    }

    public TagKey<Item> getString() {
        return this.string;
    }

    public ItemLike getBow() {
        return this.bow.get();
    }

    public ItemLike getHandle() {
        return this.handle.get();
    }

    public ItemLike getPole() {
        return this.pole.get();
    }
}

