/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit;

import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import java.util.List;
import krelox.spartantoolkit.IBetterWeaponTrait;
import krelox.spartantoolkit.WeaponItem;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="spartantoolkit")
@Mod.EventBusSubscriber(modid="spartantoolkit")
public class SpartanToolkit {
    public static final String MODID = "spartantoolkit";

    @SubscribeEvent
    public static void onHitEntity(LivingAttackEvent event) {
        Item item;
        LivingEntity target = event.getEntity();
        Entity projectile = event.getSource().m_7640_();
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack stack = attacker.m_21205_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof WeaponItem) {
            WeaponItem weapon = (WeaponItem)item;
            WeaponMaterial material = weapon.getMaterial();
            if (!(weapon instanceof IWeaponTraitContainer)) {
                weapon.triggerEnabledTraits(material.getBonusTraits(WeaponType.RANGED), trait -> ((IBetterWeaponTrait)trait).onRangedHitEntity(material, stack, target, attacker, projectile), stack);
            } else {
                IWeaponTraitContainer container = (IWeaponTraitContainer)weapon;
                if (!(attacker instanceof Player)) {
                    weapon.triggerEnabledTraits(container.getAllWeaponTraits(), trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onHitEntity(material, stack, target, attacker, projectile)), stack);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHurtEntity(LivingHurtEvent event) {
        IBetterWeaponTrait betterTrait;
        List traits;
        Item material;
        WeaponItem weapon;
        Item item;
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (attacker == source.m_7640_()) {
            return;
        }
        ItemStack attackerStack = attacker.m_21205_();
        ItemStack targetStack = target.m_21205_();
        if (!attackerStack.m_41619_() && (item = attackerStack.m_41720_()) instanceof WeaponItem && (weapon = (WeaponItem)item).isRanged()) {
            material = weapon.getMaterial();
            traits = material.getBonusTraits(WeaponType.RANGED);
            if (traits == null) {
                return;
            }
            for (WeaponTrait trait : traits) {
                betterTrait = (IBetterWeaponTrait)trait;
                if (!betterTrait.isEnabled((WeaponMaterial)material, attackerStack)) continue;
                amount = betterTrait.modifyRangedDamageDealt((WeaponMaterial)material, amount, source, attacker, target);
            }
        }
        if (!targetStack.m_41619_() && (material = targetStack.m_41720_()) instanceof WeaponItem && (weapon = (WeaponItem)material).isRanged()) {
            material = weapon.getMaterial();
            traits = material.getBonusTraits(WeaponType.RANGED);
            if (traits == null) {
                return;
            }
            for (WeaponTrait trait : traits) {
                betterTrait = (IBetterWeaponTrait)trait;
                if (!betterTrait.isEnabled((WeaponMaterial)material, targetStack)) continue;
                amount = betterTrait.modifyRangedDamageTaken((WeaponMaterial)material, amount, source, attacker, target);
            }
        }
        if (amount != event.getAmount()) {
            event.setAmount(amount);
        }
    }
}

