/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.IActionTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import com.oblivioussp.spartanweaponry.item.LongbowItem;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import krelox.spartantoolkit.IBetterWeaponTrait;
import krelox.spartantoolkit.SpartanMaterial;
import net.minecraft.world.item.ItemStack;

public interface WeaponItem {
    public WeaponMaterial getMaterial();

    default public boolean isRanged() {
        return this instanceof LongbowItem || this instanceof HeavyCrossbowItem;
    }

    default public void triggerEnabledTraits(Collection<WeaponTrait> traits, Consumer<WeaponTrait> consumer, ItemStack stack) {
        if (traits != null) {
            traits.stream().filter(trait -> ((IBetterWeaponTrait)trait).isEnabled(this.getMaterial(), stack)).forEach(consumer);
        }
    }

    default public void triggerFirstEnabledActionTrait(ItemStack stack, Consumer<IActionTraitCallback> consumer) {
        WeaponMaterial weaponMaterial = this.getMaterial();
        if (weaponMaterial instanceof SpartanMaterial) {
            SpartanMaterial material = (SpartanMaterial)weaponMaterial;
            material.getBonusTraits(WeaponType.MELEE).stream().filter(WeaponTrait::isActionTrait).filter(trait -> ((IBetterWeaponTrait)trait).isEnabled(this.getMaterial(), stack)).findFirst().flatMap(WeaponTrait::getActionCallback).ifPresent(consumer);
        }
    }

    default public <T> T getFirstEnabledActionTraitResult(ItemStack stack, Function<IActionTraitCallback, T> result, Supplier<T> fallback) {
        WeaponMaterial weaponMaterial = this.getMaterial();
        if (weaponMaterial instanceof SpartanMaterial) {
            SpartanMaterial material = (SpartanMaterial)weaponMaterial;
            return material.getBonusTraits(WeaponType.MELEE).stream().filter(WeaponTrait::isActionTrait).filter(trait -> ((IBetterWeaponTrait)trait).isEnabled(this.getMaterial(), stack)).findFirst().flatMap(WeaponTrait::getActionCallback).map(result).orElseGet(fallback);
        }
        return fallback.get();
    }
}

