/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit.mixin;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.item.LongbowItem;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import krelox.spartantoolkit.IBetterWeaponTrait;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LongbowItem.class})
public class LongbowItemMixin
extends BowItem
implements WeaponItem {
    @Shadow(remap=false)
    protected WeaponMaterial material;
    @Shadow(remap=false)
    protected List<WeaponTrait> rangedTraits;
    @Shadow(remap=false)
    protected float drawTime;

    @Inject(method={"<init>(Lnet/minecraft/world/item/Item$Properties;Lcom/oblivioussp/spartanweaponry/api/WeaponMaterial;)V"}, at={@At(value="RETURN")}, remap=false)
    private void spartantoolkit_injectRarity(Item.Properties prop, WeaponMaterial material, CallbackInfo ci) {
        if (material instanceof SpartanMaterial) {
            SpartanMaterial spartanMaterial = (SpartanMaterial)material;
            this.f_41369_ = spartanMaterial.getRarity();
        }
    }

    @Redirect(method={"releaseUsing"}, at=@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V"))
    private void spartantoolkit_releaseUsing(Optional<IBetterWeaponTrait> optional, Consumer<IBetterWeaponTrait> action, ItemStack stack) {
        optional.filter(trait -> trait.isEnabled(this.material, stack)).ifPresent(action);
    }

    @Redirect(method={"appendHoverText"}, at=@At(value="INVOKE", target="Lcom/oblivioussp/spartanweaponry/api/WeaponMaterial;hasAnyBonusTraits(Lcom/oblivioussp/spartanweaponry/util/WeaponType;)Z", remap=false))
    private boolean spartantoolkit_appendHoverText(WeaponMaterial instance, WeaponType type) {
        return this.material.getBonusTraits(type).stream().anyMatch(trait -> ((IBetterWeaponTrait)trait).isEnabled(this.material, this.m_7968_()));
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    private void spartantoolkit_appendHoverText(ItemStack stack, Level levelIn, List<Component> tooltip, TooltipFlag flagIn, CallbackInfo ci) {
        this.drawTime = 1.25f;
        this.triggerEnabledTraits(this.rangedTraits, trait -> trait.getRangedCallback().ifPresent(callback -> {
            this.drawTime = callback.modifyLongbowDrawTime(this.material, this.drawTime);
        }), stack);
    }

    @Inject(method={"getNockProgress"}, at={@At(value="HEAD")}, remap=false)
    private void spartantoolkit_getNockProgress(ItemStack stack, LivingEntity shooter, CallbackInfoReturnable<Float> cir) {
        this.drawTime = 1.25f;
        this.triggerEnabledTraits(this.rangedTraits, trait -> trait.getRangedCallback().ifPresent(callback -> {
            this.drawTime = callback.modifyLongbowDrawTime(this.material, this.drawTime);
        }), stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        this.triggerEnabledTraits(this.rangedTraits, trait -> ((IBetterWeaponTrait)trait).onRangedItemUpdate(this.material, stack, level, (LivingEntity)entity, itemSlot, isSelected), stack);
    }

    @Override
    public WeaponMaterial getMaterial() {
        return this.material;
    }

    public LongbowItemMixin(Item.Properties properties) {
        super(properties);
    }
}

