/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantwilight;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.data.model.ModelGenerator;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import krelox.spartantoolkit.BetterWeaponTrait;
import krelox.spartantoolkit.SpartanAddon;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponMap;
import krelox.spartantoolkit.WeaponType;
import net.minecraft.Util;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.util.TwilightItemTier;

@Mod(value="spartantwilight")
public class SpartanTwilight
extends SpartanAddon {
    public static final String MODID = "spartantwilight";
    public static final WeaponMap WEAPONS = new WeaponMap();
    public static final DeferredRegister<Item> ITEMS = SpartanTwilight.itemRegister((String)"spartantwilight");
    public static final DeferredRegister<WeaponTrait> TRAITS = SpartanTwilight.traitRegister((String)"spartantwilight");
    public static final DeferredRegister<CreativeModeTab> TABS = SpartanTwilight.tabRegister((String)"spartantwilight");
    public static final RegistryObject<Item> BLAZE_POLE = ITEMS.register("blaze_pole", () -> new Item(new Item.Properties()));
    public static final RegistryObject<WeaponTrait> ARMORED_DAMAGE_BONUS = SpartanTwilight.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("armored_damage_bonus", "spartantwilight", WeaponTrait.TraitQuality.POSITIVE){
        private static final int KNIGHTMETAL_BONUS_DAMAGE = 2;

        public String getDescription() {
            return String.format(Locale.US, "+%.1f damage against armored foes", Float.valueOf(2.0f));
        }

        public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
            Level level = victim.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return baseDamage;
            }
            ServerLevel world = (ServerLevel)level;
            if (victim.m_21230_() > 0) {
                world.m_7726_().m_8394_((Entity)victim, (Packet)new ClientboundAnimatePacket((Entity)victim, 5));
                if (victim.m_21207_() > 0.0f) {
                    int moreBonus = (int)(2.0f * victim.m_21207_());
                    return baseDamage + (float)moreBonus;
                }
                return baseDamage + 2.0f;
            }
            return baseDamage;
        }
    }.setUniversal());
    public static final RegistryObject<WeaponTrait> BLAZING = SpartanTwilight.registerTrait(TRAITS, (WeaponTrait)new BetterWeaponTrait("blazing", "spartantwilight", WeaponTrait.TraitQuality.POSITIVE){

        public String getDescription() {
            return "Sets foes on fire for 15 seconds";
        }

        public void onHitEntity(WeaponMaterial material, ItemStack stack, LivingEntity target, LivingEntity attacker, Entity projectile) {
            Level level = target.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel world = (ServerLevel)level;
            if (!target.m_5825_()) {
                target.m_20254_(15);
            } else {
                for (int i = 0; i < 20; ++i) {
                    double px = target.m_20185_() + (double)(world.m_213780_().m_188501_() * target.m_20205_() * 2.0f) - (double)target.m_20205_();
                    double py = target.m_20186_() + (double)(world.m_213780_().m_188501_() * target.m_20206_());
                    double pz = target.m_20189_() + (double)(world.m_213780_().m_188501_() * target.m_20205_() * 2.0f) - (double)target.m_20205_();
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123744_, px, py, pz, 0, 0.02, 0.02, 0.02, 1.0);
                }
            }
        }
    }.setUniversal());
    public static final SpartanMaterial IRONWOOD = new SpartanMaterial("ironwood", "spartantwilight", TwilightItemTier.IRONWOOD, ItemTagGenerator.IRONWOOD_INGOTS, List.of(), Map.of(() -> Enchantments.f_44980_, 1, () -> Enchantments.f_44987_, 1, ModEnchantments.PROPEL, 1, () -> Enchantments.f_44989_, 1));
    public static final SpartanMaterial STEELEAF = new SpartanMaterial("steeleaf", "spartantwilight", TwilightItemTier.STEELEAF, ItemTagGenerator.STEELEAF_INGOTS, List.of(), Map.of(() -> Enchantments.f_44982_, 2, () -> Enchantments.f_44984_, 2, ModEnchantments.LUCKY_THROW, 2, () -> Enchantments.f_44960_, 2));
    public static final SpartanMaterial KNIGHTMETAL = new SpartanMaterial("knightmetal", "spartantwilight", TwilightItemTier.KNIGHTMETAL, ItemTagGenerator.KNIGHTMETAL_INGOTS, new RegistryObject[]{ARMORED_DAMAGE_BONUS});
    public static final SpartanMaterial FIERY = new SpartanMaterial("fiery", "spartantwilight", TwilightItemTier.FIERY, ItemTagGenerator.FIERY_INGOTS, new RegistryObject[]{WeaponTraits.FIREPROOF, BLAZING}).setRarity(Rarity.UNCOMMON).setHandle(() -> Items.f_42585_).setPole(BLAZE_POLE);
    public static final RegistryObject<CreativeModeTab> SPARTAN_TWILIGHT_TAB = SpartanTwilight.registerTab(TABS, (String)"spartantwilight", () -> (Item)WEAPONS.get(KNIGHTMETAL, WeaponType.BATTLEAXE).get(), (parameters, output) -> ITEMS.getEntries().forEach(item -> output.m_246326_((ItemLike)item.get())));
    private static final EnumMap<WeaponType, IntIntPair> MATERIAL_COUNTS = (EnumMap)Util.m_137469_(new EnumMap(WeaponType.class), map -> {
        map.put(WeaponType.DAGGER, IntIntPair.of((int)1, (int)1));
        map.put(WeaponType.LONGSWORD, IntIntPair.of((int)1, (int)4));
        map.put(WeaponType.KATANA, IntIntPair.of((int)1, (int)2));
        map.put(WeaponType.SABER, IntIntPair.of((int)1, (int)3));
        map.put(WeaponType.RAPIER, IntIntPair.of((int)1, (int)4));
        map.put(WeaponType.GREATSWORD, IntIntPair.of((int)1, (int)6));
        map.put(WeaponType.BATTLE_HAMMER, IntIntPair.of((int)1, (int)6));
        map.put(WeaponType.WARHAMMER, IntIntPair.of((int)1, (int)3));
        map.put(WeaponType.SPEAR, IntIntPair.of((int)2, (int)1));
        map.put(WeaponType.HALBERD, IntIntPair.of((int)2, (int)4));
        map.put(WeaponType.PIKE, IntIntPair.of((int)4, (int)1));
        map.put(WeaponType.LANCE, IntIntPair.of((int)3, (int)3));
        map.put(WeaponType.LONGBOW, IntIntPair.of((int)1, (int)2));
        map.put(WeaponType.HEAVY_CROSSBOW, IntIntPair.of((int)1, (int)2));
        map.put(WeaponType.THROWING_KNIFE, IntIntPair.of((int)1, (int)1));
        map.put(WeaponType.TOMAHAWK, IntIntPair.of((int)1, (int)2));
        map.put(WeaponType.JAVELIN, IntIntPair.of((int)2, (int)1));
        map.put(WeaponType.BOOMERANG, IntIntPair.of((int)0, (int)1));
        map.put(WeaponType.BATTLEAXE, IntIntPair.of((int)1, (int)5));
        map.put(WeaponType.FLANGED_MACE, IntIntPair.of((int)1, (int)3));
        map.put(WeaponType.GLAIVE, IntIntPair.of((int)2, (int)3));
        map.put(WeaponType.QUARTERSTAFF, IntIntPair.of((int)2, (int)1));
        map.put(WeaponType.SCYTHE, IntIntPair.of((int)2, (int)3));
        map.put(WeaponType.PARRYING_DAGGER, IntIntPair.of((int)1, (int)2));
    });

    public SpartanTwilight() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerSpartanWeapons(ITEMS);
        ITEMS.register(bus);
        TRAITS.register(bus);
        TABS.register(bus);
    }

    protected void addTranslations(LanguageProvider provider, Function<RegistryObject<?>, String> formatName) {
        super.addTranslations(provider, formatName);
        provider.add((Item)BLAZE_POLE.get(), "Blaze Pole");
    }

    protected void registerModels(ItemModelProvider provider, ModelGenerator generator) {
        super.registerModels(provider, generator);
        generator.createSimpleModel((Item)BLAZE_POLE.get(), new ResourceLocation("spartanweaponry", "item/base/pole"));
    }

    protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
        super.buildCraftingRecipes(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)BLAZE_POLE.get())).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42585_).m_126130_(" #").m_126130_("# ").m_126132_("has_blaze_rod", (CriterionTriggerInstance)SpartanTwilight.has((ItemLike)Items.f_42585_)).m_176498_(consumer);
        WEAPONS.forEach((key, item) -> {
            SpartanMaterial material = (SpartanMaterial)key.first();
            WeaponType type = (WeaponType)key.second();
            if (material.equals(FIERY)) {
                ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).m_126209_((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("spartanweaponry", "iron_" + type.name().toLowerCase()))).m_126186_(Ingredient.m_204132_((TagKey)ItemTagGenerator.FIERY_VIAL), MATERIAL_COUNTS.get(type).secondInt()).m_126186_(Ingredient.m_204132_((TagKey)Tags.Items.RODS_BLAZE), MATERIAL_COUNTS.get(type).firstInt()).m_126132_("has_item", (CriterionTriggerInstance)SpartanTwilight.has((TagKey)ItemTagGenerator.FIERY_VIAL)).m_126140_(consumer, new ResourceLocation(MODID, ForgeRegistries.ITEMS.getKey((Object)((Item)item.get())).m_135815_() + "_vial"));
            }
        });
    }

    public String modid() {
        return MODID;
    }

    public List<SpartanMaterial> getMaterials() {
        return List.of(IRONWOOD, FIERY, STEELEAF, KNIGHTMETAL);
    }

    public WeaponMap getWeaponMap() {
        return WEAPONS;
    }
}

