/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.sg_mg;

import com.mojang.logging.LogUtils;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.merlin204.sg_mg.SGMGConfig;
import org.merlin204.sg_mg.entity.MGPatch;
import org.merlin204.sg_mg.item.GolemWeaponType;
import org.slf4j.Logger;

@Mod(value="super_golem_mg")
public class SGMGMod {
    public static final String MOD_ID = "super_golem_mg";
    private static final Logger LOGGER = LogUtils.getLogger();

    public SGMGMod(FMLJavaModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SGMGConfig.SPEC);
    }

    public static GolemWeaponType getGolemWeaponType(MGPatch mgPatch) {
        Item main = ((MetalGolemEntity)mgPatch.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        Item off = ((MetalGolemEntity)mgPatch.getOriginal()).m_21120_(InteractionHand.OFF_HAND).m_41720_();
        if (SGMGConfig.swordItems.isEmpty()) {
            SGMGConfig.swordItems = ((List)SGMGConfig.GOLEM_SWORD.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
            SGMGConfig.axeItems = ((List)SGMGConfig.GOLEM_AXE.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
            SGMGConfig.spearItems = ((List)SGMGConfig.GOLEM_SPEAR.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
        }
        if (SGMGConfig.axeItems.contains(main) && SGMGConfig.axeItems.contains(off)) {
            return GolemWeaponType.DUAL_AXE;
        }
        if (SGMGConfig.swordItems.contains(main) && SGMGConfig.swordItems.contains(off)) {
            return GolemWeaponType.DUAL_SWORD;
        }
        if (SGMGConfig.swordItems.contains(main)) {
            return GolemWeaponType.SWORD;
        }
        if (SGMGConfig.axeItems.contains(main)) {
            return GolemWeaponType.AXE;
        }
        if (SGMGConfig.spearItems.contains(main)) {
            return GolemWeaponType.SPEAR;
        }
        return GolemWeaponType.NORMAL;
    }
}

