/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.sg_mg.entity;

import com.google.common.collect.Maps;
import com.merlin204.avalon.entity.ai.AvalonAnimatedAttackGoal;
import com.merlin204.avalon.entity.ai.AvalonCombatBehaviors;
import com.merlin204.sg.epicfight.gameassets.animations.SuperGolemAnimation;
import com.mojang.datafixers.util.Pair;
import com.mojang.text2speech.Narrator;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.merlin204.sg_mg.SGMGMod;
import org.merlin204.sg_mg.entity.ai.MGCombatBehaviors;
import org.merlin204.sg_mg.epicfight.gameassets.SGMGArmatures;
import org.merlin204.sg_mg.epicfight.gameassets.animation.ModularGolemAnimation;
import org.merlin204.sg_mg.item.GolemWeaponType;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class MGPatch
extends MobPatch<MetalGolemEntity> {
    protected Map<GolemWeaponType, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>> weaponLivingMotions;
    protected Map<GolemWeaponType, AvalonCombatBehaviors.Builder<MGPatch>> weaponAttackMotions;

    public MGPatch() {
        super((Faction)Factions.VILLAGER);
        this.setWeaponMotions();
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (WrappedGoal wrappedGoal : ((MetalGolemEntity)this.original).f_21345_.m_148105_()) {
            Goal goal = wrappedGoal.m_26015_();
            if (!(goal instanceof AvalonAnimatedAttackGoal)) continue;
            toRemove.add(goal);
        }
    }

    protected void initAI() {
        super.initAI();
        this.setAIAsInfantry();
    }

    public Armature getArmature() {
        return SGMGArmatures.MG_ARMATURE.get();
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
    }

    protected void setWeaponMotions() {
        this.weaponLivingMotions = Maps.newHashMap();
        this.weaponLivingMotions.put(GolemWeaponType.NORMAL, Set.of(Pair.of((Object)LivingMotions.IDLE, (Object)SuperGolemAnimation.SG_IDLE), Pair.of((Object)LivingMotions.WALK, (Object)SuperGolemAnimation.SG_WALK), Pair.of((Object)LivingMotions.DEATH, (Object)SuperGolemAnimation.SG_DEATH), Pair.of((Object)LivingMotions.FALL, (Object)SuperGolemAnimation.SG_FALL)));
        this.weaponLivingMotions.put(GolemWeaponType.DUAL_AXE, Set.of(Pair.of((Object)LivingMotions.IDLE, ModularGolemAnimation.DUAL_AXE_IDLE), Pair.of((Object)LivingMotions.WALK, ModularGolemAnimation.DUAL_AXE_WALK), Pair.of((Object)LivingMotions.DEATH, ModularGolemAnimation.DUAL_AXE_DEATH), Pair.of((Object)LivingMotions.FALL, ModularGolemAnimation.DUAL_AXE_FALL)));
        this.weaponLivingMotions.put(GolemWeaponType.AXE, Set.of(Pair.of((Object)LivingMotions.IDLE, ModularGolemAnimation.AXE_IDLE), Pair.of((Object)LivingMotions.WALK, ModularGolemAnimation.AXE_WALK), Pair.of((Object)LivingMotions.DEATH, ModularGolemAnimation.AXE_DEATH), Pair.of((Object)LivingMotions.FALL, ModularGolemAnimation.AXE_FALL)));
        this.weaponLivingMotions.put(GolemWeaponType.SWORD, Set.of(Pair.of((Object)LivingMotions.IDLE, ModularGolemAnimation.SWORD_IDLE), Pair.of((Object)LivingMotions.WALK, ModularGolemAnimation.SWORD_WALK), Pair.of((Object)LivingMotions.DEATH, ModularGolemAnimation.SWORD_DEATH), Pair.of((Object)LivingMotions.FALL, ModularGolemAnimation.SWORD_FALL)));
        this.weaponLivingMotions.put(GolemWeaponType.DUAL_SWORD, Set.of(Pair.of((Object)LivingMotions.IDLE, ModularGolemAnimation.DUAL_SWORD_IDLE), Pair.of((Object)LivingMotions.WALK, ModularGolemAnimation.DUAL_SWORD_WALK), Pair.of((Object)LivingMotions.DEATH, ModularGolemAnimation.DUAL_SWORD_DEATH), Pair.of((Object)LivingMotions.FALL, ModularGolemAnimation.DUAL_SWORD_FALL)));
        this.weaponLivingMotions.put(GolemWeaponType.SPEAR, Set.of(Pair.of((Object)LivingMotions.IDLE, ModularGolemAnimation.SPEAR_IDLE), Pair.of((Object)LivingMotions.WALK, ModularGolemAnimation.SPEAR_WALK), Pair.of((Object)LivingMotions.DEATH, ModularGolemAnimation.SPEAR_DEATH), Pair.of((Object)LivingMotions.FALL, ModularGolemAnimation.SPEAR_FALL)));
        this.weaponAttackMotions = Maps.newHashMap();
        this.weaponAttackMotions.put(GolemWeaponType.NORMAL, MGCombatBehaviors.NORMAL);
        this.weaponAttackMotions.put(GolemWeaponType.DUAL_AXE, MGCombatBehaviors.DUAL_AXE);
        this.weaponAttackMotions.put(GolemWeaponType.AXE, MGCombatBehaviors.AXE);
        this.weaponAttackMotions.put(GolemWeaponType.SWORD, MGCombatBehaviors.SWORD);
        this.weaponAttackMotions.put(GolemWeaponType.DUAL_SWORD, MGCombatBehaviors.DUAL_SWORD);
        this.weaponAttackMotions.put(GolemWeaponType.SPEAR, MGCombatBehaviors.SPEAR);
    }

    public void onStartTracking(ServerPlayer trackingPlayer) {
        this.modifyLivingMotionByCurrentItem(true);
    }

    protected AvalonCombatBehaviors.Builder<MGPatch> getHoldingItemWeaponMotionBuilder() {
        GolemWeaponType weaponType = SGMGMod.getGolemWeaponType(this);
        if (weaponType != null && this.weaponAttackMotions != null && this.weaponAttackMotions.containsKey((Object)weaponType)) {
            return this.weaponAttackMotions.get((Object)weaponType);
        }
        return MGCombatBehaviors.NORMAL;
    }

    public void setAIAsInfantry() {
        AvalonCombatBehaviors.Builder<MGPatch> builder = this.getHoldingItemWeaponMotionBuilder();
        System.out.println(builder);
        if (builder != null) {
            ((MetalGolemEntity)this.original).f_21345_.m_25352_(0, (Goal)new AvalonAnimatedAttackGoal((MobPatch)this, builder.build((MobPatch)this)));
        }
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, (AssetAccessor)SuperGolemAnimation.SG_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, (AssetAccessor)SuperGolemAnimation.SG_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, (AssetAccessor)SuperGolemAnimation.SG_DEATH);
        animator.addLivingAnimation((LivingMotion)LivingMotions.FALL, (AssetAccessor)SuperGolemAnimation.SG_FALL);
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        this.initAI();
        this.modifyLivingMotionByCurrentItem(false);
        super.updateHeldItem(fromCap, toCap, from, to, hand);
    }

    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((MetalGolemEntity)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.INACTION : (((MetalGolemEntity)this.original).m_20202_() != null ? LivingMotions.MOUNT : (!(((MetalGolemEntity)this.original).m_20184_().f_82480_ < (double)-0.55f) && !this.isAirborneState() ? (((MetalGolemEntity)this.original).f_267362_.m_267731_() > 0.05f ? LivingMotions.WALK : LivingMotions.IDLE) : LivingMotions.FALL)));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        if (this.getAdvancedHoldingItemCapability(hand) == null) {
            return (SoundEvent)EpicFightSounds.BLUNT_HIT_HARD.get();
        }
        return this.getAdvancedHoldingItemCapability(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        if (this.getAdvancedHoldingItemCapability(hand) == null) {
            return (SoundEvent)EpicFightSounds.WHOOSH_BIG.get();
        }
        return this.getAdvancedHoldingItemCapability(hand).getSmashingSound();
    }

    public Collider getColliderMatching(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getWeaponCollider();
    }

    public CapabilityItem getAdvancedHoldingItemCapability(InteractionHand hand) {
        GolemWeaponType.MGWeaponRenderType renderType = SGMGMod.getGolemWeaponType((MGPatch)this).TYPE;
        switch (hand) {
            case MAIN_HAND: {
                if (renderType == GolemWeaponType.MGWeaponRenderType.LEFT || renderType == GolemWeaponType.MGWeaponRenderType.NULL) {
                    return CapabilityItem.EMPTY;
                }
                return this.getHoldingItemCapability(hand);
            }
            case OFF_HAND: {
                if (renderType == GolemWeaponType.MGWeaponRenderType.RIGHT || renderType == GolemWeaponType.MGWeaponRenderType.NULL) {
                    return CapabilityItem.EMPTY;
                }
                return this.getHoldingItemCapability(hand);
            }
        }
        return CapabilityItem.EMPTY;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        ResourceLocation metalGolemId = ResourceLocation.fromNamespaceAndPath((String)"modulargolems", (String)"metal_golem");
        EntityType metalGolemType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(metalGolemId);
        if (metalGolemType != null) {
            event.add(metalGolemType, (Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0);
            event.add(metalGolemType, (Attribute)EpicFightAttributes.IMPACT.get(), 30.0);
            event.add(metalGolemType, (Attribute)EpicFightAttributes.WEIGHT.get(), 200.0);
        } else {
            Narrator.LOGGER.error("Failed to find Metal Golem entity type: {}", (Object)metalGolemId);
        }
    }

    public void modifyLivingMotionByCurrentItem(boolean onStartTracking) {
        Map oldLivingAnimations = this.getAnimator().getLivingAnimations();
        HashMap newLivingAnimations = Maps.newHashMap();
        GolemWeaponType golemWeaponType = SGMGMod.getGolemWeaponType(this);
        boolean hasChange = false;
        if (this.weaponLivingMotions != null && golemWeaponType != null && this.weaponLivingMotions.containsKey((Object)golemWeaponType)) {
            Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> animModifierSet = this.weaponLivingMotions.get((Object)golemWeaponType);
            Iterator iterator = animModifierSet.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                LivingMotion motion = (LivingMotion)pair.getFirst();
                AnimationManager.AnimationAccessor newAnim = (AnimationManager.AnimationAccessor)pair.getSecond();
                if (oldLivingAnimations.containsKey(motion)) {
                    if (oldLivingAnimations.get(motion) != newAnim) {
                        hasChange = true;
                    }
                } else {
                    hasChange = true;
                }
                newLivingAnimations.put(motion, newAnim);
            }
        }
        if (!hasChange) {
            for (LivingMotion oldMotion : oldLivingAnimations.keySet()) {
                if (newLivingAnimations.containsKey(oldMotion)) continue;
                hasChange = true;
                break;
            }
        }
        if (hasChange || onStartTracking) {
            this.getAnimator().resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> ((Animator)this.getAnimator()).addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((MetalGolemEntity)this.original).m_19879_());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original, (Object[])new Object[0]);
        }
    }
}

