/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.sg_mg.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.modulargolems.content.client.override.ModelOverrides;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemModel;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import dev.xkmc.modulargolems.content.item.equipments.GolemModelItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.merlin204.sg_mg.SGMGMod;
import org.merlin204.sg_mg.entity.MGPatch;
import org.merlin204.sg_mg.entity.client.MGRenderer;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.mixin.client.MixinLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class PatchedMGRenderer
extends PatchedLivingEntityRenderer<MetalGolemEntity, MGPatch, MetalGolemModel, MGRenderer, SkinnedMesh> {
    private static final Meshes.MeshAccessor<SkinnedMesh> LEG = Meshes.MeshAccessor.create((String)"super_golem_mg", (String)"entity/golem_leg", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    private static final Meshes.MeshAccessor<SkinnedMesh> BODY = Meshes.MeshAccessor.create((String)"super_golem_mg", (String)"entity/golem_body", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    private static final Meshes.MeshAccessor<SkinnedMesh> LEFT = Meshes.MeshAccessor.create((String)"super_golem_mg", (String)"entity/golem_left", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    private static final Meshes.MeshAccessor<SkinnedMesh> RIGHT = Meshes.MeshAccessor.create((String)"super_golem_mg", (String)"entity/golem_right", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    private final MGMeshPart MESH_LEG = new MGMeshPart((SkinnedMesh)LEG.get(), MetalGolemPartType.LEG);
    private final MGMeshPart MESH_LEFT = new MGMeshPart((SkinnedMesh)LEFT.get(), MetalGolemPartType.LEFT);
    private final MGMeshPart MESH_RIGHT = new MGMeshPart((SkinnedMesh)RIGHT.get(), MetalGolemPartType.RIGHT);
    private final MGMeshPart MESH_BODY = new MGMeshPart((SkinnedMesh)BODY.get(), MetalGolemPartType.BODY);

    public PatchedMGRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
    }

    public void render(MetalGolemEntity entity, MGPatch entitypatch, MGRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        MixinLivingEntityRenderer livingEntityRendererAccessor = (MixinLivingEntityRenderer)renderer;
        boolean isVisible = true;
        boolean isVisibleToPlayer = !isVisible && !entity.m_20177_((Player)mc.f_91074_);
        boolean isGlowing = mc.m_91314_((Entity)entity);
        SkinnedMesh mesh = (SkinnedMesh)this.getMeshProvider((LivingEntityPatch)entitypatch).get();
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, (LivingEntity)entity, (LivingEntityPatch)entitypatch, partialTicks);
        this.setArmaturePose((LivingEntityPatch)entitypatch, armature, partialTicks);
        this.drawMeshPart(this.MESH_LEG, entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks, isVisible, isVisibleToPlayer, isGlowing);
        this.drawMeshPart(this.MESH_BODY, entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks, isVisible, isVisibleToPlayer, isGlowing);
        this.drawMeshPart(this.MESH_LEFT, entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks, isVisible, isVisibleToPlayer, isGlowing);
        this.drawMeshPart(this.MESH_RIGHT, entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks, isVisible, isVisibleToPlayer, isGlowing);
        this.drawItem(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks, isVisible, isVisibleToPlayer, isGlowing);
        this.drawArmorMesh(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks, isVisible, isVisibleToPlayer, isGlowing);
        if (entity.m_21223_() <= entity.m_21233_() * 0.25f) {
            mesh.draw(poseStack, buffer, RenderType.m_110458_((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/iron_golem/iron_golem_crackiness_high.png")), packedLight, 1.0f, 1.0f, 1.0f, 0.8f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        } else if (entity.m_21223_() <= entity.m_21233_() * 0.5f) {
            mesh.draw(poseStack, buffer, RenderType.m_110458_((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/iron_golem/iron_golem_crackiness_medium.png")), packedLight, 1.0f, 1.0f, 1.0f, 0.8f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        } else if (entity.m_21223_() <= entity.m_21233_() * 0.75f) {
            mesh.draw(poseStack, buffer, RenderType.m_110458_((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/iron_golem/iron_golem_crackiness_low.png")), packedLight, 1.0f, 1.0f, 1.0f, 0.8f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        }
        this.renderLayer((LivingEntityRenderer)renderer, (LivingEntityPatch)entitypatch, (LivingEntity)entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
    }

    public AssetAccessor<SkinnedMesh> getDefaultMesh() {
        return Meshes.MeshAccessor.create((String)"super_golem_mg", (String)"entity/mg_golem", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    private void drawItem(MetalGolemEntity entity, MGPatch entitypatch, MGRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks, boolean visible, boolean isVisibleToPlayer, boolean glowing) {
        ItemStack offHandStack = ((MetalGolemEntity)entitypatch.getOriginal()).m_21206_();
        ItemStack mainHandStack = ((MetalGolemEntity)entitypatch.getOriginal()).m_21205_();
        RenderEngine renderEngine = ClientEngine.getInstance().renderEngine;
        Armature armature = entitypatch.getArmature();
        switch (SGMGMod.getGolemWeaponType((MGPatch)entitypatch).TYPE) {
            case RIGHT: {
                if (mainHandStack.m_41720_() == Items.f_41852_) break;
                renderEngine.getItemRenderer(mainHandStack).renderItemInHand(mainHandStack, (LivingEntityPatch)entitypatch, InteractionHand.MAIN_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
                break;
            }
            case LEFT: {
                if (offHandStack.m_41720_() == Items.f_41852_) break;
                renderEngine.getItemRenderer(offHandStack).renderItemInHand(offHandStack, (LivingEntityPatch)entitypatch, InteractionHand.OFF_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
                break;
            }
            case ALL: {
                if (mainHandStack.m_41720_() != Items.f_41852_) {
                    renderEngine.getItemRenderer(mainHandStack).renderItemInHand(mainHandStack, (LivingEntityPatch)entitypatch, InteractionHand.MAIN_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
                }
                if (offHandStack.m_41720_() == Items.f_41852_) break;
                renderEngine.getItemRenderer(offHandStack).renderItemInHand(offHandStack, (LivingEntityPatch)entitypatch, InteractionHand.OFF_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
                break;
            }
        }
    }

    private void drawArmorMesh(MetalGolemEntity entity, MGPatch entitypatch, MGRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks, boolean visible, boolean isVisibleToPlayer, boolean glowing) {
        Armature armature = entitypatch.getArmature();
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(e);
            Item item = stack.m_41720_();
            if (!(item instanceof GolemModelItem)) continue;
            GolemModelItem mgaitem = (GolemModelItem)item;
            SkinnedMesh mesh = (SkinnedMesh)Meshes.MeshAccessor.create((String)mgaitem.getModelPath().m_135827_(), (String)("sgmg/" + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_()), jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new)).get();
            mesh.draw(poseStack, buffer, RenderType.m_110431_((ResourceLocation)mgaitem.getModelTexture()), packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord((LivingEntity)entity, (LivingEntityPatch)entitypatch, partialTicks), armature, armature.getPoseMatrices());
            if (!mgaitem.emissive()) continue;
            mesh.draw(poseStack, buffer, RenderType.m_110431_((ResourceLocation)mgaitem.getEmissiveModelTexture()), 0xF000F0, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord((LivingEntity)entity, (LivingEntityPatch)entitypatch, partialTicks), armature, armature.getPoseMatrices());
        }
    }

    private void drawMeshPart(MGMeshPart mgMeshPart, MetalGolemEntity entity, MGPatch entitypatch, MGRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks, boolean visible, boolean isVisibleToPlayer, boolean glowing) {
        RenderType rt;
        MetalGolemModel model = (MetalGolemModel)renderer.m_7200_();
        Armature armature = entitypatch.getArmature();
        ResourceLocation id = ((GolemMaterial)entity.getMaterials().get(mgMeshPart.metalGolemPartType.ordinal())).id();
        ResourceLocation tex = model.getTextureLocationInternal(id);
        mgMeshPart.mesh.draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)tex), packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord((LivingEntity)entity, (LivingEntityPatch)entitypatch, partialTicks), armature, armature.getPoseMatrices());
        ResourceLocation etex = model.getTextureLocationInternal(tex.m_266382_("_emissive"));
        if (ModelOverrides.isValid((ResourceLocation)etex) && (rt = this.getRenderType((MetalGolemModel)renderer.m_7200_(), etex, visible, isVisibleToPlayer, glowing)) != null) {
            mgMeshPart.mesh.draw(poseStack, buffer, RenderType.m_234338_((ResourceLocation)etex), 0xF000F0, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, this.getOverlayCoord((LivingEntity)entity, (LivingEntityPatch)entitypatch, partialTicks), armature, armature.getPoseMatrices());
        }
    }

    protected <M extends EntityModel<?>> RenderType getRenderType(M model, ResourceLocation tex, boolean visible, boolean ghost, boolean glowing) {
        if (ghost) {
            return RenderType.m_110467_((ResourceLocation)tex);
        }
        if (visible) {
            return model.m_103119_(tex);
        }
        return glowing ? RenderType.m_110491_((ResourceLocation)tex) : null;
    }

    private class MGMeshPart {
        private final SkinnedMesh mesh;
        private final MetalGolemPartType metalGolemPartType;

        private MGMeshPart(SkinnedMesh mesh, MetalGolemPartType metalGolemPartType) {
            this.mesh = mesh;
            this.metalGolemPartType = metalGolemPartType;
        }
    }
}

