/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;

    public BarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41720_() == Items.f_42574_) {
            itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(handIn));
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            } else if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                worldIn.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 3);
            }
            ItemEntity entity2 = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)BlockSetup.HALF_BARRELS.get(DyeColor.WHITE.m_41060_()).get()));
            ItemEntity entity1 = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)BlockSetup.HALF_BARRELS.get(DyeColor.WHITE.m_41060_()).get()));
            worldIn.m_7967_((Entity)entity2);
            worldIn.m_7967_((Entity)entity1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        SWEMHorseEntityBase horse;
        if (!ServerConfig.fireworkDisplay) {
            return;
        }
        if (!(pEntity instanceof SWEMHorseEntityBase) || !(horse = (SWEMHorseEntityBase)pEntity).m_20160_()) {
            return;
        }
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER && !pLevel.m_5776_() && !((Boolean)pState.m_61143_((Property)TRIGGERED)).booleanValue()) {
            pLevel.m_7967_((Entity)new FireworkRocketEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)(pPos.m_123342_() + 2), (double)pPos.m_123343_() + 0.5, this.getFirework(DyeColor.RED, 1)));
            pLevel.m_186460_(pPos, pState.m_60734_(), 20);
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
    }

    private ItemStack getFirework(DyeColor pColor, int pFlightTime) {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42688_, 1);
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag compoundtag = itemstack1.m_41698_("Explosion");
        ArrayList list = Lists.newArrayList();
        list.add(pColor.m_41070_());
        compoundtag.m_128408_("Colors", (List)list);
        compoundtag.m_128344_("Type", (byte)FireworkRocketItem.Shape.BURST.m_41236_());
        CompoundTag compoundtag1 = itemstack.m_41698_("Fireworks");
        ListTag listtag = new ListTag();
        CompoundTag compoundtag2 = itemstack1.m_41737_("Explosion");
        if (compoundtag2 != null) {
            listtag.add((Object)compoundtag2);
        }
        compoundtag1.m_128344_("Flight", (byte)pFlightTime);
        if (!listtag.isEmpty()) {
            compoundtag1.m_128365_("Explosions", (Tag)listtag);
        }
        return itemstack;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)1.45, (double)0.99).m_83216_(0.0, -1.0, 0.0);
        }
        return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)1.45, (double)0.99);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == this.getNeighbourDirection((DoubleBlockHalf)pState.m_61143_(HALF))) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != pState.m_61143_(HALF) ? pState : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        return blockpos.m_123342_() < pContext.m_43725_().m_151558_() && pContext.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(pContext) ? super.m_5573_(pContext) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (!pLevel.m_5776_()) {
            BlockPos blockpos = pPos.m_121945_(Direction.UP);
            pLevel.m_7731_(blockpos, (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            pLevel.m_6289_(pPos, Blocks.f_50016_);
            pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pState.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (pState.m_60734_() != this) {
            return super.m_7898_(pState, pLevel, pPos);
        }
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.m_5776_()) {
            if (pPlayer.m_7500_()) {
                this.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
            } else {
                BarrelBlock.m_49881_((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)pPlayer, (ItemStack)pPlayer.m_21120_(pPlayer.m_7655_()));
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @javax.annotation.Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, Blocks.f_50016_.m_49966_(), pTe, pStack);
    }

    private Direction getNeighbourDirection(DoubleBlockHalf part) {
        return part == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
    }

    protected void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_121945_(this.getNeighbourDirection(doubleblockhalf)))).m_60734_() == pState.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, TRIGGERED});
    }
}

