/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HalfDoorBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final BlockSetType type;

    public HalfDoorBlock(BlockBehaviour.Properties builder, BlockSetType type) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT));
        this.type = type;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHingeSide(context));
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = iblockreader.m_8055_(blockpos2);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos4);
        int i = (blockstate.m_60838_((BlockGetter)iblockreader, blockpos2) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)iblockreader, blockpos4) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this);
        boolean flag1 = blockstate2.m_60713_((Block)this);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vector3d = context.m_43720_();
                double d0 = vector3d.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vector3d.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand handIn, BlockHitResult hit) {
        if (!pLevel.f_46443_) {
            pState = (BlockState)pState.m_61122_((Property)OPEN);
            pLevel.m_7731_(pPos, pState, 10);
            this.playSound(pPlayer, pLevel, pPos, pState);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void openDoor(Level worldIn, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    private void playSound(Player pPlayer, Level pLevel, BlockPos pPos, BlockState pState) {
        pLevel.m_142346_((Entity)pPlayer, this.isOpen(pState) ? GameEvent.f_157796_ : GameEvent.f_157793_, pPos);
        pLevel.m_5594_(null, pPos, this.isOpen(pState) ? this.type.f_271141_() : this.type.f_271502_(), SoundSource.BLOCKS, 1.0f, pLevel.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HINGE});
    }
}

