/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HitchingPostBase
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty CUSTOM_LEAD = BlockStateProperties.f_61431_;
    private final HitchingPostType type;

    public HitchingPostBase(HitchingPostType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)CUSTOM_LEAD, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.0, (double)16.0, (double)6.0, (double)10.0, (double)30.0, (double)10.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (BooleanOp)BooleanOp.f_82695_);
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return shape.m_83216_(0.0, -1.0, 0.0);
        }
        return shape;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        return blockpos.m_123342_() < context.m_43725_().m_151558_() - 1 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_()) : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{HALF});
        builder.m_61104_(new Property[]{CUSTOM_LEAD});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41720_() == Items.f_42574_) {
            itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(handIn));
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 19);
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 19);
            } else if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                level.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 19);
            }
            level.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)state));
            Item miniHitching = switch (this.type) {
                case HitchingPostType.ENGLISH -> ((Block)BlockSetup.ENGLISH_HITCHING_POST_MINI.get()).m_5456_();
                case HitchingPostType.WESTERN -> ((Block)BlockSetup.WESTERN_HITCHING_POST_MINI.get()).m_5456_();
                default -> ((Block)BlockSetup.PASTURE_HITCHING_POST_MINI.get()).m_5456_();
            };
            ItemEntity entity2 = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)miniHitching));
            ItemEntity entity1 = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)miniHitching));
            level.m_7967_((Entity)entity2);
            level.m_7967_((Entity)entity1);
            return InteractionResult.SUCCESS;
        }
        if (level.m_5776_()) {
            return itemstack.m_41720_() == Items.f_42655_ ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        BlockPos pPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos;
        LeashFenceKnotEntity leashknotentity = null;
        boolean flag = false;
        double d0 = 7.0;
        int i = pPos.m_123341_();
        int j = pPos.m_123342_();
        int k = pPos.m_123343_();
        for (SWEMHorseEntityBase mobentity : level.m_45976_(SWEMHorseEntityBase.class, new AABB((double)i - 7.0, (double)j - 7.0, (double)k - 7.0, (double)i + 7.0, (double)j + 7.0, (double)k + 7.0))) {
            if (mobentity.m_21524_() != player) continue;
            if (leashknotentity == null) {
                leashknotentity = LeashFenceKnotEntity.m_31844_((Level)level, (BlockPos)pPos);
            }
            mobentity.m_21463_((Entity)leashknotentity, true);
            flag = true;
        }
        if (leashknotentity != null) {
            leashknotentity.m_6842_(true);
            leashknotentity.m_6034_(leashknotentity.m_20185_(), leashknotentity.m_20186_() - 0.3125, leashknotentity.m_20189_());
            BlockState toChange = level.m_8055_(pPos);
            level.m_7731_(pPos, (BlockState)toChange.m_61124_((Property)CUSTOM_LEAD, (Comparable)Boolean.valueOf(true)), 3);
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        if (!worldIn.m_5776_()) {
            BlockPos blockpos = pos.m_121945_(Direction.UP);
            worldIn.m_7731_(blockpos, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            worldIn.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == this.getNeighbourDirection((DoubleBlockHalf)pState.m_61143_(HALF))) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != pState.m_61143_(HALF) ? pState : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private Direction getNeighbourDirection(DoubleBlockHalf part) {
        return part == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.m_5776_()) {
            if (pPlayer.m_7500_()) {
                this.preventCreativeDropFromOtherHalf(pLevel, pPos, pState, pPlayer);
            } else {
                HitchingPostBase.m_49881_((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)pPlayer, (ItemStack)pPlayer.m_21120_(pPlayer.m_7655_()));
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, Blocks.f_50016_.m_49966_(), pTe, pStack);
    }

    protected void preventCreativeDropFromOtherHalf(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf part = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (part == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_121945_(this.getNeighbourDirection(part)))).m_60734_() == this && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public static enum HitchingPostType {
        WESTERN(Block.m_49796_((double)5.0, (double)0.0, (double)9.0, (double)11.0, (double)32.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)7.0, (double)32.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)32.0, (double)7.0), Block.m_49796_((double)9.0, (double)0.0, (double)5.0, (double)15.0, (double)32.0, (double)11.0)),
        ENGLISH(Block.m_49796_((double)5.0, (double)0.0, (double)8.0, (double)11.0, (double)32.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)8.0, (double)32.0, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)32.0, (double)8.0), Block.m_49796_((double)8.0, (double)0.0, (double)5.0, (double)14.0, (double)32.0, (double)11.0)),
        PASTURE(Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)32.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)6.0, (double)32.0, (double)10.0), Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)32.0, (double)6.0), Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)14.0, (double)32.0, (double)10.0));

        private final VoxelShape north;
        private final VoxelShape east;
        private final VoxelShape south;
        private final VoxelShape west;

        private HitchingPostType(VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
            this.north = north;
            this.east = east;
            this.south = south;
            this.west = west;
        }

        public VoxelShape getVoxelShape(Direction facing) {
            switch (facing) {
                case EAST: {
                    return this.east;
                }
                case SOUTH: {
                    return this.south;
                }
                case WEST: {
                    return this.west;
                }
            }
            return this.north;
        }
    }
}

