/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.blocks;

import com.alaharranhonor.swem.forge.blocks.NonParallelBlock;
import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WaterTroughBlock
extends NonParallelBlock {
    public static final IntegerProperty LEVEL = SWEMBlockStateProperties.LEVEL_0_16;

    public WaterTroughBlock(BlockBehaviour.Properties properties, DyeColor colour) {
        super(properties, colour);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)1.5, (double)0.99);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41619_()) {
            return InteractionResult.PASS;
        }
        int i = (Integer)state.m_61143_((Property)LEVEL);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42447_) {
            if (i < 16 && !worldIn.f_46443_) {
                if (!player.m_7500_()) {
                    player.m_21008_(handIn, new ItemStack((ItemLike)Items.f_42446_));
                }
                player.m_36220_(Stats.f_12943_);
                this.setWaterLevel(worldIn, pos, state, false);
                worldIn.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (item == Items.f_42446_) {
            if (i >= 1 && !worldIn.f_46443_) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                    if (itemstack.m_41619_()) {
                        player.m_21008_(handIn, new ItemStack((ItemLike)Items.f_42447_));
                    } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42447_))) {
                        player.m_36176_(new ItemStack((ItemLike)Items.f_42447_), false);
                    }
                }
                player.m_36220_(Stats.f_12944_);
                this.setWaterLevel(worldIn, pos, state, true);
                worldIn.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void setWaterLevel(Level level, BlockPos pos, BlockState state, boolean removeWater) {
        Set<Object> states = new HashSet();
        Set<Object> positions = new HashSet();
        if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT) {
            states = this.fetchConnectionStates(state, (LevelReader)level, pos, true);
            positions = this.fetchConnectionPos(state, (LevelReader)level, pos, true);
        } else if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT) {
            states = this.fetchConnectionStates(state, (LevelReader)level, pos, false);
            positions = this.fetchConnectionPos(state, (LevelReader)level, pos, false);
        } else if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.MIDDLE) {
            states = this.fetchConnectionStatesFromMiddle(state, (LevelReader)level, pos);
            positions = this.fetchConnectionPosFromMiddle(state, (LevelReader)level, pos);
        } else if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.SINGLE) {
            states.add(state);
            positions.add(pos);
        }
        int levelToAdd = 16 / states.size() / 4;
        int setLevel = (Integer)state.m_61143_((Property)LEVEL);
        if (states.size() == 1 && setLevel != 0 && setLevel != 4 && setLevel != 8 && setLevel != 12 && setLevel != 16) {
            int n = setLevel > 12 ? 12 : (setLevel > 8 ? 8 : (setLevel = setLevel > 4 ? 4 : 0));
        }
        if (states.size() == 3) {
            levelToAdd = level.m_213780_().m_188503_(2) + 1;
        }
        setLevel += removeWater ? -levelToAdd : levelToAdd;
        for (BlockPos blockPos : positions) {
            level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Mth.m_14045_((int)setLevel, (int)0, (int)16))), 19);
        }
    }

    private void splitWater(BlockState state, LevelAccessor level, BlockPos pos) {
        Set<Object> states = new HashSet();
        Set<Object> positions = new HashSet();
        if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT) {
            states = this.fetchConnectionStates(state, (LevelReader)level, pos, true);
            positions = this.fetchConnectionPos(state, (LevelReader)level, pos, true);
        } else if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT) {
            BlockPos offset = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
            states = this.fetchConnectionStates(level.m_8055_(offset), (LevelReader)level, offset, false);
            positions = this.fetchConnectionPos(level.m_8055_(offset), (LevelReader)level, offset, false);
        } else if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.MIDDLE) {
            states = this.fetchConnectionStatesFromMiddle(state, (LevelReader)level, pos);
            positions = this.fetchConnectionPosFromMiddle(state, (LevelReader)level, pos);
        }
        states.add(state);
        positions.add(pos);
        float total = 0.0f;
        for (BlockState blockState : states) {
            total += (float)((Integer)blockState.m_61143_((Property)LEVEL)).intValue();
        }
        int average = Mth.m_14167_((float)(total / (float)states.size()));
        for (BlockPos blockPos : positions) {
            level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Mth.m_14045_((int)average, (int)0, (int)16))), 3);
        }
    }

    private int countConnectionsFromLeft(BlockState state, LevelReader world, BlockPos pos) {
        BlockState checkState;
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        int connections = 0;
        for (int i = 1; i < 5 && (checkState = world.m_8055_(pos.m_5484_(dir.m_122427_(), i))).m_60734_() == BlockSetup.WATER_TROUGH.get(); ++i) {
            if (checkState.m_61143_((Property)PART) != SWEMBlockStateProperties.TwoWay.RIGHT) {
                ++connections;
                continue;
            }
            if (checkState.m_61143_((Property)PART) != SWEMBlockStateProperties.TwoWay.RIGHT) break;
            ++connections;
            break;
        }
        return connections;
    }

    private Set<BlockPos> fetchConnectionPosFromMiddle(BlockState state, LevelReader world, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        BlockState checkState = world.m_8055_(pos.m_5484_(dir.m_122428_(), 1));
        if (checkState.m_60734_() instanceof WaterTroughBlock && checkState.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT) {
            return this.fetchConnectionPos(checkState, world, pos.m_5484_(dir.m_122428_(), 1), true);
        }
        checkState = world.m_8055_(pos.m_5484_(dir.m_122427_(), 1));
        if (checkState.m_60734_() instanceof WaterTroughBlock && checkState.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT) {
            return this.fetchConnectionPos(checkState, world, pos.m_5484_(dir.m_122427_(), 1), false);
        }
        return new HashSet<BlockPos>();
    }

    private Set<BlockState> fetchConnectionStatesFromMiddle(BlockState state, LevelReader world, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        BlockState checkState = world.m_8055_(pos.m_5484_(dir.m_122428_(), 1));
        if (checkState.m_60734_() instanceof WaterTroughBlock && checkState.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT) {
            return this.fetchConnectionStates(checkState, world, pos.m_5484_(dir.m_122428_(), 1), true);
        }
        checkState = world.m_8055_(pos.m_5484_(dir.m_122427_(), 1));
        if (checkState.m_60734_() instanceof WaterTroughBlock && checkState.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT) {
            return this.fetchConnectionStates(checkState, world, pos.m_5484_(dir.m_122427_(), 1), false);
        }
        return new HashSet<BlockState>();
    }

    private Set<BlockState> fetchConnectionStates(BlockState state, LevelReader world, BlockPos pos, boolean fromLeft) {
        BlockState checkState;
        HashSet<BlockState> states = new HashSet<BlockState>();
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        for (int i = 0; i < 5 && !(checkState = world.m_8055_(pos.m_5484_(fromLeft ? dir.m_122427_() : dir.m_122428_(), i))).m_60795_() && checkState.m_60734_() instanceof WaterTroughBlock && ((Direction)checkState.m_61143_((Property)f_54117_)).m_122434_() == ((Direction)state.m_61143_((Property)f_54117_)).m_122434_(); ++i) {
            if (checkState.m_61143_((Property)PART) == (fromLeft ? SWEMBlockStateProperties.TwoWay.RIGHT : SWEMBlockStateProperties.TwoWay.LEFT)) {
                if (checkState.m_61143_((Property)PART) != (fromLeft ? SWEMBlockStateProperties.TwoWay.RIGHT : SWEMBlockStateProperties.TwoWay.LEFT)) break;
                states.add(checkState);
                break;
            }
            states.add(checkState);
        }
        return states;
    }

    private Set<BlockPos> fetchConnectionPos(BlockState state, LevelReader world, BlockPos pos, boolean fromLeft) {
        BlockPos checkPos;
        BlockState checkState;
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        for (int i = 0; i < 5 && !(checkState = world.m_8055_(checkPos = pos.m_5484_(fromLeft ? dir.m_122427_() : dir.m_122428_(), i))).m_60795_() && checkState.m_60734_() instanceof WaterTroughBlock && ((Direction)checkState.m_61143_((Property)f_54117_)).m_122434_() == ((Direction)state.m_61143_((Property)f_54117_)).m_122434_(); ++i) {
            if (checkState.m_61143_((Property)PART) == (fromLeft ? SWEMBlockStateProperties.TwoWay.RIGHT : SWEMBlockStateProperties.TwoWay.LEFT)) {
                if (checkState.m_61143_((Property)PART) != (fromLeft ? SWEMBlockStateProperties.TwoWay.RIGHT : SWEMBlockStateProperties.TwoWay.LEFT)) break;
                positions.add(checkPos);
                break;
            }
            positions.add(checkPos);
        }
        return positions;
    }

    private int countConnectionsFromRight(BlockState state, LevelReader world, BlockPos pos) {
        BlockState checkState;
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        int connections = 0;
        for (int i = 1; i < 5 && (checkState = world.m_8055_(pos.m_5484_(dir.m_122428_(), i))).m_60734_() == BlockSetup.WATER_TROUGH.get(); ++i) {
            if (checkState.m_61143_((Property)PART) != SWEMBlockStateProperties.TwoWay.LEFT) {
                ++connections;
                continue;
            }
            if (checkState.m_61143_((Property)PART) != SWEMBlockStateProperties.TwoWay.LEFT) break;
            ++connections;
            break;
        }
        return connections;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, LEVEL});
    }

    public void m_141997_(BlockState state, Level level, BlockPos pos, Biome.Precipitation weather) {
        if (weather == Biome.Precipitation.RAIN) {
            int size = 1;
            if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT) {
                size = this.fetchConnectionPos(state, (LevelReader)level, pos, true).size();
            } else if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT) {
                BlockPos offset = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122428_());
                size = this.fetchConnectionPos(level.m_8055_(offset), (LevelReader)level, offset, false).size();
            } else if (state.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.MIDDLE) {
                size = this.fetchConnectionPosFromMiddle(state, (LevelReader)level, pos).size();
            }
            int water = (Integer)state.m_61143_((Property)LEVEL);
            if (water < 16) {
                int increment = 4 - (size - 1);
                BlockState outState = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(Math.min(16, water + increment)));
                level.m_7731_(pos, outState, 3);
                this.splitWater(outState, (LevelAccessor)level, pos);
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        BlockState checkLeft = world.m_8055_(pos.m_121945_(facing.m_122427_()));
        BlockState checkRight = world.m_8055_(pos.m_121945_(facing.m_122428_()));
        BlockState checkStraight = world.m_8055_(pos.m_121945_(facing));
        BlockState checkBehind = world.m_8055_(pos.m_121945_(facing.m_122424_()));
        List<BlockState> states = Arrays.asList(checkLeft, checkRight, checkStraight, checkBehind);
        for (BlockState checkState : states) {
            if (checkState.m_60795_() || !(checkState.m_60734_() instanceof WaterTroughBlock)) continue;
            int connections = 0;
            if (checkState.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT) {
                connections += this.countConnectionsFromLeft(checkState, world, pos);
            } else if (checkState.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT) {
                connections += this.countConnectionsFromRight(checkState, world, pos);
            }
            if (connections < 4) continue;
            return false;
        }
        return !(checkLeft.m_60734_() instanceof WaterTroughBlock && checkRight.m_60734_() instanceof WaterTroughBlock && (checkLeft.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT && checkRight.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT || checkLeft.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.LEFT && checkRight.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.SINGLE || checkLeft.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.SINGLE && checkRight.m_61143_((Property)PART) == SWEMBlockStateProperties.TwoWay.RIGHT));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState outState = super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        return outState;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        this.splitWater(pState, (LevelAccessor)pLevel, pPos);
    }
}

