/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.render;

import com.alaharranhonor.swem.forge.blocks.BridleRackBlock;
import com.alaharranhonor.swem.forge.client.model.BridleRackModel;
import com.alaharranhonor.swem.forge.client.model.EnglishBridleModel;
import com.alaharranhonor.swem.forge.client.model.WesternBridleModel;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.community.content.tack.type.BridleTypeData;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.alaharranhonor.swem.forge.tileentity.BridleRackBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.ItemStackHandler;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class BridleRackRender
extends GeoBlockRenderer<BridleRackBE> {
    public BridleRackRender(BlockEntityRendererProvider.Context ctx) {
        super((GeoModel)new BridleRackModel());
    }

    public void renderFinal(PoseStack pPoseStack, BridleRackBE pRack, BakedGeoModel pModel, MultiBufferSource pBufferSource, VertexConsumer pBuffer, float pPartialTick, int pPackedLight, int pOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        TackItem tack;
        Optional cap = pRack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (cap.isEmpty()) {
            return;
        }
        ItemStackHandler inv = pRack.getInventory();
        ItemStack bridle = inv.getStackInSlot(0);
        Item item = bridle.m_41720_();
        if (!(item instanceof TackItem) || (tack = (TackItem)item).getType() != TackType.BRIDLE) {
            return;
        }
        pPoseStack.m_85836_();
        Direction direction = (Direction)pRack.m_58900_().m_61143_((Property)BridleRackBlock.f_54117_);
        pPoseStack.m_85837_(0.5, 0.0, 0.5);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - direction.m_122435_()));
        GeoModel model = null;
        RenderType renderType = RenderType.m_110452_((ResourceLocation)tack.getTextureOnRack(pRack.getRackType()));
        String modelType = ((BridleTypeData)tack.getData()).getModelType();
        if ("western".equalsIgnoreCase(modelType)) {
            model = new WesternBridleModel();
        } else if ("english".equalsIgnoreCase(modelType)) {
            model = new EnglishBridleModel();
        }
        if (model != null) {
            VertexConsumer builder = pBufferSource.m_6299_(renderType);
            Color renderColor = this.getRenderColor((GeoAnimatable)pRack, pPartialTick, pPackedLight);
            for (GeoBone bone : model.getBakedModel(model.getModelResource(null)).topLevelBones()) {
                this.renderRecursively(pPoseStack, pRack, bone, renderType, pBufferSource, builder, false, pPartialTick, pPackedLight, pOverlay, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
            }
        }
        pPoseStack.m_85849_();
    }
}

