/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.render;

import com.alaharranhonor.swem.forge.client.model.AdventureSaddleModel;
import com.alaharranhonor.swem.forge.client.model.EnglishSaddleModel;
import com.alaharranhonor.swem.forge.client.model.HorseArmorModelGeo;
import com.alaharranhonor.swem.forge.client.model.HorseArmorRackModel;
import com.alaharranhonor.swem.forge.client.model.WesternSaddleModel;
import com.alaharranhonor.swem.forge.community.RackType;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.community.content.tack.type.SaddleTypeData;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.alaharranhonor.swem.forge.tileentity.HorseArmorRackBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class HorseArmorRackRender
extends GeoBlockRenderer<HorseArmorRackBE> {
    public final HorseArmorModelGeo armorModelGeo = new HorseArmorModelGeo();
    public final AdventureSaddleModel adventureSaddleModel = new AdventureSaddleModel();
    public final EnglishSaddleModel englishSaddleModel = new EnglishSaddleModel();
    public final WesternSaddleModel westernSaddleModel = new WesternSaddleModel();

    public HorseArmorRackRender(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super((GeoModel)new HorseArmorRackModel());
    }

    public void renderFinal(PoseStack pPoseStack, HorseArmorRackBE pArmorRack, BakedGeoModel pBakedModel, MultiBufferSource pBufferSource, VertexConsumer pBuffer, float pPartialTick, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        TackItem saddle;
        VertexConsumer vertexBuilder;
        Item renderType;
        Optional cap = pArmorRack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (cap.isEmpty()) {
            return;
        }
        IItemHandler handler = (IItemHandler)cap.get();
        ItemStack horseArmorStack = handler.getStackInSlot(0);
        Item item = horseArmorStack.m_41720_();
        if (item instanceof TackItem) {
            TackItem tack = (TackItem)item;
            if (TackType.HORSE_ARMOR.is(horseArmorStack)) {
                renderType = RenderType.m_110431_((ResourceLocation)tack.getTextureOnRack(RackType.HORSE_ARMOR));
                vertexBuilder = pBufferSource.m_6299_((RenderType)renderType);
                BakedGeoModel geoModel = this.armorModelGeo.getBakedModel(this.armorModelGeo.getModelResource(tack));
                HorseArmorRackRender.transformArmorModel(geoModel);
                for (GeoBone bone : geoModel.topLevelBones()) {
                    pPoseStack.m_85836_();
                    bone.setPosY(-15.0f);
                    bone.setPosX(1.0f);
                    double[] translations = this.calculateTranslations(pArmorRack.m_58900_());
                    pPoseStack.m_85837_(translations[0], translations[1], translations[2]);
                    pPoseStack.m_252781_(this.calculateRotation(pArmorRack.m_58900_()));
                    this.renderRecursively(pPoseStack, pArmorRack, bone, (RenderType)renderType, pBufferSource, vertexBuilder, false, pPartialTick, pPackedLight, OverlayTexture.f_118083_, pRed, pGreen, pBlue, pAlpha);
                    pPoseStack.m_85849_();
                }
            }
        }
        if ((renderType = handler.getStackInSlot(1).m_41720_()) instanceof TackItem && (saddle = (TackItem)renderType).getType() == TackType.SADDLE) {
            renderType = RenderType.m_110431_((ResourceLocation)saddle.getTextureOnRack(RackType.HORSE_ARMOR));
            vertexBuilder = pBufferSource.m_6299_((RenderType)renderType);
            String modelType = ((SaddleTypeData)saddle.getData()).getModelType();
            GeoModel model = null;
            if ("adventure".equalsIgnoreCase(modelType)) {
                model = this.adventureSaddleModel;
            } else if ("western".equalsIgnoreCase(modelType)) {
                model = this.westernSaddleModel;
            } else if ("english".equalsIgnoreCase(modelType)) {
                model = this.englishSaddleModel;
            }
            BakedGeoModel geoModel = model.getBakedModel(model.getModelResource((GeoAnimatable)saddle));
            for (GeoBone bone : geoModel.topLevelBones()) {
                pPoseStack.m_85836_();
                double[] translations = this.calculateTranslations(pArmorRack.m_58900_());
                pPoseStack.m_85837_(translations[0], translations[1] + 0.5, translations[2]);
                pPoseStack.m_252781_(this.calculateRotation(pArmorRack.m_58900_()));
                pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                this.renderRecursively(pPoseStack, pArmorRack, bone, (RenderType)renderType, pBufferSource, vertexBuilder, false, pPartialTick, pPackedLight, OverlayTexture.f_118083_, pRed, pGreen, pBlue, pAlpha);
                pPoseStack.m_85849_();
            }
        }
    }

    private static void transformArmorModel(BakedGeoModel model) {
        model.getBone("right").ifPresent(piece -> {
            piece.setPivotX(1.0f);
            piece.setPivotY(22.0f);
            piece.setPivotZ(7.0f);
            piece.setRotX(1.575f);
            piece.setRotY(1.3f);
            piece.setPosY(-4.75f);
            piece.setPosX(2.0f);
            piece.setPosZ(-7.0f);
        });
        model.getBone("left").ifPresent(piece -> {
            piece.setPivotX(1.0f);
            piece.setPivotY(22.0f);
            piece.setPivotZ(-7.0f);
            piece.setRotX(1.575f);
            piece.setRotY(1.575f);
            piece.setPosY(-4.75f);
            piece.setPosX(2.0f);
            piece.setPosZ(7.0f);
        });
        model.getBone("head").ifPresent(head -> {
            head.setPivotY(32.0f);
            head.setPivotX(19.0f);
            head.setPosY(-1.0f);
            head.setPosX(0.0f);
            head.setRotZ(-1.575f);
        });
        model.getBone("feet").ifPresent(feet -> feet.setPosY(16.0f));
        model.getBone("head2").ifPresent(head2 -> {
            head2.setPivotY(32.0f);
            head2.setPivotX(19.0f);
            head2.setPosY(-1.0f);
            head2.setPosX(0.0f);
            head2.setRotZ(-1.575f);
        });
        model.getBone("neck").ifPresent(neck -> {
            neck.setRotZ(0.0f);
            neck.setPosY(-7.0f);
            neck.setPosX(-4.0f);
        });
    }

    private static void transformBone(GeoBone bone) {
        float pi = (float)Math.PI;
        if (!bone.getName().equals("cloth")) {
            if (bone.getName().equals("iron")) {
                bone.getChildBones().stream().filter(b -> b.getName().equals("head")).findFirst().ifPresent(head -> {});
            } else if (bone.getName().equals("gold")) {
                bone.getChildBones().stream().filter(b -> b.getName().equals("feet")).findFirst().ifPresent(feet -> {});
                bone.getChildBones().stream().filter(b -> b.getName().equals("head2")).findFirst().ifPresent(head -> {
                    head.setPivotY(32.0f);
                    head.setPivotX(19.0f);
                    head.setPosY(-1.0f);
                    head.setPosX(0.0f);
                    head.setRotZ(-1.575f);
                });
            } else if (bone.getName().equals("diamond")) {
                GeoBone geoBone = (GeoBone)bone.getChildBones().get(0);
            }
        }
    }

    private Quaternionf calculateRotation(BlockState state) {
        switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            case SOUTH: {
                return Axis.f_252436_.m_252977_(-180.0f);
            }
            case WEST: {
                return Axis.f_252436_.m_252977_(90.0f);
            }
            case EAST: {
                return Axis.f_252436_.m_252977_(-90.0f);
            }
        }
        return Axis.f_252436_.m_252977_(0.0f);
    }

    private double[] calculateTranslations(BlockState state) {
        double[] translations = new double[3];
        switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            case NORTH: {
                translations = new double[]{0.0, 0.0, 0.5};
                break;
            }
            case SOUTH: {
                translations = new double[]{1.0, 0.0, 0.5};
                break;
            }
            case EAST: {
                translations = new double[]{0.5, 0.0, 0.0};
                break;
            }
            case WEST: {
                translations = new double[]{0.5, 0.0, 1.0};
                break;
            }
            default: {
                Arrays.fill(translations, 0.0);
            }
        }
        return translations;
    }
}

