/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.render;

import com.alaharranhonor.swem.forge.client.model.RidingHelmetBlockModel;
import com.alaharranhonor.swem.forge.tileentity.RidingHelmetBE;
import com.alaharranhonor.swem.forge.util.DualDyeableItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class RidingHelmetBlockRender
extends GeoBlockRenderer<RidingHelmetBE> {
    public RidingHelmetBlockRender(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super((GeoModel)new RidingHelmetBlockModel());
    }

    public Color getBoneColor(GeoBone bone, RidingHelmetBE helmet) {
        Item item = helmet.getHelmet().m_41720_();
        if (!(item instanceof DualDyeableItem)) {
            return Color.WHITE;
        }
        DualDyeableItem dyeable = (DualDyeableItem)item;
        if (bone.getName().equals("RHStrap")) {
            return Color.ofOpaque((int)dyeable.getSecondary(helmet.getHelmet()));
        }
        return Color.ofOpaque((int)dyeable.getPrimary(helmet.getHelmet()));
    }

    public void preRender(PoseStack poseStack, RidingHelmetBE animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (BlockEntity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        model.getBone("RHCover").ifPresent(bone -> bone.setHidden(true));
    }

    public void renderRecursively(PoseStack poseStack, RidingHelmetBE animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Color color = this.getBoneColor(bone, animatable);
        if (color == null) {
            color = Color.ofOpaque((int)Color.ofRGBA((float)red, (float)green, (float)blue, (float)alpha).getColor());
        }
        super.renderRecursively(poseStack, (BlockEntity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }
}

