/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.client.render;

import com.alaharranhonor.swem.forge.blocks.SaddleRackBlock;
import com.alaharranhonor.swem.forge.client.model.AdventureSaddleModel;
import com.alaharranhonor.swem.forge.client.model.EnglishSaddleModel;
import com.alaharranhonor.swem.forge.client.model.ModelBoneType;
import com.alaharranhonor.swem.forge.client.model.SaddleRackModel;
import com.alaharranhonor.swem.forge.client.model.WesternSaddleModel;
import com.alaharranhonor.swem.forge.community.RackType;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.community.content.tack.type.GirthStrapTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.SaddleTypeData;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.alaharranhonor.swem.forge.tileentity.SaddleRackBE;
import com.alaharranhonor.swem.forge.util.IHasColor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class SaddleRackRender
extends GeoBlockRenderer<SaddleRackBE> {
    public SaddleRackRender(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super((GeoModel)new SaddleRackModel());
    }

    public void preRender(PoseStack pPoseStack, SaddleRackBE pRack, BakedGeoModel pBakedModel, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ItemStackHandler inv = pRack.getInventory();
        ItemStack blanket = inv.getStackInSlot(1);
        pBakedModel.getBone(ModelBoneType.BLANKET.bone).ifPresent(b -> b.setHidden(blanket.m_41619_()));
        ItemStack girthStrap = inv.getStackInSlot(2);
        pBakedModel.getBone("GirthStrapBelt").ifPresent(b -> b.setHidden(girthStrap.m_41619_()));
        pBakedModel.getBone("GirthStrapFloof").ifPresent(b -> b.setHidden(girthStrap.m_41619_()));
        pBakedModel.getBone("GirthStrapMetal").ifPresent(b -> b.setHidden(girthStrap.m_41619_()));
        pBakedModel.getBone("SaddleRackFloor").ifPresent(b -> b.setHidden(((Boolean)pRack.m_58900_().m_61143_((Property)SaddleRackBlock.HANGING)).booleanValue()));
        super.preRender(pPoseStack, (BlockEntity)pRack, pBakedModel, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack poseStack, SaddleRackBE rack, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        TackItem tack;
        Item item;
        ItemStack stack;
        Color color = Color.ofRGBA((float)red, (float)green, (float)blue, (float)alpha);
        if (!bone.isHidden() && bone.getName().equals(ModelBoneType.BLANKET.bone)) {
            stack = rack.getInventory().getStackInSlot(1);
            item = stack.m_41720_();
            if (item instanceof IHasColor) {
                IHasColor colorable = (IHasColor)item;
                color = colorable.getColor();
            }
            if ((item = stack.m_41720_()) instanceof TackItem && (tack = (TackItem)item).getType() == TackType.BLANKET) {
                renderType = this.getRenderType((GeoAnimatable)rack, tack.getTextureOnRack(rack.getRackType()), bufferSource, partialTick);
                buffer = bufferSource.m_6299_(renderType);
            }
        }
        if (!bone.isHidden() && bone.getName().contains("GirthStrap") && (item = (stack = rack.getInventory().getStackInSlot(2)).m_41720_()) instanceof TackItem && (tack = (TackItem)item).getType() == TackType.GIRTH_STRAP) {
            if (bone.getName().contains("Floof")) {
                color = tack.getColor();
            } else if (bone.getName().contains("Belt")) {
                GirthStrapTypeData data = (GirthStrapTypeData)tack.getData();
                color = data.getBeltColor();
            }
            renderType = this.getRenderType((GeoAnimatable)rack, tack.getTextureOnRack(rack.getRackType()), bufferSource, partialTick);
            buffer = bufferSource.m_6299_(renderType);
        }
        super.renderRecursively(poseStack, (BlockEntity)rack, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color.getRedFloat(), color.getGreenFloat(), color.getBlueFloat(), color.getAlphaFloat());
    }

    public void renderFinal(PoseStack pPoseStack, SaddleRackBE pRack, BakedGeoModel pBakedModel, MultiBufferSource pBufferSource, VertexConsumer pBuffer, float pPartialTick, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ItemStackHandler inventory = pRack.getInventory();
        ItemStack saddleStack = inventory.getStackInSlot(0);
        Item item = saddleStack.m_41720_();
        if (!(item instanceof TackItem)) {
            return;
        }
        TackItem saddle = (TackItem)item;
        pPoseStack.m_85836_();
        Direction direction = (Direction)pRack.m_58900_().m_61143_((Property)SaddleRackBlock.f_54117_);
        switch (direction) {
            case WEST: {
                pPoseStack.m_85837_(0.5902, 0.125, 0.5);
                break;
            }
            case EAST: {
                pPoseStack.m_85837_(0.405, 0.125, 0.5);
                break;
            }
            case SOUTH: {
                pPoseStack.m_85837_(0.5, 0.125, 0.405);
                break;
            }
            case NORTH: {
                pPoseStack.m_85837_(0.5, 0.125, 0.5902);
            }
        }
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - direction.m_122435_()));
        pPoseStack.m_85837_(0.0, -0.03125, -0.125);
        String modelType = ((SaddleTypeData)saddle.getData()).getModelType();
        RenderType renderType = RenderType.m_110458_((ResourceLocation)saddle.getTextureOnRack(RackType.SADDLE));
        VertexConsumer vertexBuilder = pBufferSource.m_6299_(renderType);
        GeoModel model = null;
        if ("western".equalsIgnoreCase(modelType)) {
            model = new WesternSaddleModel();
        } else if ("english".equalsIgnoreCase(modelType)) {
            model = new EnglishSaddleModel();
        } else if ("adventure".equalsIgnoreCase(modelType)) {
            model = new AdventureSaddleModel();
        }
        if (model == null) {
            return;
        }
        for (GeoBone bone : model.getBakedModel(model.getModelResource((GeoAnimatable)saddle)).topLevelBones()) {
            this.renderRecursively(pPoseStack, pRack, bone, renderType, pBufferSource, vertexBuilder, false, pPartialTick, pPackedLight, OverlayTexture.f_118083_, pRed, pGreen, pBlue, pAlpha);
        }
        pPoseStack.m_85849_();
    }
}

