/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.commands;

import com.alaharranhonor.swem.forge.commands.SWEMCommand;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.BreedingBehavior;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.util.HorseUtil;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HorseGenderSubCommands {
    private static final Logger LOGGER = LogManager.getLogger();

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"breeding").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fertile").requires(src -> Keys.hasPermission(src, PermissionNodes.CAN_BREED))).executes(ctx -> HorseGenderSubCommands.makeHorseFertile((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), true)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"infertile").requires(src -> Keys.hasPermission(src, PermissionNodes.CAN_BREED))).executes(ctx -> HorseGenderSubCommands.makeHorseFertile((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(ctx -> Keys.hasPermission(ctx, PermissionNodes.CAN_BREED))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cooldown").requires(src -> SWEMCommand.hasPermission(src, PermissionNodes.CAN_BREED))).executes(ctx -> HorseGenderSubCommands.resetCooldown((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"pregnancy").requires(src -> SWEMCommand.hasPermission(src, PermissionNodes.CAN_BREED))).executes(ctx -> HorseGenderSubCommands.resetPregnancy((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"advance").requires(src -> SWEMCommand.hasPermission(src, PermissionNodes.CAN_BREED))).executes(ctx -> HorseGenderSubCommands.advancePregnancy((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"change").requires(src -> SWEMCommand.hasPermission(src, PermissionNodes.CAN_BREED))).executes(ctx -> HorseGenderSubCommands.changeHorseGender((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"offspring_count").requires(src -> SWEMCommand.hasPermission(src, PermissionNodes.CAN_BREED))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> HorseGenderSubCommands.setOffsprings((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")))));
    }

    private static int changeHorseGender(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be riding a horse to reset its pregnancy."));
            return 0;
        }
        boolean wasFemale = horse.getBreeding().isFemale();
        horse.getBreeding().setFemale(!wasFemale);
        LOGGER.info("Player {} changed the gender of horse {} ({}) to {}", (Object)player.m_7755_().getString(), (Object)horse.m_5446_().getString(), (Object)horse.m_20148_().toString(), (Object)(wasFemale ? "male" : "female"));
        src.m_288197_(() -> Component.m_237113_((String)("Gender of horse " + horse.m_5446_().getString() + " was changed to " + (wasFemale ? "male" : "female"))), false);
        return 0;
    }

    private static int advancePregnancy(CommandSourceStack source, ServerPlayer player) {
        Entity entity = player.m_20202_();
        if (!(entity instanceof SWEMHorseEntityBase)) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be riding a horse to advance its pregnancy."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
        BreedingBehavior breeding = horse.getBreeding();
        if (breeding.isPregnant()) {
            breeding.advancePregnancy();
            LOGGER.info("Player {} advanced pregnancy for horse {} ({})", (Object)player.m_7755_().getString(), (Object)horse.m_5446_().getString(), (Object)horse.m_20148_().toString());
            source.m_288197_(() -> Component.m_237113_((String)("Pregnancy was advanced for " + horse.m_5446_().getString())), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"You must be riding a pregnant mare to advance its pregnancy."));
        return 0;
    }

    private static int resetPregnancy(CommandSourceStack source, ServerPlayer player) {
        Entity entity = player.m_20202_();
        if (!(entity instanceof SWEMHorseEntityBase)) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be riding a horse to reset its pregnancy."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
        BreedingBehavior breeding = horse.getBreeding();
        if (breeding.isPregnant()) {
            breeding.resetPregnancy();
            LOGGER.info("Player {} reset pregnancy for horse {} ({})", (Object)player.m_7755_().getString(), (Object)horse.m_5446_().getString(), (Object)horse.m_20148_().toString());
            source.m_288197_(() -> Component.m_237113_((String)("Pregnancy was reset for " + horse.m_5446_().getString())), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"You must be riding a mare to reset its pregnancy."));
        return 0;
    }

    private static int setOffsprings(CommandSourceStack source, ServerPlayer player, int count) {
        Entity entity = player.m_20202_();
        if (!(entity instanceof SWEMHorseEntityBase)) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be riding a horse to reset its off."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
        BreedingBehavior breeding = horse.getBreeding();
        breeding.setOffspringCount(count);
        LOGGER.info("Player {} set offspring count for horse {} ({}) to {}", (Object)player.m_7755_().getString(), (Object)horse.m_5446_().getString(), (Object)horse.m_20148_().toString(), (Object)count);
        source.m_288197_(() -> Component.m_237113_((String)(horse.m_5446_().getString() + " now has " + count + " recorded offspring.")), false);
        return 1;
    }

    private static int resetCooldown(CommandSourceStack source, ServerPlayer player) {
        Entity entity = player.m_20202_();
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            BreedingBehavior breeding = horse.getBreeding();
            breeding.resetBreedCooldown();
            LOGGER.info("Player {} reset breeding cooldown for horse {} ({})", (Object)player.m_7755_().getString(), (Object)horse.m_5446_().getString(), (Object)horse.m_20148_().toString());
            source.m_288197_(() -> Component.m_237113_((String)("Reset breeding cooldown for " + horse.m_5446_().getString())), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"You must be riding a horse to reset its breeding cooldown."));
        return 0;
    }

    private static int makeHorseFertile(CommandSourceStack stack, ServerPlayer player, boolean fertile) {
        Entity entity = player.m_20202_();
        if (!(entity instanceof SWEMHorseEntityBase)) {
            stack.m_81352_((Component)Component.m_237113_((String)"You must be riding a horse to geld it."));
            return 0;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
        BreedingBehavior breeding = horse.getBreeding();
        if (fertile && breeding.isFertile()) {
            stack.m_81352_((Component)Component.m_237113_((String)"This horse is already fertile."));
            return 0;
        }
        if (!fertile && breeding.isInfertile()) {
            stack.m_81352_((Component)Component.m_237113_((String)"This horse is already infertile."));
            return 0;
        }
        breeding.setInfertile(!fertile);
        stack.m_288197_(() -> Component.m_237113_((String)("You made " + horse.m_5446_().getString() + " " + (fertile ? "Fertile" : "Infertile"))), false);
        return 1;
    }
}

