/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.commands;

import com.alaharranhonor.swem.forge.keys.IKeyHolder;
import com.alaharranhonor.swem.forge.keys.Key;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.registry.CapabilitySetup;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class KeySubCommands {
    private static final DynamicCommandExceptionType NOT_KEY_HOLDER = new DynamicCommandExceptionType(player -> new LiteralMessage(player + " is not a key holder."));

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"key").then(Commands.m_82127_((String)"list").executes(ctx -> KeySubCommands.listKeys((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"assign").requires(src -> src.m_6761_(4))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"key", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(Keys.getNames(), (SuggestionsBuilder)builder)).executes(ctx -> KeySubCommands.assignKey((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), Keys.fromId(ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"key")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"revoke").requires(src -> src.m_6761_(4))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"key", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(Keys.getNames(), (SuggestionsBuilder)builder)).executes(ctx -> KeySubCommands.revokeKey((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), Keys.fromId(ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"key")))))));
    }

    public static int assignKey(CommandSourceStack src, ServerPlayer player, Key key) throws CommandSyntaxException {
        IKeyHolder holder = (IKeyHolder)player.getCapability(CapabilitySetup.KEY_HOLDER).orElseThrow(() -> NOT_KEY_HOLDER.create((Object)player));
        if (holder.addKey(key)) {
            src.m_288197_(() -> Component.m_237113_((String)("Successfully added key to " + player.m_5446_().getString())), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)(player.m_5446_().getString() + " already has this key.")));
        return 0;
    }

    public static int revokeKey(CommandSourceStack src, ServerPlayer player, Key key) throws CommandSyntaxException {
        IKeyHolder holder = (IKeyHolder)player.getCapability(CapabilitySetup.KEY_HOLDER).orElseThrow(() -> NOT_KEY_HOLDER.create((Object)player));
        if (holder.removeKey(key)) {
            src.m_288197_(() -> Component.m_237113_((String)("Successfully revoked key from " + player.m_5446_().getString())), true);
            return 1;
        }
        src.m_81352_((Component)Component.m_237113_((String)(player.m_5446_().getString() + " does not have this key.")));
        return 0;
    }

    public static int listKeys(CommandSourceStack src, ServerPlayer player) throws CommandSyntaxException {
        IKeyHolder holder = (IKeyHolder)player.getCapability(CapabilitySetup.KEY_HOLDER).orElseThrow(() -> NOT_KEY_HOLDER.create((Object)player));
        src.m_288197_(() -> Component.m_237113_((String)("You have the following keys: " + holder.getKeys())), false);
        return 1;
    }
}

