/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.commands;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.commands.SWEMCommand;
import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.ActionBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.EatingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.LayingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.RRPAnimBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.SleepingBehavior;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import com.alaharranhonor.swem.forge.util.HorseUtil;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class RRPSubCommands {
    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rrp").then(Commands.m_82127_((String)"anim").then(Commands.m_82129_((String)"animation", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(HorseAnimations.Keys.getKeys(), (SuggestionsBuilder)builder)).executes(ctx -> RRPSubCommands.setRRPAnim((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)ctx, (String)"animation")))))).then(Commands.m_82127_((String)"kick").executes(ctx -> RRPSubCommands.horseKick((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"bite").executes(ctx -> RRPSubCommands.horseBite((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"stomp").executes(ctx -> RRPSubCommands.horseStomp((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"eat").executes(ctx -> RRPSubCommands.horseEat((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"rear").executes(ctx -> RRPSubCommands.horseRear((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"buck").executes(ctx -> RRPSubCommands.horseBuck((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"lay").executes(ctx -> RRPSubCommands.horseLay((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"sad").executes(ctx -> RRPSubCommands.horseSad((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"sleep").executes(ctx -> RRPSubCommands.horseSleep((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"maxgallop").executes(ctx -> RRPSubCommands.maxGallop((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())))).then(Commands.m_82127_((String)"wild").executes(ctx -> RRPSubCommands.setHorseWild((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())));
    }

    public static int setRRPAnim(CommandSourceStack src, Player player, String anim) {
        return SWEMCommand.canCommandHorse(src, player, PermissionNodes.CAN_FILM, true).map(horse -> {
            horse.getBehavior(RRPAnimBehavior.class).setAnimation(anim);
            return 1;
        }).orElse(0);
    }

    public static int horseKick(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        horse.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.KICK);
        return 1;
    }

    public static int horseBite(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        horse.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.BITE);
        return 1;
    }

    public static int horseStomp(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        horse.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.STOMP);
        return 1;
    }

    public static int horseEat(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        EatingBehavior behavior = horse.getBehavior(EatingBehavior.class);
        if (behavior.isVisuallyEating()) {
            behavior.stopVisualEating();
        } else {
            behavior.startVisualEatingAt(horse.m_20182_());
        }
        src.m_288197_(() -> Component.m_237113_((String)"You have toggled eating, run the command again to enable/disable"), false);
        return 1;
    }

    public static int horseRear(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        horse.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.REAR);
        return 1;
    }

    public static int horseBuck(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        horse.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.BUCK);
        return 1;
    }

    public static int horseLay(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        LayingBehavior behavior = horse.getBehavior(LayingBehavior.class);
        boolean enabled = !behavior.isVisuallyLayingDown();
        behavior.setVisualLayingDown(enabled);
        src.m_288197_(() -> Component.m_237113_((String)("You have toggled laying down to " + (enabled ? "enabled" : "disabled") + ", run the command again to enable/disable")), false);
        return 1;
    }

    public static int horseSad(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        horse.m_20088_().m_135381_(SWEMHorseEntityBase.RRP_SAD, (Object)((Boolean)horse.m_20088_().m_135370_(SWEMHorseEntityBase.RRP_SAD) == false ? 1 : 0));
        src.m_288197_(() -> Component.m_237113_((String)"You have toggled sad mode, run the command again to enable/disable"), false);
        return 1;
    }

    public static int horseSleep(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You need to be on a SWEM horse to execute this command."));
            return 0;
        }
        SleepingBehavior behavior = horse.getBehavior(SleepingBehavior.class);
        boolean enabled = !behavior.isVisuallySleeping();
        behavior.setVisualSleeping(enabled);
        src.m_288197_(() -> Component.m_237113_((String)("You have toggled sleep mode " + (enabled ? "enabled" : "disabled") + ", run the command again to enable/disable")), false);
        return 1;
    }

    public static int setHorseWild(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be on a SWEM horse."));
            return 0;
        }
        if (!Keys.hasPermission(src, PermissionNodes.CAN_FILM)) {
            src.m_81352_((Component)Component.m_237113_((String)"You do not have permission to do that."));
            return 0;
        }
        if (!horse.m_30614_()) {
            horse.m_30637_((Player)player);
        }
        horse.m_20088_().m_135381_(SWEMHorseEntityBase.RENDER_GIRTH_STRAP, (Object)false);
        horse.m_20088_().m_135381_(SWEMHorseEntityBase.RENDER_BLANKET, (Object)false);
        horse.m_20088_().m_135381_(SWEMHorseEntityBase.RENDER_SADDLE, (Object)false);
        horse.m_20088_().m_135381_(SWEMHorseEntityBase.RENDER_BRIDLE, (Object)false);
        horse.progressionManager.getAffinityLeveling().setXp(0.0f);
        horse.progressionManager.getAffinityLeveling().setLevel(horse.progressionManager.getAffinityLeveling().getMaxLevel());
        horse.resetGallopCooldown();
        horse.setMaxGallopSeconds(20);
        horse.progressionManager.getSpeedLeveling().setXp(0.0f);
        horse.progressionManager.getSpeedLeveling().setLevel(0);
        horse.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            h.insertItem(0, new ItemStack((ItemLike)ItemSetup.WESTERN_BRIDLES.get(DyeColor.GRAY.m_41060_()).get()), false);
            h.insertItem(1, new ItemStack((ItemLike)ItemSetup.WESTERN_BLANKETS.get(DyeColor.GRAY.m_41060_()).get()), false);
            h.insertItem(2, new ItemStack((ItemLike)ItemSetup.WESTERN_SADDLES.get(DyeColor.GRAY.m_41060_()).get()), false);
            h.insertItem(5, new ItemStack((ItemLike)ItemSetup.WESTERN_GIRTH_STRAPS.get(DyeColor.GRAY.m_41060_()).get()), false);
        });
        src.m_288197_(() -> Component.m_237113_((String)"Wild mode activated."), false);
        ModRef.LOGGER.info("Wild mode activated for " + horse.m_7755_().m_214077_() + " at: {X=" + horse.m_20185_() + ",Y=" + horse.m_20186_() + ",Z=" + horse.m_20189_() + "} by " + player.m_7755_().m_214077_());
        return 1;
    }

    public static int maxGallop(CommandSourceStack src, ServerPlayer player) {
        SWEMHorseEntityBase horse = HorseUtil.getRidingOrFilmingHorse(src.m_81372_(), (Player)player, true);
        if (horse == null) {
            src.m_81352_((Component)Component.m_237113_((String)"You must be on a SWEM horse."));
            return 0;
        }
        if (!Keys.hasPermission(src, PermissionNodes.CAN_FILM)) {
            src.m_81352_((Component)Component.m_237113_((String)"You do not have permission to do that."));
            return 0;
        }
        horse.setMaxGallopSeconds(60);
        horse.resetGallopCooldown();
        src.m_288197_(() -> Component.m_237113_((String)"Your horse's gallop cooldown has been reset."), false);
        return 1;
    }
}

