/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.commands;

import com.alaharranhonor.swem.forge.commands.SWEMCommand;
import com.alaharranhonor.swem.forge.entities.horse.coats.CoatManager;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseCoat;
import com.alaharranhonor.swem.forge.entities.horse.needs.HungerNeed;
import com.alaharranhonor.swem.forge.entities.horse.needs.ThirstNeed;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.command.EnumArgument;

public class SetSubCommands {
    private static final Random RANDOM = new Random();

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"allNeeds").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> SetSubCommands.setAllNeeds((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(Commands.m_82127_((String)"health").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> SetSubCommands.setHealth((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(Commands.m_82127_((String)"thirst").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> SetSubCommands.setMissedDrinks((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(Commands.m_82127_((String)"hunger").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(ctx -> SetSubCommands.setMissedMeals((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skills.class)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)12)).executes(ctx -> SetSubCommands.setSkillLevel((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_(), (Skills)((Object)((Object)ctx.getArgument("skill", Skills.class))), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level") - 1)))))).then(Commands.m_82127_((String)"coat").then(Commands.m_82129_((String)"coat", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(CoatManager.listCoatNames(), (SuggestionsBuilder)builder)).executes(ctx -> SetSubCommands.changeCoat((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_(), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"coat")))));
    }

    private static int changeCoat(CommandSourceStack src, Player player, ResourceLocation id) {
        return SWEMCommand.canCommandHorse(src, player, PermissionNodes.CAN_MODIFY, true).map(horse -> {
            HorseCoat coat = CoatManager.get(id);
            if (coat == null) {
                src.m_81352_((Component)Component.m_237113_((String)"Invalid coat id"));
                return 0;
            }
            horse.getCoatBehavior().set(coat);
            return 1;
        }).orElse(0);
    }

    private static int setAllNeeds(CommandSourceStack src, ServerPlayer player, int index) {
        return SWEMCommand.canCommandHorse(src, (Player)player, PermissionNodes.CAN_NEED, true).map(horse -> {
            horse.getNeeds().getThirst().setFromState(SetSubCommands.thirstFromIndex(index));
            horse.getNeeds().getHunger().setFromState(SetSubCommands.hungerFromIndex(index));
            horse.m_21153_(SetSubCommands.healthFromIndex(index));
            return 1;
        }).orElse(0);
    }

    private static int setMissedDrinks(CommandSourceStack src, ServerPlayer player, int index) {
        return SWEMCommand.canCommandHorse(src, (Player)player, PermissionNodes.CAN_NEED, true).map(horse -> {
            horse.getNeeds().getThirst().setFromState(SetSubCommands.thirstFromIndex(index));
            return 1;
        }).orElse(0);
    }

    private static int setMissedMeals(CommandSourceStack src, ServerPlayer player, int index) {
        return SWEMCommand.canCommandHorse(src, (Player)player, PermissionNodes.CAN_NEED, true).map(horse -> {
            horse.getNeeds().getHunger().setFromState(SetSubCommands.hungerFromIndex(index));
            return 1;
        }).orElse(0);
    }

    private static int setHealth(CommandSourceStack src, ServerPlayer player, int index) {
        return SWEMCommand.canCommandHorse(src, (Player)player, PermissionNodes.CAN_NEED, true).map(horse -> {
            horse.m_21153_(SetSubCommands.healthFromIndex(index));
            return 1;
        }).orElse(0);
    }

    private static int setSkillLevel(CommandSourceStack src, ServerPlayer player, Skills skill, int level) {
        return SWEMCommand.canCommandHorse(src, (Player)player, PermissionNodes.CAN_LEVEL, true).map(horse -> {
            int levelMessage = level + 1;
            switch (skill) {
                case ALL: {
                    horse.progressionManager.getSpeedLeveling().setXp(0.0f);
                    horse.progressionManager.getJumpLeveling().setXp(0.0f);
                    horse.progressionManager.getHealthLeveling().setXp(0.0f);
                    horse.progressionManager.getAffinityLeveling().setXp(0.0f);
                    if (level > -1 && level < 5) {
                        horse.progressionManager.getSpeedLeveling().setLevel(level);
                        horse.progressionManager.getJumpLeveling().setLevel(level);
                        horse.progressionManager.getHealthLeveling().setLevel(level);
                        horse.progressionManager.getAffinityLeveling().setLevel(level);
                        src.m_288197_(() -> Component.m_237113_((String)("All the stats have been set to level: " + levelMessage)), true);
                        break;
                    }
                    horse.progressionManager.getSpeedLeveling().setLevel(4);
                    horse.progressionManager.getJumpLeveling().setLevel(4);
                    horse.progressionManager.getHealthLeveling().setLevel(4);
                    horse.progressionManager.getAffinityLeveling().setLevel(level);
                    src.m_288197_(() -> Component.m_237113_((String)("Speed, Jump and Health is maxed and the affinity level is now: " + levelMessage)), true);
                    break;
                }
                case JUMP: {
                    if (level > -1 && level < 5) {
                        horse.progressionManager.getJumpLeveling().setXp(0.0f);
                        horse.progressionManager.getJumpLeveling().setLevel(level);
                        src.m_288197_(() -> Component.m_237113_((String)("The jump level on the horse has been set to: " + levelMessage)), false);
                        break;
                    }
                    src.m_81352_((Component)Component.m_237113_((String)"Incorrect level range."));
                    break;
                }
                case SPEED: {
                    if (level > -1 && level < 5) {
                        horse.progressionManager.getSpeedLeveling().setXp(0.0f);
                        horse.progressionManager.getSpeedLeveling().setLevel(level);
                        src.m_288197_(() -> Component.m_237113_((String)("The speed level on the horse has been set to: " + levelMessage)), false);
                        break;
                    }
                    src.m_81352_((Component)Component.m_237113_((String)"Incorrect level range."));
                    break;
                }
                case HEALTH: {
                    if (level > -1 && level < 5) {
                        horse.progressionManager.getHealthLeveling().setXp(0.0f);
                        horse.progressionManager.getHealthLeveling().setLevel(level);
                        src.m_288197_(() -> Component.m_237113_((String)("The health level on the horse has been set to: " + levelMessage)), false);
                        break;
                    }
                    src.m_81352_((Component)Component.m_237113_((String)"Incorrect level range."));
                    break;
                }
                case AFFINITY: {
                    if (level > -1 && level < 12) {
                        horse.progressionManager.getAffinityLeveling().setXp(0.0f);
                        horse.progressionManager.getAffinityLeveling().setLevel(level);
                        src.m_288197_(() -> Component.m_237113_((String)("The affinity level on the horse has been set to: " + levelMessage)), false);
                        break;
                    }
                    src.m_81352_((Component)Component.m_237113_((String)"Incorrect level range."));
                    break;
                }
                default: {
                    src.m_81352_((Component)Component.m_237113_((String)"Invalid Skill"));
                    return 0;
                }
            }
            horse.levelUpJump();
            horse.levelUpSpeed();
            horse.levelUpHealth();
            return 1;
        }).orElse(0);
    }

    private static float healthFromIndex(int index) {
        return index == 1 ? 6.0f : (float)((index - 1) * 10);
    }

    private static ThirstNeed.ThirstState thirstFromIndex(int index) {
        return ThirstNeed.ThirstState.values()[index - 1];
    }

    private static HungerNeed.HungerState hungerFromIndex(int index) {
        return HungerNeed.HungerState.values()[index - 1];
    }

    public static enum Skills {
        ALL,
        SPEED,
        JUMP,
        HEALTH,
        AFFINITY;

    }
}

