/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.commands;

import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.coats.CoatManager;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseCoat;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.registry.EntitySetup;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.command.EnumArgument;

public class SummonSubCommands {
    private static final DynamicCommandExceptionType INVALID_COAT = new DynamicCommandExceptionType(coat -> new LiteralMessage(coat + " coat does not exist."));
    private static final Random RANDOM = new Random();

    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summon").requires(src -> Keys.hasPermission(src, PermissionNodes.CAN_SUMMON))).then(Commands.m_82127_((String)"random").then(Commands.m_82129_((String)"model", (ArgumentType)EnumArgument.enumArgument(HorseModelType.class)).executes(ctx -> SummonSubCommands.summonRandomHorse((CommandSourceStack)ctx.getSource(), (HorseModelType)((Object)((Object)ctx.getArgument("model", HorseModelType.class)))))))).then(Commands.m_82129_((String)"model", (ArgumentType)EnumArgument.enumArgument(HorseModelType.class)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"coat", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(CoatManager.listCoatNames(), (SuggestionsBuilder)builder)).executes(ctx -> SummonSubCommands.summonHorse((CommandSourceStack)ctx.getSource(), (HorseModelType)((Object)((Object)ctx.getArgument("model", HorseModelType.class))), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"coat"), RANDOM.nextBoolean()))).then(Commands.m_82129_((String)"gender", (ArgumentType)EnumArgument.enumArgument(HorseCommandGender.class)).executes(ctx -> SummonSubCommands.summonHorse((CommandSourceStack)ctx.getSource(), (HorseModelType)((Object)((Object)ctx.getArgument("model", HorseModelType.class))), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"coat"), ctx.getArgument("gender", HorseCommandGender.class) == HorseCommandGender.FEMALE)))));
    }

    public static int summonRandomHorse(CommandSourceStack src, HorseModelType modelType) throws CommandSyntaxException {
        HorseCoat coat = CoatManager.randomLapisCoat();
        SWEMHorseEntityBase horse = SummonSubCommands.createSummonedHorse(src, modelType, coat, RANDOM.nextBoolean());
        src.m_288197_(() -> Component.m_237110_((String)"commands.summon.success", (Object[])new Object[]{horse.m_5446_()}), true);
        return 1;
    }

    public static int summonHorse(CommandSourceStack src, HorseModelType modelType, ResourceLocation coatId, boolean isFemale) throws CommandSyntaxException {
        HorseCoat coat = CoatManager.get(coatId);
        if (coat == null) {
            throw INVALID_COAT.create((Object)coatId);
        }
        SWEMHorseEntityBase horse = SummonSubCommands.createSummonedHorse(src, modelType, coat, isFemale);
        src.m_288197_(() -> Component.m_237110_((String)"commands.summon.success", (Object[])new Object[]{horse.m_5446_()}), true);
        return 1;
    }

    private static SWEMHorseEntityBase createSummonedHorse(CommandSourceStack src, HorseModelType modelType, HorseCoat coat, boolean isFemale) throws CommandSyntaxException {
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)SummonCommand.m_269066_((CommandSourceStack)src, (Holder.Reference)((Holder.Reference)ForgeRegistries.ENTITY_TYPES.getDelegate((Object)((EntityType)EntitySetup.SWEM_HORSE_ENTITY.get())).get()), (Vec3)src.m_81371_(), (CompoundTag)new CompoundTag(), (boolean)true);
        horse.m_146762_(1);
        horse.getCoatBehavior().set(coat);
        horse.getBreeding().setFemale(isFemale);
        return horse;
    }

    public static enum HorseCommandGender {
        MALE,
        FEMALE;

    }
}

