/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community.content.coats;

import com.alaharranhonor.swem.forge.community.ContentData;
import com.alaharranhonor.swem.forge.community.content.coats.CoatContentPack;
import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseCoat;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseColor;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class RawCoatData
extends ContentData<CoatContentPack> {
    public transient ResourceLocation id;
    public String credits;
    public String inspiration;
    public Map<HorseModelType, ResourceLocation> models;
    public boolean lapisCyclable;
    public boolean obtainableByBreeding;
    public List<HorseColor> baseColors;
    public boolean hasWings;

    public RawCoatData(CoatContentPack pPack) {
        super(pPack);
    }

    @Override
    public void load(JsonObject pJson) {
        this.credits = GsonHelper.m_13851_((JsonObject)pJson, (String)"credits", (String)"");
        this.inspiration = GsonHelper.m_13851_((JsonObject)pJson, (String)"inspiration", (String)"");
        this.models = Maps.newHashMap();
        JsonObject modelTextures = pJson.getAsJsonObject("models");
        for (Map.Entry modelEntry : modelTextures.asMap().entrySet()) {
            if (!((JsonElement)modelEntry.getValue()).isJsonPrimitive()) continue;
            HorseModelType modelType = HorseModelType.fromName((String)modelEntry.getKey());
            ResourceLocation texture = ((CoatContentPack)this.pack).getPack().res(((JsonElement)modelEntry.getValue()).getAsString());
            if (texture.m_135815_().isBlank()) continue;
            this.models.put(modelType, texture);
            ((CoatContentPack)this.pack).texturesToLoad.add(texture);
        }
        this.lapisCyclable = GsonHelper.m_13912_((JsonObject)pJson, (String)"lapis_cyclable");
        this.obtainableByBreeding = GsonHelper.m_13912_((JsonObject)pJson, (String)"obtainable_by_breeding");
        this.baseColors = new ArrayList<HorseColor>();
        JsonArray baseColorsJson = pJson.getAsJsonArray("base_colors");
        for (JsonElement element : baseColorsJson) {
            JsonPrimitive primitive;
            if (!(element instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)element).isString()) continue;
            this.baseColors.add(HorseColor.byName(primitive.getAsString()));
        }
        this.hasWings = GsonHelper.m_13855_((JsonObject)pJson, (String)"wings", (boolean)false);
    }

    public HorseCoat asCoat() {
        return new HorseCoat(this.id, this.models, this.credits, this.inspiration, this.lapisCyclable, this.obtainableByBreeding, this.baseColors, this.hasWings);
    }
}

