/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community.content.tack;

import com.alaharranhonor.swem.forge.client.model.ModelBoneType;
import com.alaharranhonor.swem.forge.community.ContentData;
import com.alaharranhonor.swem.forge.community.RackType;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.community.content.tack.TackContentPack;
import com.alaharranhonor.swem.forge.community.content.tack.TackCost;
import com.alaharranhonor.swem.forge.community.content.tack.TackDisplayData;
import com.alaharranhonor.swem.forge.community.content.tack.type.TackTypeData;
import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.alaharranhonor.swem.forge.items.CoinItem;
import com.alaharranhonor.swem.forge.tack.TackItemDefinition;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class RawTackData
extends ContentData<TackContentPack> {
    public TackDisplayData display;
    public TackCost cost;
    public ResourceLocation id;
    public ResourceLocation iconPath;
    public TackType type;
    public TackTypeData data;
    public Table<HorseModelType, ModelBoneType, ResourceLocation> horseTextures = HashBasedTable.create();
    public Map<RackType, ResourceLocation> rackTextures = new HashMap<RackType, ResourceLocation>();

    public RawTackData(TackContentPack pPack) {
        super(pPack);
    }

    @Override
    public void load(JsonObject pJson) {
        JsonObject displayJson = GsonHelper.m_13841_((JsonObject)pJson, (String)"display", (JsonObject)new JsonObject());
        String displayName = GsonHelper.m_13851_((JsonObject)displayJson, (String)"name", (String)"");
        String credits = GsonHelper.m_13851_((JsonObject)displayJson, (String)"credits", (String)"");
        String inspiration = GsonHelper.m_13851_((JsonObject)displayJson, (String)"inspiration", (String)"");
        this.display = new TackDisplayData(displayName, credits, inspiration);
        if (pJson.has("cost")) {
            JsonObject costJson = GsonHelper.m_13930_((JsonObject)pJson, (String)"cost");
            String coin = GsonHelper.m_13906_((JsonObject)costJson, (String)"coin");
            int amount = GsonHelper.m_13927_((JsonObject)costJson, (String)"amount");
            this.cost = new TackCost(CoinItem.Type.byName(coin), amount);
        }
        JsonObject metaJson = pJson.getAsJsonObject("meta");
        this.id = new ResourceLocation(((TackContentPack)this.pack).getPack().getId(), metaJson.get("name").getAsString());
        String texturePath = metaJson.get("icon").getAsString();
        this.iconPath = new ResourceLocation(((TackContentPack)this.pack).getPack().getId(), texturePath);
        this.type = TackType.fromName(metaJson.get("type").getAsString());
        this.data = this.type.parseData(GsonHelper.m_13841_((JsonObject)metaJson, (String)"data", (JsonObject)new JsonObject()));
        JsonObject texturesJson = metaJson.getAsJsonObject("textures");
        JsonObject horseTextures = texturesJson.getAsJsonObject("horse");
        for (Map.Entry modelEntry : horseTextures.asMap().entrySet()) {
            if (!((JsonElement)modelEntry.getValue()).isJsonObject()) continue;
            HorseModelType modelType = HorseModelType.fromName((String)modelEntry.getKey());
            JsonObject colJson = ((JsonElement)modelEntry.getValue()).getAsJsonObject();
            for (Map.Entry boneEntry : colJson.asMap().entrySet()) {
                if (((JsonElement)boneEntry.getValue()).getAsString().isBlank()) continue;
                ModelBoneType modelBoneType = ModelBoneType.fromName((String)boneEntry.getKey());
                this.horseTextures.put((Object)modelType, (Object)modelBoneType, (Object)new ResourceLocation(((TackContentPack)this.pack).getPack().getId(), ((JsonElement)boneEntry.getValue()).getAsString()));
            }
        }
        JsonObject rackTextures = GsonHelper.m_13841_((JsonObject)texturesJson, (String)"rack", (JsonObject)new JsonObject());
        for (Map.Entry entry : rackTextures.asMap().entrySet()) {
            if (((JsonElement)entry.getValue()).getAsString().isBlank()) continue;
            RackType rackType = RackType.fromName((String)entry.getKey());
            this.rackTextures.put(rackType, new ResourceLocation(((TackContentPack)this.pack).getPack().getId(), ((JsonElement)entry.getValue()).getAsString()));
        }
    }

    public TackItemDefinition getTackDefinition() {
        return new TackItemDefinition(this.type, this.cost, this.display, this.data, this.rackTextures, this.horseTextures);
    }

    public String toString() {
        return "TackData{display='" + this.display + "', id=" + this.id + ", iconPath=" + this.iconPath + ", type=" + this.type + ", data=" + this.data + ", horseTextures=" + this.horseTextures + ", rackTextures=" + this.rackTextures + "}";
    }
}

