/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community.content.tack;

import com.alaharranhonor.swem.forge.community.CommunityPack;
import com.alaharranhonor.swem.forge.community.ContentPack;
import com.alaharranhonor.swem.forge.community.LoadingPackException;
import com.alaharranhonor.swem.forge.community.content.tack.RawTackData;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public class TackContentPack
extends ContentPack<RawTackData> {
    public final HashMap<ResourceLocation, TackItem> registeredTack = new HashMap();

    public TackContentPack(CommunityPack pPack) {
        super(pPack);
    }

    public void onTackRegistered(ResourceLocation name, TackItem item) {
        this.registeredTack.put(name, item);
    }

    public Collection<TackItem> getRegisteredTackItems() {
        return this.registeredTack.values();
    }

    @Override
    protected void load() throws LoadingPackException {
        try {
            this.loadTack(this.getDataPath().toFile());
        }
        catch (IOException e) {
            throw new LoadingPackException("Failed to load tack for pack " + this.getPack().getId(), e);
        }
    }

    @Override
    protected void unload() {
    }

    private void loadTack(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.loadTack(child);
            }
            return;
        }
        if (!file.getName().endsWith(".json")) {
            return;
        }
        JsonObject json = JsonParser.parseReader((Reader)Files.newBufferedReader(file.toPath())).getAsJsonObject();
        RawTackData data = new RawTackData(this);
        data.load(json);
        this.add(data);
    }

    @Override
    public String name() {
        return "tack";
    }
}

