/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.community.content.tack.type;

import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.util.ColorUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.GsonHelper;
import software.bernie.geckolib.core.object.Color;

public class TackTypeData {
    private final boolean canWearArmor;
    private final Set<TackType> ignores;
    private final Color color;

    public TackTypeData(JsonObject json) {
        this.canWearArmor = GsonHelper.m_13855_((JsonObject)json, (String)"can_wear_armor", (boolean)false);
        this.ignores = new HashSet<TackType>();
        JsonArray ignoreRequirementsJson = GsonHelper.m_13832_((JsonObject)json, (String)"ignores", (JsonArray)new JsonArray());
        for (JsonElement element : ignoreRequirementsJson) {
            this.ignores.add(TackType.fromName(element.getAsString()));
        }
        JsonArray colorJson = GsonHelper.m_13832_((JsonObject)json, (String)"color", (JsonArray)ColorUtil.toJsonArray(Color.WHITE));
        this.color = Color.ofRGB((int)colorJson.get(0).getAsInt(), (int)colorJson.get(1).getAsInt(), (int)colorJson.get(2).getAsInt());
    }

    public TackTypeData(boolean canWearArmor, Set<TackType> ignores, Color color) {
        this.canWearArmor = canWearArmor;
        this.ignores = ignores;
        this.color = color;
    }

    public TackTypeData() {
        this(new JsonObject());
    }

    public boolean canWearArmor() {
        return this.canWearArmor;
    }

    public boolean ignores(TackType type) {
        return this.ignores.contains((Object)type);
    }

    public Color getColor() {
        return this.color;
    }
}

