/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.conditions;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.config.RecipeControlConfig;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class IntConfigCondition
implements ICondition {
    public static final ResourceLocation ID = ModRef.res("recipe_control.int");
    private final List<String> path;
    private final int expected;

    public IntConfigCondition(ForgeConfigSpec.IntValue config, int expected) {
        this.path = config.getPath();
        this.expected = expected;
    }

    public IntConfigCondition(String path, int expected) {
        this.path = Lists.newArrayList((Object[])path.split("\\."));
        this.expected = expected;
    }

    public boolean test(ICondition.IContext context) {
        return (Integer)((ForgeConfigSpec.IntValue)RecipeControlConfig.SPEC.getValues().get(this.path)).get() == this.expected;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public static class Serializer
    implements IConditionSerializer<IntConfigCondition> {
        public static final ResourceLocation ID = ModRef.res("recipe_control.int");

        public void write(JsonObject json, IntConfigCondition condition) {
            json.addProperty("path", String.join((CharSequence)".", condition.path));
            json.addProperty("expected", (Number)condition.expected);
        }

        public IntConfigCondition read(JsonObject json) {
            String path = json.get("path").getAsString();
            int value = json.get("expected").getAsInt();
            return new IntConfigCondition(path, value);
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

