/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.config;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="swem", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientConfig {
    public static ForgeConfigSpec.IntValue WINGS_TRANSPARENCY;
    public static ForgeConfigSpec.BooleanValue GAIT_HUD_ENABLED;
    public static ForgeConfigSpec.IntValue GAIT_HUD_X_OFFSET;
    public static ForgeConfigSpec.IntValue GAIT_HUD_Y_OFFSET;
    public static ForgeConfigSpec.IntValue GAIT_HUD_TEXT_COLOR;
    private static ForgeConfigSpec.BooleanValue SHOW_GENDER_ICONS;
    private static ForgeConfigSpec.ConfigValue<String> MALE_ICON_COLOR;
    private static ForgeConfigSpec.ConfigValue<String> FEMALE_ICON_COLOR;
    private static ForgeConfigSpec.ConfigValue<String> INFERTILE_ICON_COLOR;
    public static boolean showGenderIcons;
    public static String maleIconColor;
    public static String femaleIconColor;
    public static String infertileIconColor;

    public static void register(ForgeConfigSpec.Builder builder) {
        builder.comment(" || =========== [Wings Transparency] =========== ||").push("wings_tansparency");
        WINGS_TRANSPARENCY = builder.comment(" || Set how visible the horse wings should be! 0 = off, 1 = 25%, 2 = 50%, 3 = 75%, 4 = 100%").defineInRange("wingsTransparency", 4, 0, 4);
        builder.pop();
        builder.comment(" || =========== [Gait HUD] =========== ||").push("hud");
        GAIT_HUD_ENABLED = builder.comment(" || Should the gait HUD be enabled?").define("gaitHudEnabled", true);
        GAIT_HUD_X_OFFSET = builder.comment(" || How much would you like to offset the current X position? (A negative value moves the text up and a positive value down.)\t\t\t\t").defineInRange("gaitHudX", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        GAIT_HUD_Y_OFFSET = builder.comment(" || How much would you like to offset the current Y position? (A negative value moves the text up and a positive value down.)\t\t\t\t").defineInRange("gaitHudY", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        GAIT_HUD_TEXT_COLOR = builder.comment(" || What color should the gait HUD be?").defineInRange("gaitHudColor", 0xFFFFFF, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
        builder.comment(" || =========== [Gender] =========== ||").push("gender");
        SHOW_GENDER_ICONS = builder.comment(new String[]{" || Should gender icons be shown before horse names?", " || Icons only show if the horse is tamed and has a custom name."}).define("showGenderIcons", true);
        MALE_ICON_COLOR = builder.comment(new String[]{" || What colour the male icon should appear as.", " || This is a hex value, format: #A1B2C3. (Default is #18C0ED)"}).define("maleIconColor", (Object)"#18C0ED", ClientConfig::isValidHexString);
        FEMALE_ICON_COLOR = builder.comment(new String[]{" || What colour the female icon should appear as.", " || This is a hex value, format: #A1B2C3. (Default is #FF4DAC)"}).define("femaleIconColor", (Object)"#FF4DAC", ClientConfig::isValidHexString);
        INFERTILE_ICON_COLOR = builder.comment(new String[]{" || What colour the icon should appear as, when the horse is infertile.", " || This is a hex value, format: #A1B2C3. (Default is #444269)"}).define("infertileIconColor", (Object)"#444269", ClientConfig::isValidHexString);
        builder.pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        showGenderIcons = (Boolean)SHOW_GENDER_ICONS.get();
        maleIconColor = (String)MALE_ICON_COLOR.get();
        femaleIconColor = (String)FEMALE_ICON_COLOR.get();
        infertileIconColor = (String)INFERTILE_ICON_COLOR.get();
    }

    private static boolean isValidHexString(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            boolean length = s.length() == 7;
            boolean prefix = s.startsWith("#");
            boolean hex = s.substring(1).matches("[0-9A-Fa-f]+");
            return length && prefix && hex;
        }
        return false;
    }
}

