/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class LineageData {
    private UUID sire;
    private UUID dam;
    private List<UUID> offspring;

    public LineageData() {
        this(null, null, new ArrayList<UUID>());
    }

    public LineageData(UUID sire, UUID dam, List<UUID> offspring) {
        this.sire = sire;
        this.dam = dam;
        this.offspring = offspring;
    }

    public UUID getSire() {
        return this.sire;
    }

    public UUID getDam() {
        return this.dam;
    }

    public List<UUID> getOffspring() {
        return this.offspring;
    }

    public void setSire(UUID sireId) {
        this.sire = sireId;
    }

    public void setDam(UUID damId) {
        this.dam = damId;
    }

    public void addOffspring(UUID offspringId) {
        this.offspring.add(offspringId);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        if (this.sire != null) {
            tag.m_128362_("Sire", this.sire);
        }
        if (this.dam != null) {
            tag.m_128362_("Dam", this.dam);
        }
        ListTag offspringsTag = new ListTag();
        for (UUID offspringId : this.offspring) {
            offspringsTag.add((Object)NbtUtils.m_129226_((UUID)offspringId));
        }
        tag.m_128365_("Offsprings", (Tag)offspringsTag);
        return tag;
    }

    public void deserialize(CompoundTag tag) {
        if (tag.m_128441_("Sire")) {
            this.sire = tag.m_128342_("Sire");
        }
        if (tag.m_128441_("Dam")) {
            this.dam = tag.m_128342_("Dam");
        }
        this.offspring.clear();
        ListTag offspringsTag = tag.m_128437_("Offsprings", 11);
        offspringsTag.stream().map(NbtUtils::m_129233_).forEach(this.offspring::add);
    }

    public static void writeToBuffer(FriendlyByteBuf buf, LineageData data) {
        buf.writeBoolean(data.sire != null);
        if (data.sire != null) {
            buf.m_130077_(data.sire);
        }
        buf.writeBoolean(data.dam != null);
        if (data.dam != null) {
            buf.m_130077_(data.dam);
        }
        buf.m_130130_(data.offspring.size());
        for (UUID offspringId : data.offspring) {
            buf.m_130077_(offspringId);
        }
    }

    public static LineageData readFromBuffer(FriendlyByteBuf buf) {
        UUID sireId = null;
        UUID damId = null;
        ArrayList<UUID> offsprings = new ArrayList<UUID>();
        if (buf.readBoolean()) {
            sireId = buf.m_130259_();
        }
        if (buf.readBoolean()) {
            damId = buf.m_130259_();
        }
        int offspringCount = buf.m_130242_();
        for (int i = 0; i < offspringCount; ++i) {
            offsprings.add(buf.m_130259_());
        }
        return new LineageData(sireId, damId, offsprings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LineageData that = (LineageData)obj;
        return Objects.equals(this.sire, that.sire) && Objects.equals(this.dam, that.dam) && Objects.equals(this.offspring, that.offspring);
    }

    public int hashCode() {
        return Objects.hash(this.sire, this.dam, this.offspring);
    }

    public String toString() {
        return "LineageData[sire=" + this.sire + ", dam=" + this.dam + ", offspring=" + this.offspring + "]";
    }
}

