/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.datagen.client;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.blocks.GrainBinBlock;
import com.alaharranhonor.swem.forge.blocks.GrainFeederBlock;
import com.alaharranhonor.swem.forge.blocks.NonParallelBlock;
import com.alaharranhonor.swem.forge.blocks.PlaqueBlock;
import com.alaharranhonor.swem.forge.blocks.RibbonBlock;
import com.alaharranhonor.swem.forge.blocks.SWEMBannerBlock;
import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import com.alaharranhonor.swem.forge.blocks.SlowFeederBlock;
import com.alaharranhonor.swem.forge.blocks.TrophyBlock;
import com.alaharranhonor.swem.forge.blocks.WetCompostBlock;
import com.alaharranhonor.swem.forge.blocks.WheelBarrowBlock;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateGen
extends BlockStateProvider {
    public BlockStateGen(PackOutput pOutput, ExistingFileHelper exFileHelper) {
        super(pOutput, "swem", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerWheelBarrows();
        this.registerSlowFeeders();
        this.registerNonParallelBlock(BlockSetup.SEPARATORS);
        this.registerGrainFeeders();
        this.registerSpigot();
        this.registerRibbons();
        this.registerPlaques();
        this.registerTrophies();
        this.registerGrainBins();
        this.registerRacks();
        this.directionalBlock((Block)BlockSetup.SHINING_AMETHYST_CLUSTER.get(), (ModelFile)this.models().cross(BlockSetup.SHINING_AMETHYST_CLUSTER.getId().m_135815_(), this.modLoc("block/" + BlockSetup.SHINING_AMETHYST_CLUSTER.getId().m_135815_())));
        this.getVariantBuilder((Block)BlockSetup.BANNER.get()).forAllStates(state -> {
            int rotation = (Integer)state.m_61143_((Property)SWEMBannerBlock.ROTATION);
            int orientation = rotation % 4;
            ModelFile.ExistingModelFile model = this.models().getExistingFile(ModRef.res("block/alaharran_banner_" + orientation));
            return ConfiguredModel.builder().rotationY(180 + rotation / 4 * 90).modelFile((ModelFile)model).build();
        });
        this.horizontalBlock((Block)BlockSetup.WALL_BANNER.get(), (ModelFile)this.models().getExistingFile(ModRef.res("block/alaharran_banner_wall")));
        this.itemModels().withExistingParent("alaharran_banner", ModRef.res("block/alaharran_banner_0"));
        this.getVariantBuilder((Block)BlockSetup.WET_COMPOST.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)WetCompostBlock.AGE) + 1;
            String name = "wet_compost_" + age;
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll(name, this.modLoc("block/" + name))).build();
        });
        this.simpleBlockWithItem((Block)BlockSetup.SHOP.get(), (ModelFile)this.models().cubeBottomTop("shop", this.modLoc("block/swem_shop_side"), this.modLoc("block/swem_shop_bot"), this.modLoc("block/swem_shop_top")));
        this.simpleBlockWithItem((Block)BlockSetup.YELLOW_SNOW_BLOCK.get(), (ModelFile)this.models().cubeAll(BlockSetup.YELLOW_SNOW_BLOCK.getId().m_135815_(), this.blockTexture((Block)BlockSetup.YELLOW_SNOW_BLOCK.get())));
        this.getVariantBuilder((Block)BlockSetup.YELLOW_SNOW.get()).forAllStates(state -> {
            int layer = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
            if (layer < 8) {
                String parentHeightModelName = "snow_height" + layer * 2;
                ModelBuilder layerModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("yellow_" + parentHeightModelName, parentHeightModelName)).texture("texture", this.blockTexture((Block)BlockSetup.YELLOW_SNOW_BLOCK.get()))).texture("particle", this.blockTexture((Block)BlockSetup.YELLOW_SNOW_BLOCK.get()));
                return ConfiguredModel.builder().modelFile((ModelFile)layerModel).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(BlockSetup.YELLOW_SNOW_BLOCK.getId())).build();
        });
        this.simpleBlockItem((Block)BlockSetup.YELLOW_SNOW.get(), (ModelFile)this.models().getExistingFile(ModRef.res("yellow_snow_height2")));
    }

    private void registerPlaques() {
        this.plaque(BlockSetup.PLAQUE_BRONZE, ModRef.res("block/plaque_bronze"));
        this.plaque(BlockSetup.PLAQUE_SILVER, ModRef.res("block/plaque_silver"));
        this.plaque(BlockSetup.PLAQUE_GOLD, ModRef.res("block/plaque_gold"));
    }

    private void registerTrophies() {
        this.trophy(BlockSetup.TROPHY_BRONZE, ModRef.res("block/trophy_bronze"));
        this.trophy(BlockSetup.TROPHY_SILVER, ModRef.res("block/trophy_silver"));
        this.trophy(BlockSetup.TROPHY_GOLD, ModRef.res("block/trophy_gold"));
    }

    private void registerRibbons() {
        for (RegistryObject<RibbonBlock> rb : BlockSetup.TWO_TAILED_RIBBONS) {
            this.ribbon(rb, ModRef.res("block/ribbon_" + ((RibbonBlock)((Object)rb.get())).color));
        }
        for (RegistryObject<RibbonBlock> rb : BlockSetup.THREE_TAILED_RIBBONS) {
            this.ribbon(rb, ModRef.res("block/ribbon_" + ((RibbonBlock)((Object)rb.get())).color));
        }
        for (RegistryObject<RibbonBlock> rb : BlockSetup.ROSETTES) {
            this.ribbon(rb, ModRef.res("block/ribbon_" + ((RibbonBlock)((Object)rb.get())).color));
        }
        this.ribbon(BlockSetup.RIBBON_CHAMPION, ModRef.res("block/ribbon_champion"));
        this.ribbon(BlockSetup.RIBBON_RCHAMPION, ModRef.res("block/ribbon_rchampion"));
    }

    private void registerSpigot() {
        ModelFile.ExistingModelFile spigotWall = this.models().getExistingFile(ModRef.res("spigot_wall"));
        ModelFile.ExistingModelFile spigotGround = this.models().getExistingFile(ModRef.res("spigot_ground"));
        this.horizontalBlock((Block)BlockSetup.SPIGOT.get(), (ModelFile)spigotGround);
        this.horizontalBlock((Block)BlockSetup.WALL_SPIGOT.get(), (ModelFile)spigotWall);
    }

    protected void registerGrainBins() {
        BlockSetup.GRAIN_BINS_COLOR.forEach((color, bin) -> {
            ModelBuilder binModel = ((BlockModelBuilder)this.models().withExistingParent("bin_grain_" + color, ModRef.res("bin_grain"))).texture("texture", "swem:block/bin_grain_" + color);
            ModelBuilder lidClosedModel = ((BlockModelBuilder)this.models().withExistingParent("bin_grain_closed_" + color, ModRef.res("bin_grain_closed"))).texture("texture", "swem:block/bin_grain_" + color);
            ModelBuilder lidOpenModel = ((BlockModelBuilder)this.models().withExistingParent("bin_grain_open_" + color, ModRef.res("bin_grain_open"))).texture("texture", "swem:block/bin_grain_" + color);
            Direction.Plane.HORIZONTAL.m_122557_().forEach(arg_0 -> this.lambda$registerGrainBins$3(bin, (ModelFile)binModel, (ModelFile)lidClosedModel, (ModelFile)lidOpenModel, arg_0));
            this.itemModels().singleTexture("bin_grain_" + color, ModRef.res("item/bin_grain"), ModRef.res("block/bin_grain_" + color));
        });
        BlockSetup.GRAIN_BINS_WOOD.forEach((wood, bin) -> {
            ModelBuilder binModel = ((BlockModelBuilder)this.models().withExistingParent("bin_grain_" + wood, ModRef.res("bin_grain"))).texture("texture", "swem:block/bin_grain_" + wood);
            ModelBuilder lidClosedModel = ((BlockModelBuilder)this.models().withExistingParent("bin_grain_closed_" + wood, ModRef.res("bin_grain_closed"))).texture("texture", "swem:block/bin_grain_" + wood);
            ModelBuilder lidOpenModel = ((BlockModelBuilder)this.models().withExistingParent("bin_grain_open_" + wood, ModRef.res("bin_grain_open"))).texture("texture", "swem:block/bin_grain_" + wood);
            Direction.Plane.HORIZONTAL.m_122557_().forEach(arg_0 -> this.lambda$registerGrainBins$5(bin, (ModelFile)binModel, (ModelFile)lidClosedModel, (ModelFile)lidOpenModel, arg_0));
            this.itemModels().singleTexture("bin_grain_" + wood, ModRef.res("item/bin_grain"), ModRef.res("block/bin_grain_" + wood));
        });
    }

    protected void registerGrainFeeders() {
        String[] models = new String[]{"block/grain_feeder", "block/grain_feeder_corner", "block/grain_feeder_occupied", "block/grain_feeder_corner_occupied"};
        for (RegistryObject<GrainFeederBlock> gf : BlockSetup.GRAIN_FEEDERS) {
            GrainFeederBlock feeder = (GrainFeederBlock)((Object)gf.get());
            this.getVariantBuilder((Block)feeder).forAllStates(state -> {
                int originalRotation;
                Direction dir = (Direction)state.m_61143_((Property)GrainFeederBlock.f_54117_);
                boolean corner = (Boolean)state.m_61143_((Property)GrainFeederBlock.LEFT) != false || (Boolean)state.m_61143_((Property)GrainFeederBlock.RIGHT) != false;
                boolean occupied = false;
                int modelIndex = 0;
                if (corner) {
                    ++modelIndex;
                }
                if (occupied) {
                    modelIndex += 2;
                }
                ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("grain_feeder_" + (corner ? "corner_" : "") + (occupied ? "occupied_" : "") + feeder.getColour().m_41065_())).texture("0", ModRef.res("block/grain_feeder_" + (corner ? "corner_" : "") + feeder.getColour().m_41065_()))).texture("particle", ModRef.res("block/grain_feeder_" + (corner ? "corner_" : "") + feeder.getColour().m_41065_()))).parent((ModelFile)this.models().getExistingFile(ModRef.res(models[modelIndex])));
                int n = originalRotation = dir.m_122434_() != Direction.Axis.Y ? (dir.m_122416_() + 2) % 4 * 90 : 0;
                if (((Boolean)state.m_61143_((Property)GrainFeederBlock.RIGHT)).booleanValue() && (originalRotation += 90) == 360) {
                    originalRotation = 0;
                }
                return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(originalRotation).build();
            });
        }
    }

    protected void registerNonParallelBlock(List<RegistryObject<NonParallelBlock>> blockArray) {
        String[] models = new String[]{"block/separator_single", "block/separator_left", "block/separator_middle", "block/separator_right"};
        for (RegistryObject<NonParallelBlock> sep : blockArray) {
            NonParallelBlock sepBlock = (NonParallelBlock)((Object)sep.get());
            ((ItemModelBuilder)this.itemModels().withExistingParent("item/" + sepBlock.m_49954_().getString().split("\\.")[2], "item/generated")).texture("layer0", ModRef.res("item/" + sepBlock.m_49954_().getString().split("\\.")[2]));
            this.getVariantBuilder((Block)sepBlock).forAllStates(state -> {
                Direction dir = (Direction)state.m_61143_((Property)WheelBarrowBlock.f_54117_);
                ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("separator_" + ((SWEMBlockStateProperties.TwoWay)((Object)((Object)state.m_61143_(NonParallelBlock.PART)))).m_7912_() + "_" + sepBlock.getColour().m_41065_())).texture("0", ModRef.res("block/separator_" + ((SWEMBlockStateProperties.TwoWay)((Object)((Object)state.m_61143_(NonParallelBlock.PART)))).m_7912_() + "_" + sepBlock.getColour().m_41065_()))).texture("particle", ModRef.res("block/separator_" + ((SWEMBlockStateProperties.TwoWay)((Object)((Object)state.m_61143_(NonParallelBlock.PART)))).m_7912_() + "_" + sepBlock.getColour().m_41065_()))).parent((ModelFile)this.models().getExistingFile(ModRef.res(models[((SWEMBlockStateProperties.TwoWay)((Object)((Object)state.m_61143_(NonParallelBlock.PART)))).getId()])));
                return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(dir.m_122434_() != Direction.Axis.Y ? (dir.m_122416_() + 2) % 4 * 90 : 0).build();
            });
        }
    }

    protected void registerRacks() {
        this.registerRack(BlockSetup.BLANKET_5_RACK, this.mcLoc("block/iron_block"));
        this.registerRack(BlockSetup.HALTER_LEAD_RACK, this.mcLoc("block/black_concrete"));
        this.registerRack(BlockSetup.SADDLE_RACK, this.mcLoc("block/iron_block"));
    }

    protected void registerRack(RegistryObject<? extends Block> block, ResourceLocation particle) {
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.get()).part().modelFile((ModelFile)this.models().cubeAll(block.getId().m_135815_(), particle)).addModel()).end();
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + block.getId().m_135815_()));
    }

    protected void registerWheelBarrows() {
        String[] models = new String[]{"block/wheel_barrow", "block/wheel_barrow_level_1", "block/wheel_barrow_level_2", "block/wheel_barrow_level_3", "block/wheel_barrow_full"};
        for (RegistryObject<WheelBarrowBlock> wb : BlockSetup.WHEEL_BARROWS) {
            WheelBarrowBlock wheel = (WheelBarrowBlock)((Object)wb.get());
            ((ItemModelBuilder)this.itemModels().withExistingParent("item/" + wheel.m_49954_().getString().split("\\.")[2], "item/generated")).texture("layer0", ModRef.res("item/" + wheel.m_49954_().getString().split("\\.")[2]));
            this.getVariantBuilder((Block)wheel).forAllStates(state -> {
                Direction dir = (Direction)state.m_61143_((Property)WheelBarrowBlock.f_54117_);
                ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(models[(Integer)state.m_61143_((Property)WheelBarrowBlock.LEVEL)] + "_" + wheel.getColour().m_41065_())).texture("0", ModRef.res("block/wheel_barrow_" + wheel.getColour().m_41065_()))).texture("particle", new ResourceLocation("block/" + wheel.getColour().m_41065_() + "_concrete"))).parent((ModelFile)this.models().getExistingFile(ModRef.res(models[(Integer)state.m_61143_((Property)WheelBarrowBlock.LEVEL)])));
                return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(dir.m_122434_() != Direction.Axis.Y ? (dir.m_122416_() + 2) % 4 * 90 : 0).build();
            });
        }
    }

    private void registerSlowFeeders() {
        String[] models = new String[]{"block/slow_feeder", "block/slow_feeder_corner"};
        for (RegistryObject<SlowFeederBlock> sf : BlockSetup.SLOW_FEEDERS) {
            SlowFeederBlock slow = (SlowFeederBlock)((Object)sf.get());
            ((ItemModelBuilder)this.itemModels().withExistingParent("item/" + slow.m_49954_().getString().split("\\.")[2], "item/generated")).texture("layer0", ModRef.res("item/" + slow.m_49954_().getString().split("\\.")[2]));
            ModelBuilder sfModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(models[0] + "_" + slow.getColour().m_41065_())).texture("0", ModRef.res("block/" + models[0].split("/")[1] + "_" + slow.getColour().m_41065_()))).texture("particle", new ResourceLocation("block/" + ((SlowFeederBlock)((Object)sf.get())).getColour().m_41065_() + "_concrete"))).parent((ModelFile)this.models().getExistingFile(ModRef.res(models[0])));
            ModelBuilder sfCornerModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(models[1] + "_" + slow.getColour().m_41065_())).texture("0", ModRef.res("block/" + models[1].split("/")[1] + "_" + slow.getColour().m_41065_()))).texture("particle", new ResourceLocation("block/" + ((SlowFeederBlock)((Object)sf.get())).getColour().m_41065_() + "_concrete"))).parent((ModelFile)this.models().getExistingFile(ModRef.res(models[1])));
            MultiPartBlockStateBuilder mp = this.getMultipartBuilder(slow);
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfCornerModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfCornerModel).rotationY(90).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfCornerModel).rotationY(180).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfCornerModel).rotationY(270).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{false, true}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{true, false});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{true, false}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{true, false}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{true, false}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)sfModel).addModel()).condition((Property)SlowFeederBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)SlowFeederBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)this.models().getExistingFile(ModRef.res("block/full_feeder"))).addModel()).condition((Property)SlowFeederBlock.LEVEL, (Comparable[])new Integer[]{2});
            ((MultiPartBlockStateBuilder.PartBuilder)mp.part().modelFile((ModelFile)this.models().getExistingFile(ModRef.res("block/half_feeder"))).addModel()).condition((Property)SlowFeederBlock.LEVEL, (Comparable[])new Integer[]{1});
        }
    }

    private void trophy(RegistryObject<TrophyBlock> rb, ResourceLocation texture) {
        ModelFile.ExistingModelFile baseModel = this.models().getExistingFile(ModRef.res("trophy_template"));
        this.horizontalBlock((Block)rb.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(rb.getId().toString())).parent((ModelFile)baseModel)).texture("texture", texture));
        ((ItemModelBuilder)this.itemModels().withExistingParent(rb.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + rb.getId().m_135815_() + "_icon"));
    }

    private void plaque(RegistryObject<PlaqueBlock> rb, ResourceLocation texture) {
        ModelFile.ExistingModelFile baseModel = this.models().getExistingFile(ModRef.res("plaque_template"));
        this.horizontalBlock((Block)rb.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(rb.getId().toString())).parent((ModelFile)baseModel)).texture("texture", texture));
        ((ItemModelBuilder)this.itemModels().withExistingParent(rb.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + rb.getId().m_135815_() + "_icon"));
    }

    private void ribbon(RegistryObject<RibbonBlock> rb, ResourceLocation texture) {
        ModelFile.ExistingModelFile template = ((RibbonBlock)((Object)rb.get())).type == RibbonBlock.Type.TWO_TAILED ? this.models().getExistingFile(ModRef.res("ribbon_two_tailed_template")) : (((RibbonBlock)((Object)rb.get())).type == RibbonBlock.Type.THREE_TAILED ? this.models().getExistingFile(ModRef.res("ribbon_three_tailed_template")) : this.models().getExistingFile(ModRef.res("rosette_template")));
        this.horizontalBlock((Block)rb.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(rb.getId().toString())).parent((ModelFile)template)).texture("texture", texture));
        ((ItemModelBuilder)this.itemModels().withExistingParent(rb.getId().m_135815_(), "item/generated")).texture("layer0", this.modLoc("item/" + rb.getId().m_135815_() + "_icon"));
    }

    private /* synthetic */ void lambda$registerGrainBins$5(RegistryObject bin, ModelFile binModel, ModelFile lidClosedModel, ModelFile lidOpenModel, Direction facing) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)bin.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().rotationY((int)((facing.m_122435_() + 180.0f) % 360.0f)).modelFile(binModel).addModel()).condition((Property)GrainBinBlock.f_54117_, (Comparable[])new Direction[]{facing});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().rotationY((int)((facing.m_122435_() + 180.0f) % 360.0f)).modelFile(lidClosedModel).addModel()).condition((Property)GrainBinBlock.f_54117_, (Comparable[])new Direction[]{facing}).condition((Property)GrainBinBlock.OPEN, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().rotationY((int)((facing.m_122435_() + 180.0f) % 360.0f)).modelFile(lidOpenModel).addModel()).condition((Property)GrainBinBlock.f_54117_, (Comparable[])new Direction[]{facing}).condition((Property)GrainBinBlock.OPEN, (Comparable[])new Boolean[]{true});
    }

    private /* synthetic */ void lambda$registerGrainBins$3(RegistryObject bin, ModelFile binModel, ModelFile lidClosedModel, ModelFile lidOpenModel, Direction facing) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)bin.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().rotationY((int)((facing.m_122435_() + 180.0f) % 360.0f)).modelFile(binModel).addModel()).condition((Property)GrainBinBlock.f_54117_, (Comparable[])new Direction[]{facing});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().rotationY((int)((facing.m_122435_() + 180.0f) % 360.0f)).modelFile(lidClosedModel).addModel()).condition((Property)GrainBinBlock.f_54117_, (Comparable[])new Direction[]{facing}).condition((Property)GrainBinBlock.OPEN, (Comparable[])new Boolean[]{false});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().rotationY((int)((facing.m_122435_() + 180.0f) % 360.0f)).modelFile(lidOpenModel).addModel()).condition((Property)GrainBinBlock.f_54117_, (Comparable[])new Direction[]{facing}).condition((Property)GrainBinBlock.OPEN, (Comparable[])new Boolean[]{true});
    }
}

