/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.ai;

import com.alaharranhonor.swem.forge.blocks.HalfBarrelBlock;
import com.alaharranhonor.swem.forge.blocks.WaterTroughBlock;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.EatingBehavior;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class HorseDrinkWaterGoal
extends Goal {
    private final Set<BlockPos> blacklist;
    private final SWEMHorseEntityBase horse;
    private BlockPos targetWaterPos;
    private BlockState targetWater;
    private int drinkTickTimer;
    private int stuckTimer;
    private BlockPos lastPos;

    public HorseDrinkWaterGoal(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.blacklist = new HashSet<BlockPos>();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.targetWaterPos != null && this.horse.canDrink();
    }

    public boolean m_8045_() {
        return this.drinkTickTimer > 0 && this.targetWaterPos != null && this.horse.m_9236_().m_8055_(this.targetWaterPos) == this.targetWater;
    }

    public void setup(BlockPos pos) {
        this.targetWaterPos = pos;
        this.targetWater = this.horse.m_9236_().m_8055_(pos);
    }

    public boolean hasTarget() {
        return this.targetWaterPos != null;
    }

    public void m_8056_() {
        this.horse.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.horse.m_21573_().m_26573_();
        this.horse.getBehavior(EatingBehavior.class).stopEating();
        this.targetWaterPos = null;
        this.targetWater = null;
        this.stuckTimer = 0;
        this.lastPos = null;
        this.drinkTickTimer = 0;
    }

    public void m_8037_() {
        if (this.drinkTickTimer > 0) {
            --this.drinkTickTimer;
            if (this.targetWaterPos != null) {
                BlockState state = this.horse.m_9236_().m_8055_(this.targetWaterPos);
                if (!(state.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || state.m_60734_() instanceof HalfBarrelBlock || state.m_60734_() instanceof WaterTroughBlock)) {
                    this.horse.getBehavior(EatingBehavior.class).stopEating();
                } else {
                    if (this.drinkTickTimer == 20) {
                        this.horse.startDrinking(this.targetWaterPos);
                        this.targetWaterPos = null;
                    }
                    return;
                }
            }
            return;
        }
        double distance = this.horse.m_20183_().m_123333_(new Vec3i(this.targetWaterPos.m_123341_(), this.targetWaterPos.m_123342_(), this.targetWaterPos.m_123343_()));
        if (distance <= 3.0) {
            boolean isAbove = this.targetWaterPos.m_123342_() > this.horse.m_20183_().m_123342_();
            this.horse.m_21573_().m_26573_();
            this.drinkTickTimer = 63;
            this.horse.getBehavior(EatingBehavior.class).startEatingAt(Vec3.m_82512_((Vec3i)this.targetWaterPos));
            this.horse.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)this.targetWaterPos));
            return;
        }
        this.horse.m_21573_().m_26519_((double)this.targetWaterPos.m_123341_(), (double)this.targetWaterPos.m_123342_(), (double)this.targetWaterPos.m_123343_(), 5.0);
        this.lastPos = this.horse.m_20183_();
        if (this.lastPos.equals((Object)this.horse.m_20183_())) {
            ++this.stuckTimer;
            if (this.stuckTimer > 80) {
                this.blacklist.add(this.targetWaterPos);
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        HorseDrinkWaterGoal.this.blacklist.remove(HorseDrinkWaterGoal.this.targetWaterPos);
                    }
                }, 30000L);
                this.m_8041_();
            }
        }
    }
}

