/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.ai;

import com.alaharranhonor.swem.forge.blocks.Shavings;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.PeeBehavior;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;

public class PeeGoal
extends Goal {
    private final SWEMHorseEntityBase horse;
    private final Level level;
    private final double speed;
    private int peeTimer;
    private BlockPos peeSpot;

    public PeeGoal(SWEMHorseEntityBase horse, double speed) {
        this.horse = horse;
        this.level = horse.m_9236_();
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public void findPeePos() {
        this.peeSpot = this.getPosOfBestBlock(BlockPos.m_274446_((Position)this.horse.m_20182_().m_82520_(0.0, 0.49, 0.0)));
    }

    public boolean hasPeePos() {
        return this.peeSpot != null;
    }

    public boolean m_8036_() {
        return (Boolean)ServerConfig.PEE_NEED_ENABLED.get() != false && !this.horse.m_6162_() && this.horse.getBehavior(PeeBehavior.class).needsToPee() && this.horse.m_20197_().isEmpty() && this.hasPeePos();
    }

    public void m_8056_() {
        this.level.m_7605_((Entity)this.horse, (byte)126);
        this.horse.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.peeTimer = 0;
        this.peeSpot = null;
    }

    public boolean m_8045_() {
        return this.peeSpot != null && this.peeTimer > 0 && this.horse.m_20197_().isEmpty();
    }

    public int getPeeTimer() {
        return this.peeTimer;
    }

    public void m_8037_() {
        if (this.peeTimer > 0) {
            --this.peeTimer;
            if (this.peeTimer == 38) {
                this.horse.getBehavior(PeeBehavior.class).pee(this.peeSpot);
                this.peeSpot = null;
            }
            return;
        }
        double distance = Math.sqrt(this.horse.m_20275_(this.peeSpot.m_123341_(), this.peeSpot.m_123342_(), this.peeSpot.m_123343_()));
        if (distance < 1.0) {
            this.peeTimer = 79;
            return;
        }
        this.horse.m_21573_().m_26519_((double)this.peeSpot.m_123341_(), (double)this.peeSpot.m_123342_(), (double)this.peeSpot.m_123343_(), this.speed);
    }

    private BlockPos getPosOfBestBlock(BlockPos pos) {
        ArrayList<BlockPos> shavingsPos = new ArrayList<BlockPos>();
        ArrayList<BlockPos> peePos = new ArrayList<BlockPos>();
        ArrayList<BlockPos> grassBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> sandBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> dirtblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> snowBlocks = new ArrayList<BlockPos>();
        int radius = 3;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                boolean isAir;
                BlockPos newPos = pos.m_7918_(x, 0, z);
                Path path = this.horse.m_21573_().m_7864_(newPos, 1);
                if (path == null || !path.m_77403_()) continue;
                BlockPos belowCheck = newPos.m_7495_();
                BlockState checkState = this.level.m_8055_(newPos);
                BlockState belowCheckState = this.level.m_8055_(belowCheck);
                boolean bl = isAir = checkState.m_60713_(Blocks.f_50016_) && checkState.m_60734_() != BlockSetup.HORSE_PEE.get();
                if (checkState.m_60734_() instanceof Shavings && checkState.m_60734_() != BlockSetup.SOILED_SHAVINGS.get()) {
                    shavingsPos.add(newPos);
                    continue;
                }
                if (belowCheckState.m_60713_(Blocks.f_50440_) && isAir) {
                    grassBlocks.add(newPos);
                    continue;
                }
                if (belowCheckState.m_60713_(Blocks.f_49992_) && isAir) {
                    sandBlocks.add(newPos);
                    continue;
                }
                if ((belowCheckState.m_60713_(Blocks.f_50493_) || belowCheckState.m_60713_(Blocks.f_152481_)) && isAir) {
                    dirtblocks.add(newPos);
                    continue;
                }
                if (belowCheckState.m_60713_(Blocks.f_50127_) || checkState.m_60713_(Blocks.f_50125_)) {
                    snowBlocks.add(newPos);
                    continue;
                }
                if (!isAir || belowCheckState.m_60734_() == Blocks.f_50016_ || checkState.m_60734_() == BlockSetup.HORSE_PEE.get() || !belowCheckState.m_60819_().m_76178_() || !checkState.m_60819_().m_76178_() || !belowCheckState.m_60783_((BlockGetter)this.level, belowCheck, Direction.UP)) continue;
                peePos.add(newPos);
            }
        }
        return !shavingsPos.isEmpty() ? (BlockPos)shavingsPos.get(this.horse.m_217043_().m_188503_(shavingsPos.size())) : (!grassBlocks.isEmpty() ? (BlockPos)grassBlocks.get(this.horse.m_217043_().m_188503_(grassBlocks.size())) : (!sandBlocks.isEmpty() ? (BlockPos)sandBlocks.get(this.horse.m_217043_().m_188503_(sandBlocks.size())) : (!dirtblocks.isEmpty() ? (BlockPos)dirtblocks.get(this.horse.m_217043_().m_188503_(dirtblocks.size())) : (!snowBlocks.isEmpty() ? (BlockPos)snowBlocks.get(this.horse.m_217043_().m_188503_(snowBlocks.size())) : (!peePos.isEmpty() ? (BlockPos)peePos.get(this.horse.m_217043_().m_188503_(peePos.size())) : null)))));
    }
}

