/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.blocks.HalfBarrelBlock;
import com.alaharranhonor.swem.forge.blocks.HitchingPostBase;
import com.alaharranhonor.swem.forge.blocks.PaddockFeederBlock;
import com.alaharranhonor.swem.forge.blocks.WaterTroughBlock;
import com.alaharranhonor.swem.forge.client.KeyBindSetup;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.community.content.tack.type.HorseArmorTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.PastureBlanketTypeData;
import com.alaharranhonor.swem.forge.community.content.tack.type.TackTypeData;
import com.alaharranhonor.swem.forge.config.ClientConfig;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.container.SWEMHorseInventoryContainer;
import com.alaharranhonor.swem.forge.data.HorseDataElement;
import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.Tackable;
import com.alaharranhonor.swem.forge.entities.ai.CustomBreedGoal;
import com.alaharranhonor.swem.forge.entities.ai.HorseAvoidEntityGoal;
import com.alaharranhonor.swem.forge.entities.ai.HorseDrinkWaterGoal;
import com.alaharranhonor.swem.forge.entities.ai.HorseDrinkWaterGoalStanding;
import com.alaharranhonor.swem.forge.entities.ai.HorseEatFoodGoal;
import com.alaharranhonor.swem.forge.entities.ai.HorseEatFoodGroundGoal;
import com.alaharranhonor.swem.forge.entities.ai.HorseWaterAvoidingRandomWalkingGoal;
import com.alaharranhonor.swem.forge.entities.ai.MoveToWhistleGoal;
import com.alaharranhonor.swem.forge.entities.ai.NaturalFallInLoveGoal;
import com.alaharranhonor.swem.forge.entities.ai.PeeGoal;
import com.alaharranhonor.swem.forge.entities.ai.PoopGoal;
import com.alaharranhonor.swem.forge.entities.ai.SleepingGoal;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.BehaviorManager;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.IBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.ActionBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.BreedingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.CoatBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.EatingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.FlightBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.FussyBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.GodBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.LayingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.LineageBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.PeeBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.PoopBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.RRPAnimBehavior;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.SleepingBehavior;
import com.alaharranhonor.swem.forge.entities.horse.coats.BaseCoats;
import com.alaharranhonor.swem.forge.entities.horse.coats.CoatManager;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseCoat;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseColor;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedItem;
import com.alaharranhonor.swem.forge.entities.horse.needs.Feeds;
import com.alaharranhonor.swem.forge.entities.horse.needs.HungerNeed;
import com.alaharranhonor.swem.forge.entities.horse.needs.NeedManager;
import com.alaharranhonor.swem.forge.entities.horse.needs.SpecialFeedItem;
import com.alaharranhonor.swem.forge.entities.horse.progression.HorseSkill;
import com.alaharranhonor.swem.forge.entities.horse.progression.ProgressionManager;
import com.alaharranhonor.swem.forge.event.EventFactory;
import com.alaharranhonor.swem.forge.eventhandlers.CommonEventHandler;
import com.alaharranhonor.swem.forge.items.TrackerItem;
import com.alaharranhonor.swem.forge.items.tack.HorseArmorTier;
import com.alaharranhonor.swem.forge.items.tack.TackItem;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.CCameraLockPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.CSyncMovementIdentifiersPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ClientboundHorseInventoryPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ClientboundHorseSyncInventoryPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseActionPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseAnimationPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseJumpPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseXPPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.flight.ServerBoundSetFlightPacket;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.registry.EntitySetup;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import com.alaharranhonor.swem.forge.registry.ParticleSetup;
import com.alaharranhonor.swem.forge.tileentity.HorseFeeder;
import com.alaharranhonor.swem.forge.util.InventoryUtil;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.alaharranhonor.swem.forge.util.SWEMUtil;
import com.alaharranhonor.swem.forge.util.TimeUtil;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.RawAnimation;

public abstract class SWEMHorseEntityBase
extends AbstractHorse
implements GeoEntity,
Tackable,
IEntityAdditionalSpawnData {
    public static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.SUGAR_CUBE.get()});
    public static final Ingredient BREEDING_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.SCOOP_FEED_ROSE.get(), (ItemLike)ItemSetup.FEED_ROSE_OPENED.get(), (ItemLike)ItemSetup.TOKEN_BREEDING_HORSE.get()});
    public static final Ingredient NEGATIVE_FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_, Items.f_42129_});
    public static final EntityDataAccessor<CompoundTag> LINEAGE_DATA = SynchedEntityData.m_135353_(SWEMHorseEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    public static final EntityDataAccessor<Boolean> JUMPING = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GAIT_ID = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Byte> RIDING_PERMISSION_DATA = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Boolean> TRACKED = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RENDER_SADDLE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RENDER_BRIDLE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RENDER_BLANKET = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RENDER_GIRTH_STRAP = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_BRIDLE_LEASHED = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<GlobalPos>> HOME = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_238113_);
    public static final EntityDataAccessor<Boolean> FLUTTER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_LAYING_DOWN = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> JUMP_ANIM_TIMER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> IS_SAD = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RRP_SAD = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_SHAKING = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_SCRATCHING = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_ID = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> OWNER_NAME = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> CAMERA_LOCK = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GALLOP_TIMER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GALLOP_COOLDOWN_TIMER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GALLOP_ON_COOLDOWN = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MOVING_FORWARD = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MOVING_BACKWARDS = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MOVING_LEFT = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MOVING_RIGHT = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> SPEED_LEVEL = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> SPEED_XP = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> JUMP_LEVEL = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> JUMP_XP = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> HEALTH_LEVEL = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> HEALTH_XP = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> AFFINITY_LEVEL = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> AFFINITY_XP = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<ItemStack> CURRENT_DESENSITIZING_ITEM = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> OBEDIENCE_MODIFIER = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> BLOCKS_TRAVELLED_STAT = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> JUMP_STAT = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BREEDINGS = SynchedEntityData.m_135353_(SWEMHorseEntityBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HUNGER_STATE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> THIRST_STATE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TOTAL_TIMES_FED = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    private static final Random rand = new Random();
    private BlockPos lastBlockPosition;
    private final ArrayList<UUID> allowedList = new ArrayList();
    public Entity leashHolder2;
    public CompoundTag leashInfoTag2;
    public int delayedLeashHolderId2;
    public double jumpHeight;
    public boolean isWalkingBackwards = false;
    private LazyOptional<IItemHandler> saddlebagItemHandler;
    protected SimpleContainer saddlebagInventory;
    private int maxGallopSeconds = 7;
    private float lockedXRot;
    private float lockedYRot;
    private boolean isIceEffectActive = true;
    public int stillTimer;
    public Set<ResourceLocation> eatenSpecialFeeds = new HashSet<ResourceLocation>();
    public int intakeCheckOffset;
    private boolean isFalling;
    private int jumpTimer;
    public int disobedienceTimer = 0;
    private HorseDataElement horseData;
    public final ProgressionManager progressionManager;
    private final NeedManager needs;
    private PanicGoal panicGoal;
    private PeeGoal peeGoal;
    private PoopGoal poopGoal;
    private MoveToWhistleGoal whistleGoal;
    private HorseEatFoodGoal foodGoal;
    private HorseEatFoodGroundGoal foodGoalGround;
    private HorseDrinkWaterGoal waterGoal;
    private HorseDrinkWaterGoalStanding waterGoalStanding;
    private final BehaviorManager behaviorManager = new BehaviorManager(this);

    public static <T> EntityDataAccessor<T> defineDataId(EntityDataSerializer<T> value) {
        return SynchedEntityData.m_135353_(SWEMHorseEntityBase.class, value);
    }

    public SWEMHorseEntityBase(EntityType<? extends AbstractHorse> type, Level levelIn) {
        super(type, levelIn);
        this.lastBlockPosition = this.m_20183_();
        this.progressionManager = new ProgressionManager(this);
        this.setGait(Gait.WALK);
        this.needs = new NeedManager(this);
        this.createSaddlebagInventory();
        this.registerBehaviors();
        this.behaviorManager.defineData(this.f_19804_);
        if (!levelIn.m_5776_() && (double)levelIn.m_213780_().m_188501_() > 0.49) {
            this.getBehavior(BreedingBehavior.class).setFemale(true);
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        if (this.m_20194_() != null) {
            CommonEventHandler.getHorseDataManager().save(this.m_20194_());
        }
    }

    public static AttributeSupplier.Builder createBaseSWEMHorseAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_);
    }

    protected void m_8099_() {
        this.peeGoal = new PeeGoal(this, 4.0);
        this.poopGoal = new PoopGoal(this);
        this.foodGoal = new HorseEatFoodGoal(this);
        this.foodGoalGround = new HorseEatFoodGroundGoal(this);
        this.waterGoal = new HorseDrinkWaterGoal(this);
        this.waterGoalStanding = new HorseDrinkWaterGoalStanding(this);
        this.whistleGoal = new MoveToWhistleGoal(this, 1.8);
        this.panicGoal = new PanicGoal((PathfinderMob)this, 8.0);
        this.f_21345_.m_25352_(0, (Goal)new SleepingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)this.panicGoal);
        this.f_21345_.m_25352_(1, (Goal)this.whistleGoal);
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 4.0));
        this.f_21345_.m_25352_(2, (Goal)new CustomBreedGoal(this, 4.0));
        this.f_21345_.m_25352_(2, new HorseAvoidEntityGoal<Pig>(this, Pig.class, 12.0f, 4.0, 5.5));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 4.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)this.waterGoalStanding);
        this.f_21345_.m_25352_(5, (Goal)this.waterGoal);
        this.f_21345_.m_25352_(5, (Goal)this.foodGoalGround);
        this.f_21345_.m_25352_(5, (Goal)this.foodGoal);
        this.f_21345_.m_25352_(7, (Goal)this.poopGoal);
        this.f_21345_.m_25352_(7, (Goal)this.peeGoal);
        this.f_21345_.m_25352_(8, (Goal)new NaturalFallInLoveGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new HorseWaterAvoidingRandomWalkingGoal(this, 4.0));
    }

    protected void registerBehaviors() {
        this.behaviorManager.add(new PeeBehavior(this));
        this.behaviorManager.add(new PoopBehavior(this));
        this.behaviorManager.add(new SleepingBehavior(this));
        this.behaviorManager.add(new EatingBehavior(this));
        this.behaviorManager.add(new ActionBehavior(this));
        this.behaviorManager.add(new LayingBehavior(this));
        this.behaviorManager.add(new FlightBehavior(this));
        this.behaviorManager.add(new BreedingBehavior(this));
        this.behaviorManager.add(new LineageBehavior(this));
        this.behaviorManager.add(new CoatBehavior(this));
        this.behaviorManager.add(new RRPAnimBehavior(this));
        this.behaviorManager.add(new FussyBehavior(this));
        this.behaviorManager.add(new GodBehavior(this));
    }

    protected void m_214179_(RandomSource pRandom) {
        this.m_21051_(Attributes.f_22276_).m_22100_(this.getAlteredMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.getAlteredMovementSpeed());
        this.m_21051_(Attributes.f_22288_).m_22100_(this.getAlteredJumpStrength());
        this.setGait(this.getGait());
    }

    public float getStepHeight() {
        float defaultStep = 1.15f;
        AttributeInstance stepHeightAttribute = this.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepHeightAttribute != null) {
            return (float)Math.max(0.0, (double)defaultStep + stepHeightAttribute.m_22135_());
        }
        return defaultStep;
    }

    public void m_6667_(DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        if (this.m_9236_().m_7654_() == null) {
            return;
        }
        if (this.horseData != null) {
            this.horseData.setDead();
        }
        String owner = StringUtil.m_14408_((String)this.getOwnerName()) ? "<None>" : this.getOwnerName();
        String name = this.m_8077_() ? this.m_7770_().getString() : "<None>";
        String horseCoat = this.getCoatBehavior().coat().id().toString();
        String stats = this.progressionManager.simpleString();
        String killer = pDamageSource.m_7639_() == null ? "<None>" : pDamageSource.m_7639_().m_5446_().getString();
        String cause = pDamageSource.m_6157_((LivingEntity)this).getString();
        Player nearbyPlayer = this.m_9236_().m_45930_((Entity)this, 25.0);
        String nearestPlayer = nearbyPlayer == null ? "<None>" : nearbyPlayer.m_5446_().getString();
        String dimension = this.m_9236_().m_46472_().m_135782_().toString();
        String location = this.m_20183_().m_123344_();
        Component gender = this.getBreeding().getName();
        StringBuilder horseDeathLog = new StringBuilder("Horse Death").append("\n  Owner: ").append(owner).append("\n  Name: ").append(name).append("\n  Coat: ").append(horseCoat).append("\n  Stats: ").append(stats).append("\n  Killer: ").append(killer).append("\n  Cause: ").append(cause).append("\n  Nearest Player: ").append(nearestPlayer).append("\n  Dimension: ").append(dimension).append("\n  Location: ").append(location).append("\n  Gender: ").append(gender);
        ModRef.LOGGER.info((CharSequence)horseDeathLog);
        Commands commands = this.m_20194_().m_129892_();
        String command = "/" + horseDeathLog;
        commands.m_242674_(commands.m_82094_().parse(command, (Object)this.m_20194_().m_129893_()), command);
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
    }

    public void onPlayerWhistle(Player player, Gait speed) {
        if (this.isOwner(player)) {
            this.whistleGoal.setTarget(player, speed);
        }
    }

    public boolean m_30622_() {
        ActionBehavior.Action action = this.getBehavior(ActionBehavior.class).getActiveAction();
        return super.m_30622_() || action != null && action.isStanding();
    }

    public int m_213860_() {
        return 0;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11971_;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11975_;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        super.m_7975_(damageSourceIn);
        return SoundEvents.f_11978_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12035_, 0.15f, 1.0f);
    }

    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(OWNER_NAME);
    }

    public void setOwnerName(String ownerName) {
        this.f_19804_.m_135381_(OWNER_NAME, (Object)ownerName);
    }

    protected void m_8024_() {
        if (this.f_19797_ % (40 + this.intakeCheckOffset) == 0) {
            if (this.canEat()) {
                this.checkForNearbyFoodItems((Integer)ServerConfig.INTAKE_SEARCH_RADIUS.get());
                if (!this.foodGoalGround.hasTarget()) {
                    this.checkForBestFoodSource((Integer)ServerConfig.INTAKE_SEARCH_RADIUS.get());
                }
            }
            if (this.canDrink()) {
                this.checkForBestWaterSource((Integer)ServerConfig.INTAKE_SEARCH_RADIUS.get());
            }
            if (this.behaviorManager.getBehavior(PeeBehavior.class).needsToPee() && !this.peeGoal.hasPeePos()) {
                this.peeGoal.findPeePos();
            }
            this.intakeCheckOffset = this.f_19796_.m_188503_(120);
        }
        super.m_8024_();
    }

    public boolean isWaterSource(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        return state.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || state.m_60734_() instanceof HalfBarrelBlock && (Integer)state.m_61143_((Property)HalfBarrelBlock.LEVEL) > 0 || state.m_60734_() instanceof WaterTroughBlock && (Integer)state.m_61143_((Property)WaterTroughBlock.LEVEL) > 0;
    }

    public BlockPos getDrinkPos() {
        Vec3 offset = Vec3.m_82498_((float)0.0f, (float)this.m_6080_()).m_82490_(1.5);
        BlockPos pos = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(offset.f_82479_, -0.5, offset.f_82481_));
        if (this.isWaterSource(pos.m_7494_())) {
            return pos.m_7494_();
        }
        return pos;
    }

    private void checkForBestWaterSource(int searchRadius) {
        Path path;
        if (this.waterGoal.hasTarget()) {
            return;
        }
        BlockPos horsePos = this.m_20183_();
        AtomicReference<Object> bestPos = new AtomicReference<Object>(null);
        BlockPos.m_121921_((AABB)new AABB(horsePos).m_82377_((double)searchRadius, 3.0, (double)searchRadius)).forEach(pos -> {
            if (!this.isWaterSource((BlockPos)pos)) {
                return;
            }
            if (bestPos.get() == null) {
                bestPos.set(pos.m_7949_());
                return;
            }
            if (horsePos.m_123331_((Vec3i)pos) < horsePos.m_123331_((Vec3i)bestPos.get())) {
                bestPos.set(pos.m_7949_());
            }
        });
        if (bestPos.get() != null && (path = this.f_21344_.m_7864_((BlockPos)bestPos.get(), 2)) != null && path.m_77403_()) {
            this.waterGoal.setup(bestPos.get());
        }
    }

    private void checkForNearbyFoodItems(int searchRadius) {
        if (this.foodGoalGround.hasTarget()) {
            return;
        }
        boolean needsGrain = this.needs.getHunger().needsGrains();
        boolean isFull = this.needs.getHunger().hasMaxPoints();
        List feeds = this.m_9236_().m_6443_(ItemEntity.class, this.m_20191_().m_82377_((double)searchRadius, 1.0, (double)searchRadius), e -> true);
        ItemEntity bestItem = null;
        int bestPoints = -1;
        for (ItemEntity feedEntity : feeds) {
            Path path;
            FeedItem feed = Feeds.fromItem(feedEntity.m_32055_());
            if (feed == null || !this.isInterestedInFeed(feed) || feed.category() != FeedItem.Category.TREATS) continue;
            if (!isFull || !needsGrain || feed.category() == FeedItem.Category.GRAINS) {
                // empty if block
            }
            if (bestItem == null) {
                Path path2 = this.f_21344_.m_6570_((Entity)feedEntity, 1);
                if (path2 == null || !path2.m_77403_()) continue;
                bestItem = feedEntity;
                bestPoints = feed.pointsGiven();
                continue;
            }
            int points = feed.pointsGiven();
            if (points < bestPoints || points == bestPoints && feedEntity.m_20270_((Entity)this) >= bestItem.m_20270_((Entity)this) || (path = this.f_21344_.m_6570_((Entity)feedEntity, 1)) == null || !path.m_77403_()) continue;
            bestItem = feedEntity;
            bestPoints = feed.pointsGiven();
        }
        if (bestPoints > 0) {
            this.foodGoalGround.setTarget(bestItem);
        }
    }

    public void checkForBestFoodSource(int searchRadius) {
        if (this.foodGoal.hasTarget()) {
            return;
        }
        BlockPos horsePos = this.m_20183_();
        AtomicReference bestPos = new AtomicReference();
        AtomicReference bestCategory = new AtomicReference();
        AtomicReference<Integer> bestPoints = new AtomicReference<Integer>(-1);
        BlockPos.m_121921_((AABB)new AABB(horsePos).m_82377_((double)searchRadius, 3.0, (double)searchRadius)).forEach(pos -> {
            FeedItem feed;
            if (this.foodGoal.isPosBlacklisted((BlockPos)pos)) {
                return;
            }
            BlockState state = this.m_9236_().m_8055_(pos);
            BlockEntity be = this.m_9236_().m_7702_(pos);
            if (state.m_60713_((Block)BlockSetup.PADDOCK_FEEDER.get())) {
                be = this.m_9236_().m_7702_(PaddockFeederBlock.getMainPos(state, pos));
            }
            if (be instanceof HorseFeeder) {
                HorseFeeder feeder = (HorseFeeder)be;
                feed = Feeds.fromItem(feeder.peekStack(0));
            } else {
                feed = Feeds.fromBlock(state.m_60734_());
            }
            if (feed == null || !this.isInterestedInFeed(feed)) {
                return;
            }
            if (bestPos.get() == null) {
                bestPos.set(pos.m_7949_());
                bestCategory.set(feed.category());
                bestPoints.set(feed.getPointsForState(state));
                return;
            }
            if (feed.category().priority < ((FeedItem.Category)((Object)((Object)bestCategory.get()))).priority) {
                return;
            }
            if (feed.category().priority > ((FeedItem.Category)((Object)((Object)bestCategory.get()))).priority) {
                bestPos.set(pos.m_7949_());
                bestCategory.set(feed.category());
                bestPoints.set(feed.getPointsForState(state));
                return;
            }
            int points = feed.getPointsForState(state);
            if (points >= (Integer)bestPoints.get()) {
                if (points == (Integer)bestPoints.get() && pos.m_123331_((Vec3i)horsePos) >= ((BlockPos)bestPos.get()).m_123331_((Vec3i)horsePos)) {
                    return;
                }
                bestPos.set(pos.m_7949_());
                bestCategory.set(feed.category());
                bestPoints.set(feed.getPointsForState(state));
            }
        });
        if (bestPoints.get() > 0 && bestPos.get() != null) {
            this.foodGoal.setup((BlockPos)bestPos.get());
        }
    }

    public void startDrinking(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        this.m_9236_().m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.NEUTRAL, 0.75f, this.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
        if (state.m_60734_() instanceof WaterTroughBlock) {
            this.drinkFromTrough(pos, state);
        } else if (state.m_60734_() instanceof HalfBarrelBlock) {
            this.drinkFromHalfBarrel(pos, state);
        } else if (state.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            this.drinkFromWaterSource(pos, state);
        }
        this.getNeeds().getThirst().drink();
        this.getBehavior(EatingBehavior.class).stopEating();
    }

    private void drinkFromHalfBarrel(BlockPos pos, BlockState state) {
        this.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)HalfBarrelBlock.LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)HalfBarrelBlock.LEVEL) - 1)), 3);
    }

    private void drinkFromTrough(BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof WaterTroughBlock) {
            WaterTroughBlock trough = (WaterTroughBlock)block;
            trough.setWaterLevel(this.m_9236_(), pos, state, true);
        }
    }

    private void drinkFromWaterSource(BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            this.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public boolean isInterestedInFeed(FeedItem feed) {
        return this.getNeeds().getHunger().canEatFeed(feed);
    }

    public void awardIntegerStat(EntityDataAccessor<Integer> stat, int amount) {
        this.m_20088_().m_135381_(stat, (Object)((Integer)this.m_20088_().m_135370_(stat) + amount));
        this.checkIntegerStat(stat);
    }

    private void checkIntegerStat(EntityDataAccessor<Integer> stat) {
        if (stat == BLOCKS_TRAVELLED_STAT ? (Integer)this.m_20088_().m_135370_(stat) % 3000 == 0 : stat != JUMP_STAT || (Integer)this.m_20088_().m_135370_(stat) % 50 == 0) {
            // empty if block
        }
    }

    public void m_8107_() {
        this.disobedienceTimer = Math.max(0, this.disobedienceTimer - 1);
        if (!this.m_9236_().f_46443_) {
            ActionBehavior actions;
            if (this.isCrossTied()) {
                Vec3 mid = this.getCrossTieMiddlePoint();
                if (this.m_20182_().m_82554_(mid) > 0.1) {
                    this.f_21344_.m_26519_(mid.f_82479_, mid.f_82480_, mid.f_82481_, 1.0);
                }
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, mid);
                this.m_5618_(this.m_6080_());
                this.f_21345_.m_25355_(Goal.Flag.JUMP);
                this.f_21345_.m_25355_(Goal.Flag.MOVE);
                this.f_21345_.m_25355_(Goal.Flag.LOOK);
                this.f_21345_.m_25355_(Goal.Flag.TARGET);
            } else {
                this.f_21345_.m_25374_(Goal.Flag.JUMP);
                this.f_21345_.m_25374_(Goal.Flag.MOVE);
                this.f_21345_.m_25374_(Goal.Flag.LOOK);
                this.f_21345_.m_25374_(Goal.Flag.TARGET);
            }
            this.m_20088_().m_135381_(JUMP_ANIM_TIMER, (Object)Math.max(-1, (Integer)this.m_20088_().m_135370_(JUMP_ANIM_TIMER) - 1));
            if (this.m_6069_() && this.getGait() != Gait.WALK) {
                this.setGait(Gait.WALK);
            }
            if (this.m_21524_() instanceof Player) {
                this.m_21563_().m_24960_(this.m_21524_(), (float)this.m_21529_(), (float)this.m_8132_());
            }
            if ((actions = this.behaviorManager.getBehavior(ActionBehavior.class)).getActiveAction() == null && this.m_30647_(32)) {
                this.m_30665_(false);
            }
            this.needs.tick();
            if ((int)(this.m_9236_().m_46468_() % 24000L) == 10000) {
                this.resetDaily();
            }
            if (((Boolean)this.f_19804_.m_135370_(GALLOP_ON_COOLDOWN)).booleanValue()) {
                this.f_19804_.m_135381_(GALLOP_TIMER, (Object)((Integer)this.f_19804_.m_135370_(GALLOP_TIMER) + 1));
                int currentTimer = (Integer)this.f_19804_.m_135370_(GALLOP_TIMER);
                int cooldownTimer = (Integer)this.f_19804_.m_135370_(GALLOP_COOLDOWN_TIMER);
                if (currentTimer >= cooldownTimer) {
                    this.resetGallopCooldown();
                }
            } else if (this.getGait() == Gait.GALLOP && !((Boolean)this.f_19804_.m_135370_(GALLOP_ON_COOLDOWN)).booleanValue()) {
                int timer = (Integer)this.f_19804_.m_135370_(GALLOP_TIMER);
                this.f_19804_.m_135381_(GALLOP_TIMER, (Object)((Integer)this.f_19804_.m_135370_(GALLOP_TIMER) + 1));
                if (timer >= (this.maxGallopSeconds - this.needs.getGallopTimerReduction()) * 20) {
                    this.decrementSpeed();
                }
            }
            if (!this.m_20160_() && !this.isCameraLocked()) {
                this.setCameraLock(true);
            }
        }
        this.behaviorManager.forEach(behavior -> {
            if (behavior.shouldTick()) {
                behavior.tick();
            }
        });
        super.m_8107_();
    }

    private boolean isCrossTied() {
        return this.getLeashHolder1() instanceof LeashFenceKnotEntity && this.getLeashHolder2() instanceof LeashFenceKnotEntity;
    }

    private Vec3 getCrossTieMiddlePoint() {
        Vec3 leashOne = this.getLeashHolder1().m_20182_();
        Vec3 leashTwo = this.getLeashHolder2().m_20182_();
        return new Vec3((leashOne.f_82479_ + leashTwo.f_82479_) / 2.0, this.m_20186_(), (leashOne.f_82481_ + leashTwo.f_82481_) / 2.0);
    }

    private void resetDaily() {
        this.progressionManager.getAffinityLeveling().resetDaily();
    }

    public void onLevelUp(String oldLevel, String newLevel) {
        MutableComponent message = Component.m_237110_((String)"horse.swem.level_up", (Object[])new Object[]{this.m_5446_(), oldLevel, newLevel});
        this.messageRider((Component)message);
    }

    public void messageRider(Component msg) {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player rider = (Player)entity;
            rider.m_213846_(msg);
        }
    }

    private double getAlteredMovementSpeed() {
        switch (this.progressionManager.getSpeedLeveling().getLevel()) {
            case 1: {
                return SWEMUtil.getInternalSpeedFromBlocksPerSecond(13.0);
            }
            case 2: {
                return SWEMUtil.getInternalSpeedFromBlocksPerSecond(15.0);
            }
            case 3: {
                return SWEMUtil.getInternalSpeedFromBlocksPerSecond(17.0);
            }
            case 4: {
                return SWEMUtil.getInternalSpeedFromBlocksPerSecond(19.0);
            }
        }
        return SWEMUtil.getInternalSpeedFromBlocksPerSecond(11.0);
    }

    private double getAlteredJumpStrength() {
        switch (this.progressionManager.getJumpLeveling().getLevel()) {
            case 1: {
                return SWEMUtil.getInternalJumpFromBlocks(2.7);
            }
            case 2: {
                return SWEMUtil.getInternalJumpFromBlocks(3.7);
            }
            case 3: {
                return SWEMUtil.getInternalJumpFromBlocks(4.7);
            }
            case 4: {
                return SWEMUtil.getInternalJumpFromBlocks(5.7);
            }
        }
        return SWEMUtil.getInternalJumpFromBlocks(1.7);
    }

    public double getAlteredMaxHealth() {
        switch (this.progressionManager.getHealthLeveling().getLevel()) {
            case 1: {
                return 22.0;
            }
            case 2: {
                return 26.0;
            }
            case 3: {
                return 32.0;
            }
            case 4: {
                return 40.0;
            }
        }
        return 20.0;
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public void heal(float healAmount, float healthXp) {
        this.m_5634_(healAmount);
        this.progressionManager.getHealthLeveling().addXP(healthXp);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPEED_LEVEL, (Object)0);
        this.f_19804_.m_135372_(SPEED_XP, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(JUMP_LEVEL, (Object)0);
        this.f_19804_.m_135372_(JUMP_XP, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HEALTH_LEVEL, (Object)0);
        this.f_19804_.m_135372_(HEALTH_XP, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(AFFINITY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(AFFINITY_XP, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CURRENT_DESENSITIZING_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GALLOP_ON_COOLDOWN, (Object)false);
        this.f_19804_.m_135372_(GALLOP_COOLDOWN_TIMER, (Object)0);
        this.f_19804_.m_135372_(GALLOP_TIMER, (Object)0);
        this.f_19804_.m_135372_(GAIT_ID, (Object)0);
        this.f_19804_.m_135372_(FLUTTER, (Object)false);
        this.f_19804_.m_135372_(JUMPING, (Object)false);
        this.f_19804_.m_135372_(HOME, Optional.empty());
        this.f_19804_.m_135372_(OWNER_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_NAME, (Object)"");
        this.f_19804_.m_135372_(RIDING_PERMISSION_DATA, (Object)((byte)RidingPermission.TRUST.ordinal()));
        this.f_19804_.m_135372_(TRACKED, (Object)false);
        this.f_19804_.m_135372_(CAMERA_LOCK, (Object)true);
        this.f_19804_.m_135372_(JUMP_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(IS_LAYING_DOWN, (Object)false);
        this.f_19804_.m_135372_(IS_SAD, (Object)false);
        this.f_19804_.m_135372_(RRP_SAD, (Object)false);
        this.f_19804_.m_135372_(IS_SHAKING, (Object)false);
        this.f_19804_.m_135372_(IS_SCRATCHING, (Object)false);
        this.f_19804_.m_135372_(RENDER_SADDLE, (Object)true);
        this.f_19804_.m_135372_(RENDER_BLANKET, (Object)true);
        this.f_19804_.m_135372_(RENDER_BRIDLE, (Object)true);
        this.f_19804_.m_135372_(RENDER_GIRTH_STRAP, (Object)true);
        this.f_19804_.m_135372_(IS_BRIDLE_LEASHED, (Object)false);
        this.f_19804_.m_135372_(LINEAGE_DATA, (Object)new CompoundTag());
        this.f_19804_.m_135372_(IS_MOVING_FORWARD, (Object)false);
        this.f_19804_.m_135372_(IS_MOVING_BACKWARDS, (Object)false);
        this.f_19804_.m_135372_(IS_MOVING_LEFT, (Object)false);
        this.f_19804_.m_135372_(IS_MOVING_RIGHT, (Object)false);
        this.f_19804_.m_135372_(THIRST_STATE, (Object)3);
        this.f_19804_.m_135372_(HUNGER_STATE, (Object)3);
        this.f_19804_.m_135372_(TOTAL_TIMES_FED, (Object)0);
        this.f_19804_.m_135372_(OBEDIENCE_MODIFIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(BLOCKS_TRAVELLED_STAT, (Object)0);
        this.f_19804_.m_135372_(JUMP_STAT, (Object)0);
        this.f_19804_.m_135372_(BREEDINGS, (Object)0);
    }

    public void setMaxGallopSeconds(int gallopSeconds) {
        this.maxGallopSeconds = gallopSeconds;
    }

    public int getMaxGallopSeconds() {
        return this.maxGallopSeconds;
    }

    public void setTracked(boolean tracked) {
        this.f_19804_.m_135381_(TRACKED, (Object)tracked);
    }

    public boolean isBeingTracked() {
        return (Boolean)this.f_19804_.m_135370_(TRACKED);
    }

    public boolean isBridleLeashed() {
        return (Boolean)this.f_19804_.m_135370_(IS_BRIDLE_LEASHED);
    }

    public void setBridleLeashed(boolean bridleLeashed) {
        this.f_19804_.m_135381_(IS_BRIDLE_LEASHED, (Object)bridleLeashed);
    }

    protected void m_6119_() {
        Entity entity;
        if (this.m_21524_() != null && !this.m_21524_().m_6084_() && this.m_9236_().m_46859_(this.m_21524_().m_20183_())) {
            this.m_21455_(true, true);
            return;
        }
        if (this.f_21359_ != null) {
            this.m_21528_();
        }
        if (this.leashInfoTag2 != null) {
            this.restoreLeash2FromSave();
        }
        if (!(this.leashHolder2 == null || this.m_6084_() && this.leashHolder2.m_6084_())) {
            this.m_21455_(true, true);
        }
        if (!(this.f_21357_ == null || this.m_6084_() && this.f_21357_.m_6084_())) {
            this.m_21455_(true, true);
        }
        if ((entity = this.m_21524_()) != null && entity.m_9236_() == this.m_9236_()) {
            this.m_21446_(entity.m_20183_(), 5);
            float f = this.m_20270_(entity);
            this.m_7880_(f);
            if (f > 10.0f) {
                this.m_21455_(true, true);
                this.f_21345_.m_25355_(Goal.Flag.MOVE);
            } else if (f > 6.0f) {
                double d0 = (entity.m_20185_() - this.m_20185_()) / (double)f;
                double d1 = (entity.m_20186_() - this.m_20186_()) / (double)f;
                double d2 = (entity.m_20189_() - this.m_20189_()) / (double)f;
                this.m_20256_(this.m_20184_().m_82520_(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
            } else {
                this.f_21345_.m_25374_(Goal.Flag.MOVE);
                float f1 = 2.0f;
                Vec3 vector3d = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20186_() - this.m_20186_(), entity.m_20189_() - this.m_20189_()).m_82541_().m_82490_((double)Math.max(f - 2.0f, 0.0f));
                this.m_21573_().m_26519_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + vector3d.f_82480_, this.m_20189_() + vector3d.f_82481_, this.m_5823_());
            }
        }
    }

    public void m_21455_(boolean pSendPacket, boolean pDropLead) {
        BlockState state;
        if (this.isBridleLeashed()) {
            pDropLead = false;
            if (!this.m_9236_().f_46443_) {
                this.setBridleLeashed(false);
            }
        }
        if (this.leashHolder2 != null) {
            this.f_21359_ = null;
            if (!this.m_9236_().f_46443_ && pDropLead) {
                this.m_19998_((ItemLike)Items.f_42655_);
            }
            if (!this.m_9236_().f_46443_ && pSendPacket && this.m_9236_() instanceof ServerLevel) {
                if (this.leashHolder2 instanceof LeashFenceKnotEntity && !this.leashHolder2.m_213877_()) {
                    this.leashHolder2.m_6074_();
                    state = this.m_9236_().m_8055_(this.leashHolder2.m_20183_());
                    if (state.m_61138_((Property)HitchingPostBase.CUSTOM_LEAD)) {
                        this.m_9236_().m_7731_(this.leashHolder2.m_20183_(), (BlockState)state.m_61124_((Property)HitchingPostBase.CUSTOM_LEAD, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, null));
            }
            this.leashHolder2 = null;
        }
        if (this.f_21357_ != null) {
            this.f_21359_ = null;
            if (!this.m_9236_().f_46443_ && pDropLead) {
                this.m_19998_((ItemLike)Items.f_42655_);
            }
            if (!this.m_9236_().f_46443_ && pSendPacket && this.m_9236_() instanceof ServerLevel) {
                if (this.f_21357_ instanceof LeashFenceKnotEntity && !this.f_21357_.m_213877_()) {
                    this.f_21357_.m_6074_();
                    state = this.m_9236_().m_8055_(this.f_21357_.m_20183_());
                    if (state.m_61138_((Property)HitchingPostBase.CUSTOM_LEAD)) {
                        this.m_9236_().m_7731_(this.f_21357_.m_20183_(), (BlockState)state.m_61124_((Property)HitchingPostBase.CUSTOM_LEAD, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, null));
            }
            this.f_21357_ = null;
        }
    }

    public boolean m_6573_(Player player) {
        return this.canAccessHorse(player) && this.getLeashHolders().size() < 2;
    }

    public boolean m_21523_() {
        return this.f_21357_ != null;
    }

    @Nullable
    public Entity m_21524_() {
        if (this.leashHolder2 == null && this.delayedLeashHolderId2 != 0 && this.m_9236_().f_46443_) {
            this.leashHolder2 = this.m_9236_().m_6815_(this.delayedLeashHolderId2);
        }
        if (this.leashHolder2 != null) {
            return this.leashHolder2;
        }
        if (this.f_21357_ == null && this.f_21358_ != 0 && this.m_9236_().f_46443_) {
            this.f_21357_ = this.m_9236_().m_6815_(this.f_21358_);
        }
        return this.f_21357_;
    }

    public Entity getLeashHolder1() {
        if (this.f_21357_ == null && this.f_21358_ != 0 && this.m_9236_().f_46443_) {
            this.f_21357_ = this.m_9236_().m_6815_(this.f_21358_);
        }
        return this.f_21357_;
    }

    public Entity getLeashHolder2() {
        if (this.leashHolder2 == null && this.delayedLeashHolderId2 != 0 && this.m_9236_().f_46443_) {
            this.leashHolder2 = this.m_9236_().m_6815_(this.delayedLeashHolderId2);
        }
        return this.leashHolder2;
    }

    public List<Entity> getLeashHolders() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        Entity holder = this.getLeashHolder1();
        if (holder != null) {
            list.add(holder);
        }
        if ((holder = this.getLeashHolder2()) != null) {
            list.add(holder);
        }
        return list;
    }

    public void m_21463_(Entity pLeashHolder, boolean pBroadcastPacket) {
        if (this.f_21357_ == null || this.f_21357_ instanceof Player) {
            this.f_21357_ = pLeashHolder;
            this.f_21359_ = null;
            if (!this.m_9236_().f_46443_ && pBroadcastPacket && this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, this.f_21357_));
            }
        } else if (this.leashHolder2 == null || this.leashHolder2 instanceof Player) {
            this.leashHolder2 = pLeashHolder;
            this.leashInfoTag2 = null;
            if (!this.m_9236_().f_46443_ && pBroadcastPacket && this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, this.leashHolder2));
            }
        }
        if (this.m_20159_()) {
            this.m_8127_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_21506_(int pLeashHolderID) {
        if (pLeashHolderID == 0) {
            this.delayedLeashHolderId2 = pLeashHolderID;
            this.f_21358_ = pLeashHolderID;
        } else {
            Entity setTo = this.m_9236_().m_6815_(pLeashHolderID);
            if (setTo instanceof LeashFenceKnotEntity || setTo == null) {
                if (this.m_9236_().m_6815_(this.f_21358_) instanceof Player || this.m_9236_().m_6815_(this.f_21358_) == null && this.f_21358_ == 0) {
                    this.f_21358_ = pLeashHolderID;
                } else if (this.m_9236_().m_6815_(this.f_21358_) instanceof LeashFenceKnotEntity || this.m_9236_().m_6815_(this.f_21358_) == null && this.f_21358_ != 0) {
                    this.delayedLeashHolderId2 = pLeashHolderID;
                }
            } else if (setTo instanceof Player) {
                if (this.f_21358_ == 0) {
                    this.f_21358_ = pLeashHolderID;
                } else if (this.m_9236_().m_6815_(this.f_21358_) instanceof LeashFenceKnotEntity) {
                    this.delayedLeashHolderId2 = pLeashHolderID;
                }
            }
        }
        this.m_21455_(false, false);
    }

    public void m_21528_() {
        if (this.f_21359_ != null && this.m_9236_() instanceof ServerLevel) {
            if (this.f_21359_.m_128403_("UUID")) {
                UUID uuid = this.f_21359_.m_128342_("UUID");
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
                if (entity != null) {
                    this.m_21463_(entity, true);
                    return;
                }
            } else if (this.f_21359_.m_128425_("X", 99) && this.f_21359_.m_128425_("Y", 99) && this.f_21359_.m_128425_("Z", 99)) {
                BlockPos blockpos = new BlockPos(this.f_21359_.m_128451_("X"), this.f_21359_.m_128451_("Y"), this.f_21359_.m_128451_("Z"));
                this.m_21463_((Entity)LeashFenceKnotEntity.m_31844_((Level)this.m_9236_(), (BlockPos)blockpos), true);
                return;
            }
            if (this.f_19797_ > 100) {
                this.m_19998_((ItemLike)Items.f_42655_);
                this.f_21359_ = null;
            }
        }
    }

    public void restoreLeash2FromSave() {
        if (this.leashInfoTag2 != null && this.m_9236_() instanceof ServerLevel) {
            if (this.leashInfoTag2.m_128403_("UUID")) {
                UUID uuid = this.leashInfoTag2.m_128342_("UUID");
                Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
                if (entity != null) {
                    this.m_21463_(entity, true);
                    return;
                }
            } else if (this.leashInfoTag2.m_128425_("X", 99) && this.leashInfoTag2.m_128425_("Y", 99) && this.leashInfoTag2.m_128425_("Z", 99)) {
                BlockPos blockpos = new BlockPos(this.leashInfoTag2.m_128451_("X"), this.leashInfoTag2.m_128451_("Y"), this.leashInfoTag2.m_128451_("Z"));
                this.m_21463_((Entity)LeashFenceKnotEntity.m_31844_((Level)this.m_9236_(), (BlockPos)blockpos), true);
                return;
            }
            if (this.f_19797_ > 100) {
                this.m_19998_((ItemLike)Items.f_42655_);
                this.leashInfoTag2 = null;
            }
        }
    }

    public void m_30586_(@javax.annotation.Nullable UUID id) {
        this.f_19804_.m_135381_(OWNER_ID, Optional.ofNullable(id));
        if (id == null) {
            this.f_19804_.m_135381_(OWNER_NAME, (Object)"");
        } else {
            Player player = this.m_9236_().m_46003_(id);
            if (player != null) {
                this.f_19804_.m_135381_(OWNER_NAME, (Object)player.m_36316_().getName());
            }
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_ID)).orElse(null);
    }

    public Optional<Player> getPlayerOwner() {
        if (this.m_21805_() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.m_9236_().m_46003_(this.m_21805_()));
    }

    public boolean m_30616_() {
        int timer = (Integer)this.m_20088_().m_135370_(JUMP_ANIM_TIMER);
        return this.jumpHeight != 0.0 || timer > 0;
    }

    public boolean canPlayerMount(Player player) {
        DamageSource lastDamage = this.m_21225_();
        if (this.m_30622_() && lastDamage != null && !lastDamage.m_269533_(DamageTypeTags.f_268745_) && !lastDamage.m_269533_(DamageTypeTags.f_268581_)) {
            return false;
        }
        if (!this.m_30614_()) {
            return true;
        }
        ItemStack item = player.m_21205_();
        if (BREEDING_ITEMS.test(item)) {
            return false;
        }
        if (this.m_9236_().m_5776_()) {
            return true;
        }
        return this.canAccessHorse(player);
    }

    public boolean canAccessHorse(Player player) {
        boolean flag;
        if (player != null && Keys.hasPermission(player, PermissionNodes.CAN_ACCESS)) {
            flag = true;
        } else if (player != null && player.m_20148_().equals(this.m_21805_())) {
            flag = true;
        } else {
            flag = switch (this.getPermissionState()) {
                default -> throw new IncompatibleClassChangeError();
                case RidingPermission.NONE -> false;
                case RidingPermission.TRUST -> {
                    if (player != null && this.isAllowedUUID(player.m_20148_())) {
                        yield true;
                    }
                    yield false;
                }
                case RidingPermission.ALL -> true;
            };
        }
        return EventFactory.accessHorseCheck(this, player, flag);
    }

    @Override
    public boolean canReceiveTack(Player player) {
        return this.m_6084_() && !this.m_6162_() && this.m_30614_() && this.canAccessHorse(player);
    }

    @Deprecated
    public void m_5853_(@Nullable SoundSource pSource) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Direction direction = this.m_6350_();
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42450_);
        DefaultDispenseItemBehavior.m_123378_((Level)this.m_9236_(), (ItemStack)itemstack, (int)6, (Direction)direction, (Position)this.m_20182_());
    }

    @Override
    public boolean equipTack(@javax.annotation.Nullable SoundSource soundSource, ItemStack tackStack, Player player) {
        boolean isSneaking;
        ItemStack stack = tackStack.m_41777_();
        stack.m_41764_(1);
        boolean bl = isSneaking = player != null && player.m_6144_();
        if (TackType.SADDLE_BAG.is(stack)) {
            CompoundTag nbt;
            if (this.hasSaddleBag() && !isSneaking) {
                return false;
            }
            if (isSneaking) {
                player.m_150109_().m_150079_(this.f_30520_.m_8020_(6));
            }
            if ((nbt = stack.m_41784_()).m_128441_("items")) {
                CompoundTag items = nbt.m_128469_("items");
                for (int i = 0; i < this.getSaddlebagInventory().m_6643_(); ++i) {
                    this.getSaddlebagInventory().m_6836_(i, ItemStack.m_41712_((CompoundTag)items.m_128469_(Integer.toString(i))));
                }
            }
            this.insertAndSyncItem(7, stack);
            if (soundSource != null) {
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12034_, soundSource, 0.5f, 1.0f);
            }
        }
        return true;
    }

    public void insertAndSyncItem(int slot, ItemStack stackToInsert) {
        this.f_30520_.m_6836_(slot, stackToInsert);
        if (!this.m_9236_().m_5776_()) {
            SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> this), new ClientboundHorseInventoryPacket(this.m_19879_(), (byte)slot, stackToInsert));
        }
    }

    public void m_7564_() {
        if (!this.m_30622_()) {
            this.m_30665_(true);
            this.disobey();
            SoundEvent soundevent = this.m_7871_();
            if (soundevent != null) {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            }
        }
    }

    public double m_6048_() {
        double def = (double)super.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.75;
        return def += 0.3;
    }

    protected void m_19956_(Entity pEntity, Entity.MoveFunction pCallback) {
        if (!this.m_20363_(pEntity)) {
            return;
        }
        float xzOffset = -0.05f;
        if (this.m_20197_().size() > 1) {
            int i = this.m_20197_().indexOf(pEntity);
            xzOffset = i == 0 ? xzOffset : -0.7f;
        } else if (this.m_20197_().size() > 0 && !(this.m_20197_().get(0) instanceof Player)) {
            xzOffset = -0.5f;
        }
        double yOffset = pEntity.m_6049_() + this.m_6048_();
        if (pEntity instanceof Player) {
            yOffset += 0.1;
            if (this.isFlying()) {
                yOffset += 0.25;
            }
        }
        Vec3 vec3 = new Vec3((double)xzOffset, 0.0, 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180) - 1.5707964f);
        pCallback.m_20372_(pEntity, this.m_20185_() + vec3.f_82479_, this.m_20186_() + yOffset, this.m_20189_() + vec3.f_82481_);
        this.applyYaw(pEntity);
        if (pEntity instanceof Animal) {
            int degrees = pEntity.m_19879_() % 2 == 0 ? 90 : 270;
            pEntity.m_5618_(((Animal)pEntity).f_20883_ + (float)degrees);
            pEntity.m_5616_(pEntity.m_6080_() + (float)degrees);
        }
        if (SWEMUtil.hasTankControls(pEntity)) {
            this.clampRotation(pEntity);
        }
    }

    public void m_7340_(Entity pEntity) {
        if (SWEMUtil.hasTankControls(pEntity)) {
            this.clampRotation(pEntity);
        }
    }

    private void applyYaw(Entity entity) {
        if (!(entity instanceof Player)) {
            entity.m_5618_(this.f_20883_);
            entity.m_146922_(this.f_20883_);
            entity.m_5616_(this.f_20883_);
        }
    }

    protected void clampRotation(Entity pEntityToUpdate) {
        pEntityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(pEntityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-125.0f, (float)125.0f);
        pEntityToUpdate.f_19859_ += f1 - f;
        pEntityToUpdate.m_146922_(pEntityToUpdate.m_146908_() + f1 - f);
        pEntityToUpdate.m_5616_(pEntityToUpdate.m_146908_());
    }

    protected boolean m_7310_(Entity passenger) {
        if (!passenger.m_6095_().m_20674_().m_21609_() && passenger.m_6095_() != EntityType.f_20532_) {
            return false;
        }
        if (passenger instanceof WaterAnimal) {
            return false;
        }
        return this.m_20197_().size() < 2;
    }

    public int m_6056_() {
        return 2;
    }

    protected void m_6835_(Player player) {
        this.m_30661_(false);
        this.m_30665_(false);
        if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_() - 0.2f);
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    private void setGallopCooldown() {
        int gallopSoundCounter = (Integer)this.f_19804_.m_135370_(GALLOP_TIMER);
        int cooldown = gallopSoundCounter * 5;
        this.f_19804_.m_135381_(GALLOP_COOLDOWN_TIMER, (Object)cooldown);
        this.f_19804_.m_135381_(GALLOP_ON_COOLDOWN, (Object)true);
        this.f_19804_.m_135381_(GALLOP_TIMER, (Object)0);
    }

    public void resetGallopCooldown() {
        this.f_19804_.m_135381_(GALLOP_COOLDOWN_TIMER, (Object)0);
        this.f_19804_.m_135381_(GALLOP_ON_COOLDOWN, (Object)false);
        this.f_19804_.m_135381_(GALLOP_TIMER, (Object)0);
    }

    @Override
    public boolean hasSaddle() {
        return !this.getSaddle().m_41619_();
    }

    @Override
    public boolean hasAdventureSaddle() {
        return this.hasSaddle() && TackItem.as(this.getSaddle()).getData().canWearArmor();
    }

    @Override
    public boolean hasBlanket() {
        return !this.getBlanket().m_41619_();
    }

    @Override
    public boolean hasBreastCollar() {
        return !this.getBreastCollar().m_41619_();
    }

    @Override
    public boolean hasHalter() {
        if (!((Boolean)ServerConfig.EQUIP_BRIDLE_REQUIRED.get()).booleanValue()) {
            return true;
        }
        return !this.getHalter().m_41619_();
    }

    @Override
    public boolean hasGirthStrap() {
        return !this.getGirthStrap().m_41619_();
    }

    @Override
    public boolean hasLegWraps() {
        return !this.getLegWraps().m_41619_();
    }

    public ItemStack getSaddle() {
        return this.f_30520_.m_8020_(2);
    }

    protected void createSaddlebagInventory() {
        SimpleContainer inventory = this.saddlebagInventory;
        this.saddlebagInventory = new SimpleContainer(this.getSaddlebagInventorySize());
        if (inventory != null) {
            inventory.m_19181_((ContainerListener)this);
            int i = Math.min(inventory.m_6643_(), this.saddlebagInventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.saddlebagInventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.saddlebagInventory.m_19164_((ContainerListener)this);
        this.saddlebagItemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.saddlebagInventory));
    }

    public SimpleContainer getSaddlebagInventory() {
        return this.saddlebagInventory;
    }

    protected int getSaddlebagInventorySize() {
        return 31;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.f_30520_.m_8020_(0).m_41619_()) {
            compound.m_128365_("BridleItem", (Tag)this.f_30520_.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            compound.m_128365_("BlanketItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(2).m_41619_()) {
            compound.m_128365_("SaddleItem", (Tag)this.f_30520_.m_8020_(2).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(3).m_41619_()) {
            compound.m_128365_("BreastCollarItem", (Tag)this.f_30520_.m_8020_(3).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(4).m_41619_()) {
            compound.m_128365_("LegWrapsItem", (Tag)this.f_30520_.m_8020_(4).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(5).m_41619_()) {
            compound.m_128365_("GirthStrapItem", (Tag)this.f_30520_.m_8020_(5).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(6).m_41619_()) {
            compound.m_128365_("SWEMArmorItem", (Tag)this.f_30520_.m_8020_(6).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(7).m_41619_()) {
            compound.m_128365_("SaddlebagItem", (Tag)this.f_30520_.m_8020_(7).m_41739_(new CompoundTag()));
        }
        if (this.leashHolder2 != null) {
            CompoundTag compoundnbt2 = new CompoundTag();
            if (this.leashHolder2 instanceof LivingEntity) {
                UUID uuid = this.leashHolder2.m_20148_();
                compoundnbt2.m_128362_("UUID", uuid);
            } else if (this.leashHolder2 instanceof HangingEntity) {
                BlockPos blockpos = ((HangingEntity)this.leashHolder2).m_31748_();
                compoundnbt2.m_128405_("X", blockpos.m_123341_());
                compoundnbt2.m_128405_("Y", blockpos.m_123342_());
                compoundnbt2.m_128405_("Z", blockpos.m_123343_());
            }
            compound.m_128365_("Leash2", (Tag)compoundnbt2);
        } else if (this.leashInfoTag2 != null) {
            compound.m_128365_("Leash2", (Tag)this.leashInfoTag2.m_6426_());
        }
        this.writeSaddlebagInventory(compound);
        this.progressionManager.write(compound);
        compound.m_128365_("Needs", (Tag)this.getNeeds().write(new CompoundTag()));
        compound.m_128359_("ownerName", this.getOwnerName());
        CompoundTag allowedList = new CompoundTag();
        for (int i = 0; i < this.allowedList.size(); ++i) {
            allowedList.m_128362_(Integer.toString(i), this.allowedList.get(i));
        }
        compound.m_128365_("allowedList", (Tag)allowedList);
        compound.m_128344_("permissionState", ((Byte)this.f_19804_.m_135370_(RIDING_PERMISSION_DATA)).byteValue());
        compound.m_128379_("tracked", ((Boolean)this.f_19804_.m_135370_(TRACKED)).booleanValue());
        compound.m_128379_("toggleIce", this.isIceEffectActive);
        ListTag specialFeeds = new ListTag();
        this.eatenSpecialFeeds.forEach(feed -> specialFeeds.add((Object)StringTag.m_129297_((String)feed.toString())));
        compound.m_128365_("SpecialFeeds", (Tag)specialFeeds);
        compound.m_128379_("IsBridleLeashed", this.isBridleLeashed());
        ((Optional)this.m_20088_().m_135370_(HOME)).ifPresent(home -> {
            CompoundTag homeTag = new CompoundTag();
            homeTag.m_128359_("Dimension", home.m_122640_().m_135782_().toString());
            homeTag.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)home.m_122646_()));
            compound.m_128365_("Home", (Tag)homeTag);
        });
        this.behaviorManager.save(compound);
        if (this.horseData != null) {
            this.horseData.updateDataFromHorse(this);
        }
    }

    public void m_7378_(CompoundTag compound) {
        ItemStack itemstack;
        super.m_7378_(compound);
        if (compound.m_128425_("Tags", 9)) {
            ListTag tags = compound.m_128437_("Tags", 8);
            for (Tag tag : tags) {
                if (tag.m_6458_() != TagTypes.m_129397_((int)8) || !"custom_mob1".equals(tag.m_7916_())) continue;
                this.getCoatBehavior().set(CoatManager.randomLapisCoat());
                this.getBreeding().setFemale(this.f_19796_.m_188499_());
            }
            compound.m_128473_("Tags");
        }
        if (compound.m_128425_("BridleItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("BridleItem"))).m_41619_() && (TackType.HALTER.is(itemstack) || TackType.BRIDLE.is(itemstack))) {
            this.f_30520_.m_6836_(0, itemstack);
        }
        if (compound.m_128425_("BlanketItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("BlanketItem"))).m_41619_() && this.isBlanket(itemstack)) {
            this.f_30520_.m_6836_(1, itemstack);
        }
        if (compound.m_128425_("SaddleItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SaddleItem"))).m_41619_() && this.isSaddle(itemstack)) {
            this.f_30520_.m_6836_(2, itemstack);
        }
        if (compound.m_128425_("BreastCollarItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("BreastCollarItem"))).m_41619_() && this.isBreastCollar(itemstack)) {
            this.f_30520_.m_6836_(3, itemstack);
        }
        if (compound.m_128425_("LegWrapsItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("LegWrapsItem"))).m_41619_() && this.isLegWraps(itemstack)) {
            this.f_30520_.m_6836_(4, itemstack);
        }
        if (compound.m_128425_("GirthStrapItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("GirthStrapItem"))).m_41619_() && this.isGirthStrap(itemstack)) {
            this.f_30520_.m_6836_(5, itemstack);
        }
        if (compound.m_128425_("SWEMArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SWEMArmorItem"))).m_41619_()) {
            this.f_30520_.m_6836_(6, itemstack);
        }
        if (compound.m_128425_("SaddlebagItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SaddlebagItem"))).m_41619_() && this.isSaddleBag(itemstack)) {
            this.f_30520_.m_6836_(7, itemstack);
        }
        if (compound.m_128425_("Leash2", 10)) {
            this.leashInfoTag2 = compound.m_128469_("Leash2");
        }
        this.readSaddlebagInventory(compound);
        this.progressionManager.read(compound);
        if (compound.m_128441_("Needs")) {
            this.getNeeds().read(compound.m_128469_("Needs"));
        }
        this.m_7493_();
        if (compound.m_128441_("HorseVariant")) {
            int legacyId = compound.m_128451_("HorseVariant");
            HorseCoat coat = BaseCoats.getLegacy(legacyId);
            this.getCoatBehavior().set(coat);
            ModRef.LOGGER.debug("Found legacy coat {}. Converting to {}", (Object)legacyId, (Object)coat.id());
        }
        this.setOwnerName(compound.m_128461_("ownerName"));
        if (compound.m_128441_("allowedList")) {
            CompoundTag allowList = compound.m_128469_("allowedList");
            for (int i = 0; i < allowList.m_128440_(); ++i) {
                this.addAllowedUUID(allowList.m_128342_(Integer.toString(i)));
            }
        }
        if (compound.m_128441_("permissionState")) {
            this.m_20088_().m_135381_(RIDING_PERMISSION_DATA, (Object)compound.m_128445_("permissionState"));
        }
        if (compound.m_128441_("tracked")) {
            this.setTracked(compound.m_128471_("tracked"));
        }
        if (compound.m_128441_("toggleIce")) {
            this.isIceEffectActive = compound.m_128471_("toggleIce");
        }
        if (compound.m_128441_("SpecialFeeds")) {
            this.eatenSpecialFeeds.clear();
            compound.m_128437_("SpecialFeeds", 8).forEach(baseTag -> this.eatenSpecialFeeds.add(new ResourceLocation(baseTag.m_7916_())));
        }
        if (compound.m_128441_("IsBridleLeashed")) {
            this.setBridleLeashed(compound.m_128471_("IsBridleLeashed"));
        }
        if (compound.m_128441_("Home")) {
            CompoundTag homeTag = compound.m_128469_("Home");
            ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(homeTag.m_128461_("Dimension")));
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)homeTag.m_128469_("Pos"));
            this.m_20088_().m_135381_(HOME, Optional.of(GlobalPos.m_122643_((ResourceKey)levelKey, (BlockPos)pos)));
        }
        this.behaviorManager.deserialize(compound);
        if (CommonEventHandler.getHorseDataManager() != null) {
            this.horseData = CommonEventHandler.getHorseDataManager().getOrCreateHorseData(this);
        }
    }

    public CoatBehavior getCoatBehavior() {
        return this.getBehavior(CoatBehavior.class);
    }

    public void addAllowedUUID(UUID playerUUID) {
        if (!this.allowedList.contains(playerUUID)) {
            this.allowedList.add(playerUUID);
        }
    }

    public boolean isAllowedUUID(UUID playerUUID) {
        return this.allowedList.contains(playerUUID);
    }

    public void removeAllowedUUID(UUID playerUUID) {
        if (this.m_21805_() != null && this.m_21805_().equals(playerUUID)) {
            return;
        }
        this.allowedList.remove(playerUUID);
    }

    public void transferHorse(Player player) {
        this.transferHorse(player.m_36316_());
    }

    public void transferHorse(GameProfile profile) {
        this.tameWithName(profile);
        this.removeAllAllowedUUIDs();
    }

    public boolean tameWithName(GameProfile profile) {
        Player player;
        this.m_30586_(profile.getId());
        this.f_19804_.m_135381_(OWNER_NAME, (Object)profile.getName());
        this.m_30651_(true);
        this.m_9236_().m_7605_((Entity)this, (byte)7);
        this.getBehavior(PoopBehavior.class).resetTime();
        if (!this.m_9236_().m_5776_()) {
            CommonEventHandler.getHorseDataManager().save(this.m_9236_().m_7654_());
        }
        if ((player = this.m_9236_().m_46003_(profile.getId())) instanceof ServerPlayer) {
            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
        }
        return true;
    }

    public void removeAllAllowedUUIDs() {
        for (UUID allowed : this.allowedList) {
            this.removeAllowedUUID(allowed);
        }
    }

    public boolean m_6094_() {
        return super.m_6094_();
    }

    private void writeSaddlebagInventory(CompoundTag compound) {
        if (!this.saddlebagInventory.m_7983_()) {
            CompoundTag saddlebag = new CompoundTag();
            for (int i = 0; i < this.saddlebagInventory.m_6643_(); ++i) {
                saddlebag.m_128365_(Integer.toString(i), (Tag)this.saddlebagInventory.m_8020_(i).m_41739_(new CompoundTag()));
            }
            compound.m_128365_("saddlebag", (Tag)saddlebag);
        }
    }

    private void readSaddlebagInventory(CompoundTag compound) {
        if (compound.m_128441_("saddlebag")) {
            CompoundTag saddlebag = compound.m_128469_("saddlebag");
            for (int i = 0; i < this.saddlebagInventory.m_6643_(); ++i) {
                CompoundTag stackNBT;
                if (!saddlebag.m_128441_(Integer.toString(i)) || (stackNBT = (CompoundTag)saddlebag.m_128423_(Integer.toString(i))) == null) continue;
                this.saddlebagInventory.m_6836_(i, ItemStack.m_41712_((CompoundTag)stackNBT));
            }
        }
    }

    public void calculatePotionCoat(Variant vanillaVariant) {
        HorseColor color = HorseColor.fromVanillaVariant(vanillaVariant);
        this.getCoatBehavior().set(CoatManager.adult(color));
    }

    public void m_30651_(boolean tamed) {
        super.m_30651_(tamed);
        this.progressionManager.getAffinityLeveling().addXP(100.0f);
    }

    private void updateArmorProtection() {
        if (!this.m_9236_().f_46443_) {
            AttributeInstance armorAttribute = this.m_21051_(Attributes.f_22284_);
            if (armorAttribute == null) {
                return;
            }
            armorAttribute.m_22120_(ARMOR_MODIFIER_UUID);
            int i = this.getArmorTier().getProtection();
            if (i != 0) {
                armorAttribute.m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void m_5844_() {
        this.m_20282_(this.isInFluidType((fluidType, height) -> height >= 0.89));
    }

    @Nullable
    protected PortalInfo m_7937_(ServerLevel pDestination) {
        GlobalPos home;
        if (this.m_9236_().m_46472_() == Level.f_46430_ && pDestination.m_46472_() == Level.f_46428_ && (home = this.getHome()) != null && home.m_122640_() == pDestination.m_46472_()) {
            return new PortalInfo(home.m_122646_().m_252807_(), Vec3.f_82478_, this.m_146908_(), this.m_146909_());
        }
        return super.m_7937_(pDestination);
    }

    public void m_8119_() {
        if (this.f_30519_) {
            ++this.jumpTimer;
        }
        if (this.jumpTimer >= 2 && (this.m_20096_() || this.m_6069_())) {
            this.f_30522_ = 0.0f;
            this.stopJump();
        }
        if (!this.m_9236_().m_5776_() && this.m_20186_() < (double)this.m_9236_().m_141937_()) {
            float distPerc = Mth.m_14154_((float)((float)(this.m_20186_() - (double)this.m_9236_().m_141937_()) / 60.0f));
            if ((double)this.f_19796_.m_188501_() < 0.4 + (double)(distPerc / 2.0f)) {
                if ((double)distPerc <= 0.5) {
                    this.emitEchParticles((ServerLevel)this.m_9236_(), Mth.m_269140_((float)distPerc, (int)1, (int)3));
                } else {
                    this.emitBadParticles((ServerLevel)this.m_9236_(), Mth.m_269140_((float)distPerc, (int)1, (int)3));
                }
            }
        }
        if (this.m_20186_() < (double)(this.m_9236_().m_141937_() - 60)) {
            GlobalPos home = this.getHome();
            BlockPos pos = home.m_122646_();
            ImmutableList passengers = ImmutableList.copyOf((Collection)this.m_20197_());
            this.m_19877_();
            if (!this.m_9236_().m_5776_()) {
                ServerLevel targetDimension = this.m_9236_().m_7654_().m_129880_(home.m_122640_());
                this.m_264318_(targetDimension, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, Collections.emptySet(), this.m_146909_(), this.m_146908_());
                this.progressionManager.getAffinityLeveling().removeXp(35.0f);
                if (((Boolean)ServerConfig.VOID_TP.get()).booleanValue()) {
                    passengers.forEach(entity -> entity.m_264318_(targetDimension, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, Collections.emptySet(), entity.m_146909_(), entity.m_146908_()));
                }
            }
        }
        if (!this.m_9236_().m_5776_()) {
            ItemStack armor;
            if (this.f_19797_ % 5 == 0) {
                int rand;
                if (this.m_20160_()) {
                    int x = this.m_20183_().m_123341_();
                    int z = this.m_20183_().m_123343_();
                    if (x != this.lastBlockPosition.m_123341_() || z != this.lastBlockPosition.m_123343_()) {
                        x = Math.abs(x - this.lastBlockPosition.m_123341_());
                        z = Math.abs(z - this.lastBlockPosition.m_123343_());
                        int dist = (int)Math.sqrt(x * x + z * z);
                        this.awardIntegerStat(BLOCKS_TRAVELLED_STAT, dist);
                        if (dist > 0 && dist < 25) {
                            boolean speedLevelUp = this.progressionManager.getSpeedLeveling().addXP((float)dist * this.getGait().getSkillMultiplier());
                            if (speedLevelUp) {
                                this.levelUpSpeed();
                            }
                            this.progressionManager.getAffinityLeveling().addXP((float)dist * this.getGait().getSkillMultiplier());
                        }
                    }
                }
                if (this.hasSaddle() && !this.hasGirthStrap() && ((Boolean)ServerConfig.EQUIP_GIRTH_STRAP_REQUIRED.get()).booleanValue() && this.m_20160_() && this.f_19797_ % 20 == 0 && (rand = this.m_217043_().m_188503_(5)) == 0) {
                    Entity rider = (Entity)this.m_20197_().get(0);
                    rider.m_8127_();
                    ItemStack saddle = this.getSaddle();
                    this.f_30520_.m_6836_(2, ItemStack.f_41583_);
                    this.setSWEMSaddled();
                    this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), saddle));
                }
                this.lastBlockPosition = this.m_20183_();
            }
            if (this.m_6109_() && this.m_20160_()) {
                this.stillTimer = this.m_20183_().equals((Object)this.lastBlockPosition) ? ++this.stillTimer : 0;
            }
            if (!(armor = this.getArmorOrPastureBlanket()).m_41619_()) {
                this.tickArmorTier(armor, this.getArmorTier());
            }
            if (this.canFly() && this.jumpHeight == 0.0 && (double)this.f_19789_ > 0.5) {
                this.f_19804_.m_135381_(FLUTTER, (Object)true);
            }
            this.f_19804_.m_135381_(IS_SAD, (Object)(this.m_21223_() <= 10.0f ? 1 : 0));
            if (this.m_20096_() || this.m_6069_()) {
                this.f_19804_.m_135381_(FLUTTER, (Object)false);
                if (this.isFalling) {
                    this.isFalling = false;
                }
            }
        } else if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20202_() != null && Minecraft.m_91087_().f_91074_.m_20202_().m_20148_().equals(this.m_20148_())) {
            if (KeyBindSetup.CAMERA_LOCK.m_90857_() && this.isCameraLocked() && this.m_20197_().get(0) == Minecraft.m_91087_().f_91074_) {
                SWEMPackets.sendToServer(new CCameraLockPacket(this.m_20148_(), false));
                this.setLockedRotations(this.m_146909_(), this.m_146908_());
            } else if (!KeyBindSetup.CAMERA_LOCK.m_90857_() && !this.isCameraLocked() && this.m_20197_().get(0) == Minecraft.m_91087_().f_91074_) {
                SWEMPackets.sendToServer(new CCameraLockPacket(this.m_20148_(), true));
            }
        }
        super.m_8119_();
        if ((this.m_20069_() || this.isInFluidType(Fluids.f_76195_.getFluidType())) && !this.m_20160_() && (this.f_19800_ || this.isEyeInFluidType(Fluids.f_76195_.getFluidType()))) {
            this.m_20334_(this.m_20184_().f_82479_, 0.02, this.m_20184_().f_82481_);
        }
    }

    private void tickArmorTier(ItemStack armor, HorseArmorTier tier) {
        if (tier.is(HorseArmorTier.LEATHER)) {
            this.tickLeatherArmor(armor);
        }
        if (tier.is(HorseArmorTier.CLOTH)) {
            this.tickClothArmor(armor);
        }
        if (tier.is(HorseArmorTier.COPPER)) {
            this.tickCopperArmor(armor);
        }
        if (tier.is(HorseArmorTier.IRON)) {
            this.tickIronArmor(armor);
        }
        if (tier.is(HorseArmorTier.GOLD)) {
            this.tickGoldArmor(armor);
        }
        if (tier.is(HorseArmorTier.DIAMOND)) {
            this.tickDiamondArmor(armor);
        }
        if (tier.is(HorseArmorTier.AMETHYST)) {
            this.tickAmethystArmor(armor);
        }
    }

    private void tickClothArmor(ItemStack armor) {
    }

    private void tickLeatherArmor(ItemStack armor) {
    }

    private void tickCopperArmor(ItemStack armor) {
        if (this.m_21223_() < 6.0f && !this.m_21023_(MobEffects.f_19605_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 50, 0, true, false, false));
        }
    }

    private void tickIronArmor(ItemStack armor) {
        if (this.m_21023_(MobEffects.f_19620_)) {
            this.m_21195_(MobEffects.f_19620_);
        }
        if (!this.m_21023_(MobEffects.f_19606_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 1, true, false, false));
        }
    }

    private void tickGoldArmor(ItemStack armor) {
        if (!TackType.HORSE_ARMOR.is(armor) || !this.m_20096_() || !this.isIceEffectActive || this.m_9236_().m_5776_()) {
            return;
        }
        BlockState frostedIceState = Blocks.f_50449_.m_49966_();
        int range = Math.min(16, 3);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos horsePos = this.m_20183_();
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)horsePos.m_7918_(-range, -1, -range), (BlockPos)horsePos.m_7918_(range, -1, range))) {
            boolean isFull;
            if (!blockPos.m_123314_((Vec3i)this.m_20183_(), (double)range)) continue;
            mutablePos.m_122178_(blockPos.m_123341_(), blockPos.m_123342_() + 1, blockPos.m_123343_());
            BlockState stateAbove = this.m_9236_().m_8055_((BlockPos)mutablePos);
            if (!stateAbove.m_60795_()) continue;
            BlockState state = this.m_9236_().m_8055_(blockPos);
            FluidState fluid = state.m_60819_();
            boolean bl = isFull = state.m_60734_() == Blocks.f_49990_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (!fluid.m_192917_((Fluid)Fluids.f_76193_) || !isFull || !frostedIceState.m_60710_((LevelReader)this.m_9236_(), blockPos) || !this.m_9236_().m_45752_(frostedIceState, blockPos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)this, (BlockSnapshot)BlockSnapshot.create((ResourceKey)this.m_9236_().m_46472_(), (LevelAccessor)this.m_9236_(), (BlockPos)blockPos), (Direction)Direction.UP)) continue;
            this.m_9236_().m_7731_(blockPos, frostedIceState, 3);
            this.m_9236_().m_186460_(blockPos, Blocks.f_50449_, 20);
        }
    }

    private void tickDiamondArmor(ItemStack armor) {
        this.m_20095_();
        if (!TackType.HORSE_ARMOR.is(armor) || !this.m_20096_() || this.m_9236_().m_5776_()) {
            return;
        }
        BlockState tearingMagma = ((Block)BlockSetup.TEARING_MAGMA.get()).m_49966_();
        int f = Math.min(16, 3);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos horsePos = this.m_20183_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)horsePos.m_7918_(-f, -1, -f), (BlockPos)horsePos.m_7918_(f, -1, f))) {
            boolean isFull;
            if (!pos.m_123314_((Vec3i)this.m_20183_(), (double)f)) continue;
            mutablePos.m_122178_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            BlockState stateAbove = this.m_9236_().m_8055_((BlockPos)mutablePos);
            if (!stateAbove.m_60795_()) continue;
            BlockState state = this.m_9236_().m_8055_(pos);
            FluidState fluid = state.m_60819_();
            boolean bl = isFull = state.m_60734_() == Blocks.f_49991_ && (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (!fluid.m_192917_((Fluid)Fluids.f_76195_) || !isFull || !tearingMagma.m_60710_((LevelReader)this.m_9236_(), pos) || !this.m_9236_().m_45752_(tearingMagma, pos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)this, (BlockSnapshot)BlockSnapshot.create((ResourceKey)this.m_9236_().m_46472_(), (LevelAccessor)this.m_9236_(), (BlockPos)pos), (Direction)Direction.UP)) continue;
            this.m_9236_().m_7731_(pos, tearingMagma, 3);
            this.m_9236_().m_186460_(pos, (Block)BlockSetup.TEARING_MAGMA.get(), 20);
        }
    }

    private void tickNetheriteArmor() {
    }

    private void tickAmethystArmor(ItemStack armor) {
        if (this.f_19789_ > 3.0f) {
            this.isFalling = true;
        }
        if (this.isFalling) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 2, 0, false, false, false));
        }
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.f_30519_) {
            return super.m_6972_(pPose);
        }
        return super.m_6972_(pPose);
    }

    protected boolean m_6129_() {
        return this.m_6069_();
    }

    public boolean isFlying() {
        return this.getBehavior(FlightBehavior.class).isFlying();
    }

    public boolean startFlying() {
        FlightBehavior flight = this.getBehavior(FlightBehavior.class);
        if (!this.canFly()) {
            this.getControllingPlayer().m_5661_((Component)Component.m_237113_((String)"The horse must wear Amethyst Horse Armor and Adventure Saddle"), true);
            return false;
        }
        if (this.isInFluidType()) {
            this.getControllingPlayer().m_5661_((Component)Component.m_237113_((String)"The horse must be on land"), true);
            return false;
        }
        if (flight.isFlying()) {
            flight.stopFlight(false);
            return true;
        }
        if (((Boolean)this.m_20088_().m_135370_(FLUTTER)).booleanValue()) {
            flight.startFlight(this.m_20184_());
        } else if (this.m_20096_()) {
            flight.launch(this.m_20184_());
        }
        return true;
    }

    protected Vec2 m_274391_(LivingEntity pEntity) {
        FlightBehavior flight = this.getBehavior(FlightBehavior.class);
        if (flight.isFlying()) {
            return flight.getRiddenRotation(pEntity);
        }
        if (!this.isCameraLocked()) {
            this.m_146922_(this.lockedYRot);
            this.f_19859_ = this.m_146908_();
            this.m_146926_(this.lockedXRot * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            return new Vec2(this.lockedXRot * 0.5f, this.lockedYRot);
        }
        if (this.m_6109_()) {
            if (SWEMUtil.hasTankControls((Entity)pEntity)) {
                float movement = pEntity.f_20902_;
                float sideways = pEntity.f_20900_;
                float rotationAmplifier = 4.0f * Math.signum(sideways);
                return new Vec2(this.m_146909_(), this.m_146908_() - rotationAmplifier);
            }
            return super.m_274391_(pEntity);
        }
        return new Vec2(this.m_146909_() * 0.5f, this.m_146908_());
    }

    protected float m_245547_(Player pPlayer) {
        return super.m_245547_(pPlayer);
    }

    protected Vec3 m_274312_(Player pPlayer, Vec3 pTravelVector) {
        if (!this.canMove()) {
            this.f_30522_ = 0.0f;
            return Vec3.f_82478_;
        }
        if (!this.hasSaddle()) {
            return Vec3.f_82478_;
        }
        if (this.m_6109_()) {
            FlightBehavior flight = this.getBehavior(FlightBehavior.class);
            if (KeyBindSetup.TOGGLE_FLIGHT.m_90859_() && this.startFlying()) {
                SWEMPackets.sendToServer(new ServerBoundSetFlightPacket(true));
            }
            if (flight.isLaunchingOrFlying()) {
                this.f_30522_ = 0.0f;
                return flight.getRiddenInput(pPlayer, pTravelVector);
            }
            float sidewaysMovement = pPlayer.f_20900_ * 0.5f;
            float forwardMovement = pPlayer.f_20902_;
            if (forwardMovement <= 0.0f) {
                this.f_30524_ = 0;
            }
            if (SWEMUtil.hasTankControls((Entity)pPlayer)) {
                sidewaysMovement = 0.0f;
            }
            this.updateMovementVariables(sidewaysMovement, forwardMovement);
            if (this.m_20096_() && this.f_30522_ == 0.0f && this.m_30622_() && !this.f_30510_) {
                sidewaysMovement = 0.0f;
                forwardMovement = 0.0f;
            }
            if (forwardMovement < 0.0f) {
                pPlayer.f_20902_ *= 3.0f;
                if (!this.isWalkingBackwards) {
                    SWEMPackets.sendToServer(new ServerboundHorseAnimationPacket(this.m_19879_(), 3));
                }
            } else if (this.isWalkingBackwards) {
                SWEMPackets.sendToServer(new ServerboundHorseAnimationPacket(this.m_19879_(), 4));
            }
            return new Vec3((double)sidewaysMovement, pTravelVector.f_82480_, (double)forwardMovement);
        }
        return super.m_274312_(pPlayer, pTravelVector);
    }

    protected void m_274498_(Player pPlayer, Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        FlightBehavior flight = this.getBehavior(FlightBehavior.class);
        if (flight.isFlying()) {
            flight.tickRidden(pPlayer, pTravelVector);
            return;
        }
        if (!this.m_9236_().m_5776_() && this.getGait() != Gait.WALK && pTravelVector.m_82553_() < 0.1) {
            this.setGait(Gait.WALK);
        }
        if (this.m_6069_() && this.f_19862_) {
            this.m_20256_(new Vec3(this.m_20184_().f_82479_, 0.05, this.m_20184_().f_82481_));
        } else if ((this.f_19800_ || this.m_204029_(FluidTags.f_13132_)) && !this.f_19862_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -1.9, 1.0));
        }
    }

    protected void m_245980_(float pPlayerJumpPendingScale, Vec3 pTravelVector) {
        double jump = this.m_30626_() * (double)this.f_30522_ * (double)this.m_20098_();
        if (this.getArmorTier() == HorseArmorTier.AMETHYST) {
            jump += 0.15;
        }
        double jumpStrength = this.m_21023_(MobEffects.f_19603_) ? jump + (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f) : jump;
        float jumpHeight = this.jumpHeightFromStrength(jumpStrength);
        if (this.m_217043_().m_188500_() > this.getJumpDisobey(jumpHeight)) {
            Vec3 vector3d = this.m_20184_();
            this.m_20334_(vector3d.f_82479_, jumpStrength, vector3d.f_82481_);
            float xpToAdd = 0.0f;
            if (jumpHeight >= 4.0f) {
                xpToAdd = 40.0f;
            } else if (jumpHeight >= 3.0f) {
                xpToAdd = 30.0f;
            } else if (jumpHeight >= 2.0f) {
                xpToAdd = 25.0f;
            } else if (jumpHeight >= 1.0f) {
                xpToAdd = 20.0f;
            }
            this.jumpHeight = jumpHeight;
            this.startJump(jumpHeight);
            SWEMPackets.sendToServer(new ServerboundHorseXPPacket(this.m_20148_(), xpToAdd, HorseSkill.JUMP));
            this.f_19812_ = true;
            ForgeHooks.onLivingJump((LivingEntity)this);
            if (pTravelVector.f_82481_ > 0.0) {
                float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.f_30522_), 0.0, (double)(0.4f * f3 * this.f_30522_)));
            }
        } else {
            this.disobey();
        }
        this.f_30522_ = 0.0f;
    }

    private float jumpHeightFromStrength(double jumpStrength) {
        return (float)(-0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367);
    }

    private void updateMovementVariables(float sidewaysMovement, float forwardMovement) {
        CSyncMovementIdentifiersPacket.MovementPacketData movementPacketData = new CSyncMovementIdentifiersPacket.MovementPacketData(forwardMovement > 0.0f, forwardMovement < 0.0f, sidewaysMovement > 0.0f, sidewaysMovement < 0.0f);
        SWEMPackets.sendToServer(new CSyncMovementIdentifiersPacket(movementPacketData, this.m_20148_()));
    }

    public boolean isCameraLocked() {
        return (Boolean)this.f_19804_.m_135370_(CAMERA_LOCK);
    }

    public void setCameraLock(boolean locked) {
        this.f_19804_.m_135381_(CAMERA_LOCK, (Object)locked);
        this.setLockedRotations(this.m_146909_(), this.m_146908_());
    }

    public void setLockedRotations(float xRot, float yRot) {
        this.lockedXRot = xRot;
        this.lockedYRot = yRot;
    }

    public void m_19920_(float pAmount, Vec3 pRelative) {
        Vec3 vector3d = SWEMHorseEntityBase.m_20015_((Vec3)pRelative, (float)pAmount, (float)(this.isCameraLocked() ? this.m_146908_() : this.lockedYRot));
        this.m_20256_(this.m_20184_().m_82549_(vector3d));
    }

    public boolean m_20096_() {
        return super.m_20096_();
    }

    public boolean canMove() {
        return !this.m_5803_() && !this.m_30622_() && !this.isKicking() && !this.isBiting() && !this.isStomping();
    }

    public boolean m_7132_() {
        return !this.m_6069_() && !this.getBehavior(FlightBehavior.class).isLaunchingOrFlying() && super.m_7132_();
    }

    public void m_7888_(int pJumpPower) {
        if (this.canMove() && this.m_6254_()) {
            if (pJumpPower < 0) {
                pJumpPower = 0;
            } else {
                this.f_30510_ = true;
            }
            this.f_30522_ = pJumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)pJumpPower / 90.0f;
        }
    }

    public double getJumpDisobey(float jumpHeight) {
        if (this.getArmorTier() == HorseArmorTier.AMETHYST) {
            jumpHeight -= 1.0f;
        }
        return 0.25 * (double)(this.progressionManager.getJumpLeveling().getLevel() + 1 - 5) / 4.0 + 0.05 * (double)(jumpHeight - 1.0f) / 4.0 + 0.7 * (double)this.progressionManager.getAffinityLeveling().getDebuff();
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
        super.m_147240_(pStrength * 0.1, pX, pZ);
    }

    public void m_7199_(int pJumpPower) {
        if (this.canMove()) {
            this.m_7486_();
        }
    }

    private Boolean checkIsInWater() {
        FluidState fluidstate = this.m_9236_().m_6425_(this.m_20183_());
        return fluidstate.m_205070_(FluidTags.f_13131_);
    }

    protected void m_7486_() {
        if (this.checkIsInWater().booleanValue()) {
            this.m_5496_(SoundEvents.f_12277_, 0.3f, 1.0f);
        } else {
            this.m_5496_(SoundEvents.f_11979_, 0.4f, 1.0f);
        }
    }

    public boolean m_142535_(float pFallDistance, float pDamageMultiplier, DamageSource pSource) {
        if (pFallDistance > 1.0f && !this.checkIsInWater().booleanValue()) {
            this.m_5496_(SoundEvents.f_11980_, 0.4f, 1.0f);
        } else if (pFallDistance > 1.0f && this.checkIsInWater().booleanValue()) {
            this.m_5496_(SoundEvents.f_12277_, 0.1f, 1.0f);
        }
        int i = this.m_5639_(pFallDistance, pDamageMultiplier);
        if (i <= 0) {
            return false;
        }
        if (this.m_21023_(MobEffects.f_19591_)) {
            return false;
        }
        this.m_6469_(this.m_269291_().m_268989_(), i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(this.m_269291_().m_268989_(), (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    private void playFlapWingSound() {
    }

    protected void startJump(float jumpHeight) {
        this.f_30519_ = true;
        SWEMPackets.sendToServer(new ServerboundHorseJumpPacket(this.m_19879_(), jumpHeight));
        this.m_6210_();
    }

    private void stopJump() {
        this.f_30519_ = false;
        this.jumpTimer = 0;
        this.m_6210_();
        if (this.m_9236_().m_5776_()) {
            SWEMPackets.sendToServer(new ServerboundHorseJumpPacket(this.m_19879_(), 0.0f));
        }
    }

    public Player getControllingPlayer() {
        LivingEntity controllingEntity = this.m_6688_();
        if (controllingEntity instanceof Player) {
            Player player = (Player)controllingEntity;
            return player;
        }
        return null;
    }

    @javax.annotation.Nullable
    public LivingEntity m_6688_() {
        List<Player> playerEntities = this.m_20197_().stream().filter(entity -> entity instanceof Player).map(Player.class::cast).toList();
        return this.m_20197_().isEmpty() ? null : (playerEntities.isEmpty() ? null : (LivingEntity)playerEntities.get(0));
    }

    private float getDisobedienceFactor() {
        return this.m_217043_().m_188501_();
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268581_) || source.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        if (source.m_269533_(DamageTypeTags.f_268419_)) {
            return true;
        }
        if (source.m_276093_(DamageTypes.f_268428_)) {
            return true;
        }
        HorseArmorTier tier = this.getArmorTier();
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return tier.is(HorseArmorTier.DIAMOND);
        }
        if (source.m_269533_(DamageTypeTags.f_268419_)) {
            return tier.is(HorseArmorTier.LEATHER);
        }
        if (source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268669_)) {
            return tier.is(HorseArmorTier.IRON);
        }
        return super.m_6673_(source);
    }

    public void levelUpJump() {
        AttributeInstance jumpStrength = this.m_21051_(Attributes.f_22288_);
        if (jumpStrength != null) {
            double currJump = jumpStrength.m_22135_();
            double newJump = this.getAlteredJumpStrength();
            jumpStrength.m_22125_(new AttributeModifier(this.progressionManager.getJumpLeveling().getLevelName(), newJump - currJump, AttributeModifier.Operation.ADDITION));
        } else {
            ModRef.LOGGER.error("Jump Strength Attribute is null");
        }
    }

    public void levelUpSpeed() {
        AttributeInstance speedInstance = this.m_21051_(Attributes.f_22279_);
        if (speedInstance != null) {
            speedInstance.m_22100_(this.getAlteredMovementSpeed());
            this.setGait(this.getGait());
        } else {
            ModRef.LOGGER.error("Movement Speed Attribute is null");
        }
    }

    public void levelUpHealth() {
        AttributeInstance healthInstance = this.m_21051_(Attributes.f_22276_);
        if (healthInstance != null) {
            healthInstance.m_22100_(this.getAlteredMaxHealth());
        } else {
            ModRef.LOGGER.error("Max Health Attribute is null");
        }
    }

    public void m_5757_(Container invBasic) {
        this.setSWEMSaddled();
        ItemStack itemstack = this.getArmor();
        super.m_5757_(invBasic);
        ItemStack itemstack1 = this.getArmor();
        if (this.f_19797_ > 20 && this.isSWEMArmor(itemstack1) && itemstack != itemstack1) {
            this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    protected void setSWEMSaddled() {
        if (!this.m_9236_().m_5776_()) {
            this.m_30597_(4, !this.getSaddle().m_41619_());
        }
    }

    protected void m_7493_() {
        this.syncInventory();
        this.updateArmorProtection();
        if (!this.m_9236_().f_46443_) {
            this.m_30597_(4, !this.getSaddle().m_41619_());
        }
    }

    public void syncInventory() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        CompoundTag invTag = this.saveInventory();
        SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> this), new ClientboundHorseSyncInventoryPacket(this.m_19879_(), invTag));
    }

    public void loadInventory(CompoundTag tag) {
        InventoryUtil.loadContainer((Container)this.f_30520_, tag);
    }

    public CompoundTag saveInventory() {
        return InventoryUtil.saveContainer((Container)this.f_30520_);
    }

    protected void m_5877_(SoundType p_190680_1_) {
        ItemStack stack;
        super.m_5877_(p_190680_1_);
        if (this.m_217043_().m_188503_(10) == 0) {
            this.m_5496_(SoundEvents.f_11974_, p_190680_1_.m_56773_() * 0.6f, p_190680_1_.m_56774_());
        }
        if (this.isSWEMArmor(stack = this.f_30520_.m_8020_(1))) {
            stack.onHorseArmorTick(this.m_9236_(), (Mob)this);
        }
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_11976_;
    }

    protected SoundEvent m_7871_() {
        super.m_7871_();
        return SoundEvents.f_11972_;
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        return super.m_7688_(pLivingEntity);
    }

    public void m_213583_(Player playerEntity) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)playerEntity)) && this.m_30614_()) {
            if (!this.canAccessHorse(playerEntity)) {
                return;
            }
            MutableComponent horseDisplayName = Component.m_237113_((String)SWEMUtil.checkTextOverflow(this.m_7755_().getString(), 15));
            MenuProvider provider = new MenuProvider(){
                final /* synthetic */ Component val$horseDisplayName;
                {
                    this.val$horseDisplayName = component;
                }

                public Component m_5446_() {
                    return this.val$horseDisplayName;
                }

                public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
                    return new SWEMHorseInventoryContainer(p_createMenu_1_, p_createMenu_2_, SWEMHorseEntityBase.this.m_19879_());
                }
            };
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), (MenuProvider)provider, buffer -> buffer.writeInt(this.m_19879_()).writeInt(this.m_19879_()));
        }
    }

    public boolean checkIsCoatTransformItem(Player player, ItemStack stack) {
        if (!((Boolean)ServerConfig.ALLOW_SECRET_COATS.get()).booleanValue()) {
            return false;
        }
        if (!this.isOwner(player) && !Keys.hasPermission(player, PermissionNodes.CAN_MODIFY)) {
            return false;
        }
        if (stack.m_41720_() == ItemSetup.WHISTLE.get() && stack.m_41786_().getString().equals("Ocarina")) {
            stack.m_41774_(1);
            player.m_150109_().m_150079_(new ItemStack((ItemLike)ItemSetup.WHISTLE.get()));
            this.getCoatBehavior().set(BaseCoats.EPONA_ZELDA);
            return true;
        }
        if (stack.m_41720_() == Items.f_42749_ && stack.m_41786_().getString().equals("Coin")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.ROACH_WITCHER);
            return true;
        }
        if (stack.m_41720_() == Items.f_41950_ && stack.m_41786_().getString().equals("Mono")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.AGRO_SOC);
            return true;
        }
        if (stack.m_41720_() == Items.f_42383_ && stack.m_41786_().getString().equals("Sithis")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.SHADOWMERE_OBLIVION);
            return true;
        }
        if (stack.m_41720_() == Items.f_42585_ && stack.m_41786_().getString().equals("Ponyta")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.RAPIDASH_POKEMON);
            return true;
        }
        if (stack.m_41720_() == Items.f_42415_ && stack.m_41786_().getString().equals("Honor of Grayskull")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.SWIFT_WIND_SHE_RA);
            return true;
        }
        if (stack.m_41720_() == Items.f_42402_ && stack.m_41786_().getString().equals("Pegasus")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.PEGASUS_ARISHANT);
            return true;
        }
        if (stack.m_41720_() == ItemSetup.ENGLISH_BRIDLE_BLACK.get() && stack.m_41786_().getString().equals("Becky")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.BOB_FREE_REIN);
            return true;
        }
        if (stack.m_41720_() == Items.f_42536_ && stack.m_41786_().getString().equals("Zebra")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.FARCAH_ZORSE_TAN_HAUKET);
            return true;
        }
        if (stack.m_41720_() == Items.f_42535_ && stack.m_41786_().getString().equals("Zebra")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.SARINE_ZORSE_PAINT_HAUKET);
            return true;
        }
        if (stack.m_41720_() == Items.f_42495_ && stack.m_41786_().getString().equals("Zebra")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.CALIHOPE_ZORSE_DARK_HAUKET);
            return true;
        }
        if (stack.m_41720_() == Items.f_42402_ && stack.m_41786_().getString().equals("Herald")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.COURIER_CALICO_HAUKET);
            return true;
        }
        if (stack.m_41720_() == Items.f_42740_ && stack.m_41786_().getString().equals("Duty")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.GUARDIAN_BAY_GRAY_HAUKET);
            return true;
        }
        if (stack.m_41720_() == Items.f_42417_ && stack.m_41786_().getString().equals("Reign")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.ROYAL_BRINDLE_HAUKET);
            return true;
        }
        if (stack.m_41720_() == Items.f_42695_ && stack.m_41786_().getString().equals("13 Horses")) {
            stack.m_41774_(1);
            this.getCoatBehavior().set(BaseCoats.RIPTIDE_PEACOCK_HAUKET);
            return true;
        }
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_6162_()) {
            if (itemstack.m_150930_((Item)ItemSetup.STAR_WORM.get()) && player.m_7500_() && player.m_6144_() && Keys.hasPermission(player, PermissionNodes.CAN_FILM)) {
                if (!this.m_9236_().m_5776_()) {
                    CompoundTag playerData = player.getPersistentData();
                    if (playerData.m_128441_("FilmingHorse")) {
                        playerData.m_128473_("FilmingHorse");
                        player.m_5661_((Component)Component.m_237110_((String)"horse.swem.clear_filming_horse", (Object[])new Object[]{this.m_5446_()}), false);
                    } else {
                        playerData.m_128362_("FilmingHorse", this.m_20148_());
                        player.m_5661_((Component)Component.m_237110_((String)"horse.swem.set_filming_horse", (Object[])new Object[]{this.m_5446_()}), false);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (this.m_30614_() && player.m_36341_() && !(itemstack.m_41720_() instanceof TrackerItem) && !(itemstack.m_41720_() instanceof TackItem)) {
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_20160_() && !this.m_5803_()) {
                this.m_6835_(player);
                return super.m_6071_(player, hand);
            }
        }
        if (itemstack.m_41619_() && this.m_5803_()) {
            this.getBehavior(SleepingBehavior.class).forceWakeUp(100);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        Item item = itemstack.m_41720_();
        if (item instanceof DebugStickItem) {
            if (!this.m_9236_().f_46443_) {
                String breedingWord = this.getBreeding().isFemale() ? "Births" : "Covers";
                int offsprings = this.getBreeding().getTotalOffsprings();
                player.m_213846_((Component)Component.m_237113_((String)("Blocks Travelled: " + this.m_20088_().m_135370_(BLOCKS_TRAVELLED_STAT) + "\nJumps: " + this.m_20088_().m_135370_(JUMP_STAT) + "\n" + breedingWord + ": " + offsprings)));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_30614_() && this.checkIsCoatTransformItem(player, itemstack)) {
            return InteractionResult.SUCCESS;
        }
        if (!itemstack.m_41619_() && item != Items.f_42450_) {
            boolean canEquipBreastCollar;
            if (!this.m_6162_() && this.m_30614_() && (this.isOwner(player) || Keys.hasPermission(player, PermissionNodes.CAN_MODIFY))) {
                if (item == Items.f_42534_ && ((Boolean)ServerConfig.COAT_CYCLING_ENABLED.get()).booleanValue()) {
                    this.getCoatBehavior().cycleNextCoat();
                    ItemStack heldItemCopy = itemstack.m_41777_();
                    if (!player.m_7500_()) {
                        heldItemCopy.m_41774_(1);
                    }
                    player.m_21008_(hand, heldItemCopy);
                    return InteractionResult.SUCCESS;
                }
                if (item == Items.f_42451_ && ((Boolean)ServerConfig.COAT_CYCLING_ENABLED.get()).booleanValue()) {
                    this.getCoatBehavior().cyclePreviousCoat();
                    ItemStack heldItemCopy = itemstack.m_41777_();
                    if (!player.m_7500_()) {
                        heldItemCopy.m_41774_(1);
                    }
                    player.m_21008_(hand, heldItemCopy);
                    return InteractionResult.SUCCESS;
                }
            }
            if (NEGATIVE_FOOD_ITEMS.test(itemstack)) {
                if (!this.m_9236_().m_5776_()) {
                    this.emitBadParticles((ServerLevel)this.m_9236_(), 4);
                }
                return InteractionResult.FAIL;
            }
            if (this.isBreedingFood(itemstack) && this.canAcceptBreedingFoodFrom(player, itemstack)) {
                return this.fedBreedingFood(player, itemstack);
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.canAccessHorse(player) && this.getNeeds().getHunger().feedWith(itemstack)) {
                    if (!player.m_7500_()) {
                        if (itemstack.m_41720_().isDamageable(itemstack)) {
                            itemstack.m_41622_(1, (LivingEntity)player, p -> {});
                        } else {
                            itemstack.m_41774_(1);
                        }
                    }
                    this.emitYayParticles((ServerLevel)this.m_9236_(), 3);
                    return InteractionResult.SUCCESS;
                }
                if (Feeds.fromItem(itemstack) != null) {
                    this.emitEchParticles((ServerLevel)this.m_9236_(), 3);
                    return InteractionResult.PASS;
                }
            }
            if (item == Items.f_42447_) {
                if (this.m_9236_().m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
                if (this.getNeeds().getThirst().canDrink()) {
                    this.getNeeds().getThirst().drink();
                    player.m_21008_(hand, BucketItem.m_40699_((ItemStack)itemstack, (Player)player));
                    this.emitYayParticles((ServerLevel)this.m_9236_(), 4);
                } else {
                    this.emitEchParticles((ServerLevel)this.m_9236_(), 3);
                }
                return InteractionResult.CONSUME;
            }
            InteractionResult actionresulttype = itemstack.m_41647_(player, (LivingEntity)this, hand);
            if (actionresulttype.m_19077_()) {
                if (TackType.SADDLE.is(itemstack)) {
                    this.setSWEMSaddled();
                }
                return actionresulttype;
            }
            if (!this.m_30614_()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            boolean canEquipSaddle = !this.m_6162_() && !this.hasSaddle() && TackType.SADDLE.is(itemstack) && this.canEquip(itemstack, TackType.SADDLE);
            boolean canEquipGirthStrap = !this.m_6162_() && !this.hasGirthStrap() && TackType.GIRTH_STRAP.is(itemstack) && this.canEquip(itemstack, TackType.GIRTH_STRAP);
            boolean canEquipBlanket = !this.m_6162_() && !this.hasBlanket() && TackType.BLANKET.is(itemstack) && this.canEquip(itemstack, TackType.BLANKET);
            boolean canEquipLegWraps = !this.m_6162_() && !this.hasLegWraps() && TackType.LEG_WRAPS.is(itemstack) && this.canEquip(itemstack, TackType.LEG_WRAPS);
            boolean bl = canEquipBreastCollar = !this.m_6162_() && !this.hasBreastCollar() && TackType.BREAST_COLLAR.is(itemstack) && this.canEquip(itemstack, TackType.BREAST_COLLAR);
            if (this.isSWEMArmor(itemstack) || canEquipSaddle) {
                this.setSWEMSaddled();
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (canEquipGirthStrap || canEquipBlanket || canEquipLegWraps || canEquipBreastCollar) {
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        if (!this.m_5803_()) {
            this.m_6835_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        player.m_5661_((Component)Component.m_237113_((String)(this.m_5446_().getString() + " is sleeping.")), true);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    private boolean canAcceptBreedingFoodFrom(Player player, ItemStack itemstack) {
        if (!itemstack.m_150930_((Item)ItemSetup.TOKEN_BREEDING_HORSE.get())) {
            return true;
        }
        return this.isOwner(player) || Keys.hasPermission(player, PermissionNodes.CAN_MODIFY);
    }

    public boolean isOwner(Player player) {
        return player.m_20148_().equals(this.m_21805_());
    }

    public boolean m_6898_(ItemStack pStack) {
        return this.isBreedingFood(pStack);
    }

    public boolean isBreedingFood(ItemStack pStack) {
        return pStack.m_41720_() == ItemSetup.TOKEN_BREEDING_HORSE.get() || (Boolean)ServerConfig.ENABLE_BREEDING_TOKENS.get() == false && BREEDING_ITEMS.test(pStack);
    }

    public InteractionResult fedBreedingFood(Player pPlayer, ItemStack pStack) {
        boolean flag = this.handleEatingBreedingFood(pPlayer, pStack);
        if (flag && !pPlayer.m_7500_()) {
            if (pStack.m_41720_().isDamageable(pStack)) {
                pStack.m_41622_(1, (LivingEntity)pPlayer, player -> {});
            } else {
                pStack.m_41774_(1);
            }
        }
        return flag ? InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_) : InteractionResult.PASS;
    }

    public boolean handleEatingBreedingFood(@javax.annotation.Nullable Player player, ItemStack pStack) {
        boolean isSuccessful = false;
        if (!this.m_9236_().m_5776_()) {
            this.getNeeds().getHunger().feedWith(pStack);
        }
        if (this.getBreeding().canFallInLove()) {
            isSuccessful = true;
            this.getBreeding().fallInLove(player);
        } else if (!this.m_9236_().m_5776_()) {
            this.emitMehParticles((ServerLevel)this.m_9236_(), 3);
        }
        int amountToGrowUp = (int)((double)((Integer)ServerConfig.FOAL_GROW_UP_TIME_IN_SECONDS.get()).intValue() * 0.5);
        if (!((Boolean)ServerConfig.ENABLE_BREEDING_TOKENS.get()).booleanValue() && this.m_6162_() && amountToGrowUp > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().m_5776_()) {
                this.m_146758_(amountToGrowUp);
            }
            isSuccessful = true;
        }
        return isSuccessful;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (pOtherAnimal.getClass() != this.getClass()) {
            return false;
        }
        Path path = this.f_21344_.m_6570_((Entity)pOtherAnimal, 1);
        return path != null && path.m_77403_() && this.getBreeding().canMate((SWEMHorseEntityBase)pOtherAnimal) && ((SWEMHorseEntityBase)pOtherAnimal).getBreeding().canMate(this);
    }

    public void emitBadParticles(ServerLevel world, int count) {
        world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleSetup.BAD.get()), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), count, 0.3, 0.3, 0.3, 0.3);
    }

    public void emitEchParticles(ServerLevel world, int count) {
        world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleSetup.ECH.get()), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), count, 0.3, 0.3, 0.3, 0.3);
    }

    public void emitMehParticles(ServerLevel world, int count) {
        world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleSetup.MEH.get()), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), count, 0.3, 0.3, 0.3, 0.3);
    }

    public void emitYayParticles(ServerLevel world, int count) {
        world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleSetup.YAY.get()), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), count, 0.3, 0.3, 0.3, 0.3);
    }

    public void emitWootParticles(ServerLevel world, int count) {
        world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleSetup.WOOT.get()), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), count, 0.3, 0.3, 0.3, 0.3);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    private boolean checkForBackHit(Vec3 vec) {
        Direction facing = this.m_6350_();
        switch (facing) {
            case NORTH: {
                if (!(vec.f_82481_ > 0.0)) break;
                ModRef.LOGGER.debug("Back was hit, while facing NORTH.");
                return true;
            }
            case SOUTH: {
                if (!(vec.f_82481_ < 0.0)) break;
                ModRef.LOGGER.debug("Back was hit, while facing SOUTH.");
                return true;
            }
            case EAST: {
                if (!(vec.f_82479_ > 0.0)) break;
                ModRef.LOGGER.debug("Back was hit, while facing EAST.");
                return true;
            }
            case WEST: {
                if (!(vec.f_82479_ < 0.0)) break;
                ModRef.LOGGER.debug("Back was hit, while facing north.");
                return true;
            }
        }
        return false;
    }

    public NeedManager getNeeds() {
        return this.needs;
    }

    public boolean m_27593_() {
        return this.getBreeding().isInLove();
    }

    public void m_6863_(boolean pIsChild) {
        this.m_146762_(pIsChild ? -((Integer)ServerConfig.FOAL_GROW_UP_TIME_IN_SECONDS.get() * 20) : 0);
    }

    protected void m_30232_() {
        if (!this.m_6162_()) {
            ArrayList<HorseColor> baseColors = new ArrayList<HorseColor>(this.getCoatBehavior().coat().baseColors());
            Collections.shuffle(baseColors);
            this.getCoatBehavior().set(CoatManager.adult((HorseColor)((Object)baseColors.get(0))));
        }
        super.m_30232_();
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob other) {
        SWEMHorseEntityBase foal = (SWEMHorseEntityBase)((EntityType)EntitySetup.SWEM_HORSE_ENTITY.get()).m_20615_((Level)world);
        SWEMHorseEntityBase partner = (SWEMHorseEntityBase)other;
        if (foal == null) {
            ModRef.LOGGER.error("Uh oh - A foal could not be spawned, something went wrong.\nPartner 1: " + this + "\nPartner 2: " + other);
            return null;
        }
        ArrayList<HorseColor> colorPool = new ArrayList<HorseColor>();
        colorPool.addAll(this.getCoatBehavior().coat().baseColors());
        colorPool.addAll(partner.getCoatBehavior().coat().baseColors());
        Collections.shuffle(colorPool);
        HorseColor foalColor = (HorseColor)((Object)colorPool.get(0));
        HorseCoat foalCoat = CoatManager.foal(foalColor);
        foal.setGait(Gait.WALK);
        foal.getCoatBehavior().set(foalCoat);
        foal.m_30657_(true);
        SWEMHorseEntityBase sire = this.getBreeding().isMale() ? this : partner;
        SWEMHorseEntityBase dam = this.getBreeding().isFemale() ? this : partner;
        LineageBehavior foalLineage = foal.getBehavior(LineageBehavior.class);
        foalLineage.setSire(sire);
        foalLineage.setDam(dam);
        this.addOffspring(foal);
        partner.addOffspring(foal);
        if (dam.m_30614_()) {
            dam.m_9236_().m_7654_().m_129927_().m_11002_(dam.m_21805_()).ifPresent(foal::tameWithName);
        }
        return foal;
    }

    @javax.annotation.Nullable
    public HorseDataElement getSire() {
        UUID sireId = this.getBehavior(LineageBehavior.class).getSireId();
        return CommonEventHandler.getHorseDataManager().getHorseData(sireId);
    }

    @javax.annotation.Nullable
    public HorseDataElement getDam() {
        UUID damId = this.getBehavior(LineageBehavior.class).getDamId();
        return CommonEventHandler.getHorseDataManager().getHorseData(damId);
    }

    public void addOffspring(SWEMHorseEntityBase foal) {
        LineageBehavior lineage = this.getBehavior(LineageBehavior.class);
        lineage.addOffspring(foal);
    }

    public List<UUID> getOffspring() {
        return this.getBehavior(LineageBehavior.class).getOffspringIds();
    }

    protected void m_7567_() {
        if (this.m_30623_() && this.m_6162_() && !this.m_30617_()) {
            HorseDataElement damData = this.getDam();
            UUID damId = damData != null ? damData.getHorseId() : null;
            List dam = this.m_9236_().m_6443_(this.getClass(), this.m_20191_().m_82400_(16.0), horse -> horse.m_20148_().equals(damId));
            List mares = this.m_9236_().m_6443_(this.getClass(), this.m_20191_().m_82400_(16.0), horse -> horse.getBreeding().isFemale());
            if (!dam.isEmpty() && this.m_20280_((Entity)dam.get(0)) > 4.0) {
                this.f_21344_.m_5624_((Entity)dam.get(0), 4.0);
            } else if (!mares.isEmpty()) {
                LivingEntity closest = null;
                int distance = Integer.MAX_VALUE;
                for (LivingEntity entity : mares) {
                    int newDistance = (int)this.m_20280_((Entity)entity);
                    if (newDistance >= distance) continue;
                    distance = newDistance;
                    closest = entity;
                }
                if (closest != null && this.m_20280_((Entity)closest) > 4.0) {
                    this.f_21344_.m_5624_(closest, 4.0);
                }
            }
        }
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        HorseCoat coat;
        if (pSpawnData instanceof SWEMHorseData) {
            coat = ((SWEMHorseData)((Object)pSpawnData)).coat;
        } else {
            coat = CoatManager.randomLapisCoat();
            pSpawnData = new SWEMHorseData(coat);
        }
        SWEMHorseData data = (SWEMHorseData)((Object)pSpawnData);
        this.getCoatBehavior().set(coat);
        this.setGait(Gait.WALK);
        if (data.m_146779_() && pLevel.m_213780_().m_188501_() <= data.m_146780_()) {
            HorseColor baseColor = coat.baseColors().get(rand.nextInt(coat.baseColors().size()));
            HorseCoat foalCoat = CoatManager.foal(baseColor);
            this.m_6863_(true);
            this.getCoatBehavior().set(foalCoat);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_7482_() {
        return true;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.f_30520_.m_8020_(0));
        buffer.m_130055_(this.f_30520_.m_8020_(1));
        buffer.m_130055_(this.f_30520_.m_8020_(2));
        buffer.m_130055_(this.f_30520_.m_8020_(3));
        buffer.m_130055_(this.f_30520_.m_8020_(4));
        buffer.m_130055_(this.f_30520_.m_8020_(5));
        buffer.m_130055_(this.f_30520_.m_8020_(6));
        buffer.m_130055_(this.f_30520_.m_8020_(7));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.f_30520_.m_6836_(0, additionalData.m_130267_());
        this.f_30520_.m_6836_(1, additionalData.m_130267_());
        this.f_30520_.m_6836_(2, additionalData.m_130267_());
        this.f_30520_.m_6836_(3, additionalData.m_130267_());
        this.f_30520_.m_6836_(4, additionalData.m_130267_());
        this.f_30520_.m_6836_(5, additionalData.m_130267_());
        this.f_30520_.m_6836_(6, additionalData.m_130267_());
        this.f_30520_.m_6836_(7, additionalData.m_130267_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void decrementSpeed() {
        Player player = this.getControllingPlayer();
        if (player == null) {
            ModRef.LOGGER.debug("A non player entity ({} | {}) tried to increment the speed!", (Object)((Entity)this.m_20197_().get(0)).m_5446_(), (Object)((Entity)this.m_20197_().get(0)).m_20148_());
            return;
        }
        if (this.isFlying()) {
            player.m_5661_((Component)Component.m_237115_((String)"swem.horse.change_gait.is_flying"), true);
            return;
        }
        if (this.getGait() == Gait.WALK) {
            return;
        }
        Gait newGait = Gait.fromId(this.getGait().gaitId - 1);
        this.setGait(newGait);
    }

    public void incrementSpeed() {
        Player player = this.getControllingPlayer();
        if (player == null) {
            ModRef.LOGGER.debug("A non player entity ({} | {}) tried to increment the speed!", (Object)((Entity)this.m_20197_().get(0)).m_5446_(), (Object)((Entity)this.m_20197_().get(0)).m_20148_());
            return;
        }
        if (this.isFlying()) {
            player.m_5661_((Component)Component.m_237115_((String)"swem.horse.change_gait.is_flying"), true);
            return;
        }
        if (this.m_20069_()) {
            player.m_5661_((Component)Component.m_237110_((String)"swem.horse.change_gait.in_water", (Object[])new Object[]{this.m_5446_()}), true);
            return;
        }
        if (this.getGait() == Gait.GALLOP) {
            player.m_5661_((Component)Component.m_237110_((String)"swem.horse.change_gait.galloping", (Object[])new Object[]{this.m_5446_()}), true);
            return;
        }
        double d = this.m_217043_().m_188500_() * (double)this.getObedienceModifier();
        double d2 = this.progressionManager.getAffinityLeveling().getDebuff() * this.getGait().getSkillMultiplier();
        double d3 = this.disobedienceTimer > 0 ? 0.5 : 1.0;
        if (d < d2 * d3) {
            this.disobey();
            return;
        }
        Gait nextGait = Gait.fromId(this.getGait().gaitId + 1);
        if (!this.needs.getThirst().getState().canBeAtSpeed(nextGait)) {
            player.m_5661_((Component)Component.m_237110_((String)"swem.horse.status.too_thirsty", (Object[])new Object[]{Component.m_237115_((String)nextGait.translationKey)}), true);
            return;
        }
        if (!this.needs.getHunger().getState().canBeAtSpeed(nextGait)) {
            player.m_5661_((Component)Component.m_237110_((String)"swem.horse.status.too_hungry", (Object[])new Object[]{Component.m_237115_((String)nextGait.translationKey)}), true);
            return;
        }
        if (nextGait == Gait.GALLOP && ((Boolean)this.f_19804_.m_135370_(GALLOP_ON_COOLDOWN)).booleanValue()) {
            player.m_5661_((Component)Component.m_237110_((String)"swem.horse.status.gallop_cooldown", (Object[])new Object[]{String.valueOf(Math.round((float)((Integer)this.f_19804_.m_135370_(GALLOP_COOLDOWN_TIMER) - (Integer)this.f_19804_.m_135370_(GALLOP_TIMER)) / 20.0f))}), true);
            return;
        }
        this.setGait(nextGait);
    }

    public float getObedienceModifier() {
        return ((Float)this.f_19804_.m_135370_(OBEDIENCE_MODIFIER)).floatValue() * (1.0f - this.needs.getHunger().getState().obedienceDebuff) * (1.0f - this.needs.getThirst().getState().obedienceDebuff);
    }

    public void addObedienceModifier(float amount) {
        this.f_19804_.m_135381_(OBEDIENCE_MODIFIER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(OBEDIENCE_MODIFIER)).floatValue() + amount));
    }

    public void removeObedienceModifier(float amount) {
        this.f_19804_.m_135381_(OBEDIENCE_MODIFIER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(OBEDIENCE_MODIFIER)).floatValue() - amount));
    }

    public boolean canIncrementSpeed(Player player) {
        if (this.m_30622_()) {
            return false;
        }
        if (this.getGait() == Gait.GALLOP) {
            player.m_5661_((Component)Component.m_237115_((String)"text.swem.status.increment_denied_by_gallop"), true);
            return false;
        }
        if (this.m_20069_()) {
            player.m_5661_((Component)Component.m_237115_((String)"text.swem.status.increment_denied_by_water"), true);
            return false;
        }
        return true;
    }

    public Gait getGait() {
        return Gait.fromId((Integer)this.f_19804_.m_135370_(GAIT_ID));
    }

    public void setGait(Gait gait) {
        Gait oldGait = this.getGait();
        this.f_19804_.m_135381_(GAIT_ID, (Object)gait.gaitId);
        if (this.getGait() == Gait.TROT) {
            this.m_21051_(Attributes.f_22279_).m_22100_(SWEMUtil.getInternalSpeedFromBlocksPerSecond(5.5));
        } else if (this.getGait() == Gait.WALK) {
            this.m_21051_(Attributes.f_22279_).m_22100_(SWEMUtil.getInternalSpeedFromBlocksPerSecond(1.8));
        } else if (this.getGait() == Gait.CANTER) {
            this.m_21051_(Attributes.f_22279_).m_22100_(SWEMUtil.getInternalSpeedFromBlocksPerSecond(11.0));
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(this.getAlteredMovementSpeed());
        }
        this.m_21051_(Attributes.f_22279_).m_22130_(oldGait.getModifier());
        if (!this.m_21051_(Attributes.f_22279_).m_22109_(this.getGait().getModifier())) {
            this.m_21051_(Attributes.f_22279_).m_22118_(this.getGait().getModifier());
        }
        if (this.getGait() != Gait.WALK) {
            HungerNeed.HungerState hungerState = this.needs.getHunger().getState();
            hungerState.applyDebuff(this);
        }
        if (oldGait == Gait.GALLOP) {
            this.setGallopCooldown();
        }
    }

    public boolean canFly() {
        return ServerConfig.wingedHorseFly && this.getCoatBehavior().coat().hasWings() || this.getArmorTier().getTier() >= HorseArmorTier.AMETHYST.getTier();
    }

    public void brush() {
        this.progressionManager.getAffinityLeveling().brush();
    }

    public void cycleRidingPermission() {
        this.m_20088_().m_135381_(RIDING_PERMISSION_DATA, (Object)((byte)RidingPermission.values()[((Byte)this.m_20088_().m_135370_(RIDING_PERMISSION_DATA) + 1) % RidingPermission.values().length].ordinal()));
    }

    public RidingPermission getPermissionState() {
        return RidingPermission.values()[(Byte)this.m_20088_().m_135370_(RIDING_PERMISSION_DATA)];
    }

    protected int m_7506_() {
        return 8;
    }

    @Override
    public boolean hasTack(TackType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TackType.HALTER -> {
                if (!this.getHalter().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.BRIDLE -> {
                if (!this.getBridle().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.BLANKET -> {
                if (!this.getBlanket().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.SADDLE -> {
                if (!this.getSaddle().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.GIRTH_STRAP -> {
                if (!this.getGirthStrap().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.BREAST_COLLAR -> {
                if (!this.getBreastCollar().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.LEG_WRAPS -> {
                if (!this.getLegWraps().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.PASTURE_BLANKET -> {
                if (!this.getPastureBlanket().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.SADDLE_BAG -> {
                if (!this.getSaddleBag().m_41619_()) {
                    yield true;
                }
                yield false;
            }
            case TackType.HORSE_ARMOR -> !this.getArmor().m_41619_();
        };
    }

    @Override
    public boolean canEquip(ItemStack stack, TackType type) {
        TackItem tack;
        Item item = stack.m_41720_();
        if (!(item instanceof TackItem) || (tack = (TackItem)item).getType() != type) {
            return false;
        }
        TackTypeData data = tack.getData();
        return switch (tack.getType()) {
            case TackType.HALTER -> true;
            case TackType.BRIDLE -> this.notRestrictedBy(data, TackType.PASTURE_BLANKET);
            case TackType.BLANKET -> {
                if (this.notRestrictedBy(data, TackType.PASTURE_BLANKET) && (this.hasRequired(data, TackType.BRIDLE) || !((Boolean)ServerConfig.EQUIP_BRIDLE_REQUIRED.get()).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            case TackType.SADDLE -> {
                if (this.notRestrictedBy(data, TackType.PASTURE_BLANKET) && (this.hasRequired(data, TackType.BLANKET) || !((Boolean)ServerConfig.EQUIP_BLANKET_REQUIRED.get()).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            case TackType.GIRTH_STRAP -> {
                if (this.notRestrictedBy(data, TackType.PASTURE_BLANKET) && (this.hasRequired(data, TackType.SADDLE) || !((Boolean)ServerConfig.EQUIP_SADDLE_REQUIRED.get()).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            case TackType.BREAST_COLLAR -> {
                if (this.notRestrictedBy(data, TackType.PASTURE_BLANKET) && (this.hasRequired(data, TackType.GIRTH_STRAP) || !((Boolean)ServerConfig.EQUIP_GIRTH_STRAP_REQUIRED.get()).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            case TackType.LEG_WRAPS -> true;
            case TackType.PASTURE_BLANKET -> {
                if (this.notRestrictedBy(data, TackType.BRIDLE) && this.notRestrictedBy(data, TackType.BLANKET) && this.notRestrictedBy(data, TackType.SADDLE) && this.notRestrictedBy(data, TackType.GIRTH_STRAP)) {
                    yield true;
                }
                yield false;
            }
            case TackType.SADDLE_BAG -> {
                if (!this.hasSaddleBag() && this.notRestrictedBy(data, TackType.PASTURE_BLANKET) && (this.hasRequired(data, TackType.SADDLE) || !((Boolean)ServerConfig.EQUIP_SADDLE_REQUIRED.get()).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            case TackType.HORSE_ARMOR -> {
                if (this.notRestrictedBy(data, TackType.PASTURE_BLANKET) && (this.hasRequired(data, TackType.BREAST_COLLAR) && this.hasRequired(data, TackType.LEG_WRAPS) || !((Boolean)ServerConfig.EQUIP_ALL_FOR_ARMOR.get()).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private boolean hasRequired(TackTypeData data, TackType type) {
        return !data.ignores(type) && this.hasTack(type);
    }

    private boolean notRestrictedBy(TackTypeData data, TackType type) {
        return !data.ignores(type) && !this.hasTack(type);
    }

    @Override
    public ItemStack getTack(TackType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TackType.HALTER -> this.getHalterOrBridle();
            case TackType.BRIDLE -> this.getBridle();
            case TackType.BLANKET -> this.getBlanket();
            case TackType.SADDLE -> this.getSaddle();
            case TackType.GIRTH_STRAP -> this.getGirthStrap();
            case TackType.BREAST_COLLAR -> this.getBreastCollar();
            case TackType.LEG_WRAPS -> this.getLegWraps();
            case TackType.PASTURE_BLANKET -> this.getPastureBlanket();
            case TackType.SADDLE_BAG -> this.getSaddleBag();
            case TackType.HORSE_ARMOR -> this.getArmor();
        };
    }

    @Override
    public boolean equipTack(ItemStack stack, Player player) {
        CompoundTag nbt;
        Item item = stack.m_41720_();
        if (!(item instanceof TackItem)) {
            return false;
        }
        TackItem tack = (TackItem)item;
        TackType tackType = tack.getType();
        int slot = switch (tackType) {
            default -> throw new IncompatibleClassChangeError();
            case TackType.HALTER -> 0;
            case TackType.BRIDLE -> 0;
            case TackType.BLANKET -> 1;
            case TackType.SADDLE -> 2;
            case TackType.GIRTH_STRAP -> 5;
            case TackType.BREAST_COLLAR -> 3;
            case TackType.LEG_WRAPS -> 4;
            case TackType.PASTURE_BLANKET -> 6;
            case TackType.SADDLE_BAG -> 7;
            case TackType.HORSE_ARMOR -> 6;
        };
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        boolean tryReplace = player != null && player.m_6144_();
        ItemStack existingStack = this.f_30520_.m_8020_(slot);
        if (!existingStack.m_41619_() && !tryReplace) {
            return false;
        }
        player.m_150109_().m_150079_(existingStack);
        if (tackType == TackType.SADDLE_BAG && (nbt = stack.m_41784_()).m_128441_("items")) {
            CompoundTag items = nbt.m_128469_("items");
            for (int i = 0; i < this.getSaddlebagInventory().m_6643_(); ++i) {
                this.getSaddlebagInventory().m_6836_(i, ItemStack.m_41712_((CompoundTag)items.m_128469_(Integer.toString(i))));
            }
        }
        this.insertAndSyncItem(slot, copy);
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12034_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return true;
    }

    public boolean isHalter(ItemStack stack) {
        return TackType.HALTER.is(stack);
    }

    public boolean isBridle(ItemStack stack) {
        return TackType.BRIDLE.is(stack);
    }

    public ItemStack getHalterOrBridle() {
        return this.f_30520_.m_8020_(0);
    }

    public ItemStack getHalter() {
        ItemStack stack = this.getHalterOrBridle();
        return TackType.HALTER.is(stack) ? stack : ItemStack.f_41583_;
    }

    public ItemStack getBridle() {
        ItemStack stack = this.getHalterOrBridle();
        return TackType.BRIDLE.is(stack) ? stack : ItemStack.f_41583_;
    }

    public boolean isBreastCollar(ItemStack stack) {
        TackItem tack;
        Item item = stack.m_41720_();
        return item instanceof TackItem && (tack = (TackItem)item).getType() == TackType.BREAST_COLLAR;
    }

    public ItemStack getBreastCollar() {
        return this.f_30520_.m_8020_(3);
    }

    public boolean isLegWraps(ItemStack stack) {
        TackItem tack;
        Item item = stack.m_41720_();
        return item instanceof TackItem && (tack = (TackItem)item).getType() == TackType.LEG_WRAPS;
    }

    public ItemStack getLegWraps() {
        return this.f_30520_.m_8020_(4);
    }

    public boolean isGirthStrap(ItemStack stack) {
        TackItem tack;
        Item item = stack.m_41720_();
        return item instanceof TackItem && (tack = (TackItem)item).getType() == TackType.GIRTH_STRAP;
    }

    public ItemStack getGirthStrap() {
        return this.f_30520_.m_8020_(5);
    }

    public boolean hasBridle() {
        TackItem tack;
        Item item = this.getBridle().m_41720_();
        return item instanceof TackItem && (tack = (TackItem)item).getType() == TackType.BRIDLE;
    }

    @Override
    public boolean canEquipSaddle() {
        return this.hasBlanket() || (Boolean)ServerConfig.EQUIP_BLANKET_REQUIRED.get() == false;
    }

    @Override
    public boolean canEquipGirthStrap() {
        return this.hasSaddle() || (Boolean)ServerConfig.EQUIP_SADDLE_REQUIRED.get() == false;
    }

    public boolean canEquipSaddleBag() {
        return !this.hasSaddleBag() && this.hasSaddle() || (Boolean)ServerConfig.EQUIP_SADDLE_REQUIRED.get() == false;
    }

    @Override
    public boolean canEquipArmor() {
        TackItem legWraps;
        TackItem breastCollar;
        TackItem blanket;
        TackItem girthStrap;
        TackItem bridle;
        Item item;
        return !this.m_7481_() && this.hasAdventureSaddle() && (item = this.getHalterOrBridle().m_41720_()) instanceof TackItem && (bridle = (TackItem)item).getData().canWearArmor() && (item = this.getGirthStrap().m_41720_()) instanceof TackItem && (girthStrap = (TackItem)item).getData().canWearArmor() && (item = this.getBlanket().m_41720_()) instanceof TackItem && (blanket = (TackItem)item).getData().canWearArmor() && ((Boolean)ServerConfig.EQUIP_ALL_FOR_ARMOR.get() == false || (item = this.getBreastCollar().m_41720_()) instanceof TackItem && (breastCollar = (TackItem)item).getData().canWearArmor() && (item = this.getLegWraps().m_41720_()) instanceof TackItem && (legWraps = (TackItem)item).getData().canWearArmor());
    }

    @Override
    public boolean m_7481_() {
        return !this.getArmor().m_41619_();
    }

    @Override
    public boolean canEquipPastureBlanket() {
        return this.getArmor().m_41619_() && this.getSaddle().m_41619_() && !this.hasGirthStrap() && !this.hasBreastCollar() && !this.hasBlanket();
    }

    @Override
    public boolean isWearingPastureBlanket() {
        return TackType.PASTURE_BLANKET.is(this.f_30520_.m_8020_(6));
    }

    public boolean m_6109_() {
        LivingEntity controllingEntity;
        if ((this.hasBridle() || !((Boolean)ServerConfig.NEEDS_BRIDLE_TO_STEER.get()).booleanValue()) && this.hasSaddle() && (controllingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)controllingEntity;
            return player.m_7578_();
        }
        return this.m_20197_().isEmpty() && this.m_21515_();
    }

    public boolean isSWEMArmor(ItemStack stack) {
        return TackType.HORSE_ARMOR.is(stack);
    }

    public ItemStack getArmorOrPastureBlanket() {
        return this.f_30520_.m_8020_(6);
    }

    public ItemStack getArmor() {
        ItemStack stack = this.getArmorOrPastureBlanket();
        return TackType.HORSE_ARMOR.is(stack) ? stack : ItemStack.f_41583_;
    }

    public ItemStack getPastureBlanket() {
        ItemStack stack = this.getArmorOrPastureBlanket();
        return TackType.PASTURE_BLANKET.is(stack) ? stack : ItemStack.f_41583_;
    }

    public HorseArmorTier getArmorTier() {
        ItemStack stack = this.getArmorOrPastureBlanket();
        if (TackType.HORSE_ARMOR.is(stack)) {
            return TackItem.as(stack).getData(HorseArmorTypeData.class).getArmorTier();
        }
        if (TackType.PASTURE_BLANKET.is(stack)) {
            return TackItem.as(stack).getData(PastureBlanketTypeData.class).isArmored() ? HorseArmorTier.DIAMOND : HorseArmorTier.NONE;
        }
        return HorseArmorTier.NONE;
    }

    public boolean isSaddleBag(ItemStack stack) {
        return TackType.SADDLE_BAG.is(stack);
    }

    public ItemStack getSaddleBag() {
        return this.f_30520_.m_8020_(7);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.getBehavior(GodBehavior.class).isGod()) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.hasBridle()) {
                if (this.m_6573_(player) && player.m_6144_()) {
                    this.setBridleLeashed(true);
                    this.m_21463_((Entity)player, true);
                    return false;
                }
                if (this.m_21523_() && this.isBridleLeashed() && player.m_6144_()) {
                    this.setBridleLeashed(false);
                    this.m_21455_(true, false);
                    return false;
                }
            }
            if (this.m_142429_().anyMatch(e -> e.equals((Object)player))) {
                return false;
            }
        }
        if (this.m_20160_() && !this.m_9236_().f_46443_) {
            this.progressionManager.getAffinityLeveling().removeXp(damage * 2.0f);
        } else if (source.m_7639_() != null && source.m_7639_().m_20148_().equals(this.m_21805_()) && !this.m_9236_().f_46443_) {
            this.progressionManager.getAffinityLeveling().removeXp(damage * 5.0f);
        }
        if (source == this.m_269291_().m_268989_() && this.m_9236_().m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        if (source == this.m_269291_().m_268989_()) {
            if (this.m_21223_() <= 6.0f) {
                damage = 0.0f;
            } else if (this.m_21223_() - damage < 6.0f) {
                damage = this.m_21223_() - 6.0f;
            }
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            damage /= 2.0f;
        }
        if (source.m_7640_() instanceof AbstractArrow) {
            damage = this.calculateArrowDamage((AbstractArrow)source.m_7640_(), damage);
        }
        if ((source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268493_)) && this.getArmorTier().is(HorseArmorTier.IRON)) {
            damage /= 2.0f;
        }
        if (damage <= 0.0f) {
            return false;
        }
        boolean hasBeenHurt = super.m_6469_(source, damage);
        if (hasBeenHurt) {
            ActionBehavior.Action action;
            if (!this.m_9236_().m_5776_()) {
                this.emitBadParticles((ServerLevel)this.m_9236_(), 5);
                if (this.isFlying()) {
                    this.triggerAnim("horse", HorseAnimations.Keys.FLIGHT_HURT);
                }
            }
            if (damage > 1.0f && ((action = this.getBehavior(ActionBehavior.class).getActiveAction()) == null || !action.isStanding())) {
                this.disobey();
            }
            this.getBehavior(SleepingBehavior.class).forceWakeUp(100);
        }
        return hasBeenHurt;
    }

    public boolean m_6051_() {
        return this.getArmorTier().getTier() < HorseArmorTier.DIAMOND.getTier() && super.m_6051_();
    }

    protected int m_5639_(float pDistance, float pDamageMultiplier) {
        return Mth.m_14167_((float)((pDistance * 0.5f - 4.0f) * pDamageMultiplier));
    }

    private float calculateArrowDamage(AbstractArrow arrow, float amount) {
        if (!this.m_7481_()) {
            return amount;
        }
        HorseArmorTier tier = this.getArmorTier();
        if (tier == HorseArmorTier.IRON) {
            boolean shouldBlock;
            boolean bl = shouldBlock = (double)this.f_19796_.m_188501_() > 0.5;
            if (shouldBlock && !arrow.m_36792_()) {
                amount = 0.0f;
            } else if (shouldBlock && arrow.m_36792_()) {
                amount = 2.0f;
            }
        } else if (tier == HorseArmorTier.GOLD) {
            boolean shouldBlock;
            boolean bl = shouldBlock = (double)this.f_19796_.m_188501_() > 0.5;
            if (shouldBlock && !arrow.m_36792_()) {
                amount = 0.0f;
            } else if (shouldBlock && arrow.m_36792_()) {
                amount = 2.0f;
            }
        } else if (tier == HorseArmorTier.DIAMOND) {
            boolean shouldBlock;
            boolean bl = shouldBlock = (double)this.f_19796_.m_188501_() > 0.25;
            if (shouldBlock && !arrow.m_36792_()) {
                amount = 0.0f;
            } else if (shouldBlock && arrow.m_36792_()) {
                amount = 2.0f;
            }
        } else if (tier == HorseArmorTier.AMETHYST) {
            amount = arrow.m_36792_() ? 2.0f : 0.0f;
        }
        return amount;
    }

    public void setDisobedienceTimer(int timeInTicks) {
        this.disobedienceTimer = timeInTicks;
    }

    public void disobey() {
        ActionBehavior.Action action;
        ActionBehavior.Action action2 = action = this.m_217043_().m_188500_() > 0.5 ? ActionBehavior.Action.BUCK : ActionBehavior.Action.REAR;
        if (this.m_9236_().f_46443_) {
            SWEMPackets.sendToServer(new ServerboundHorseActionPacket(this.m_20148_(), action));
        } else {
            this.getBehavior(ActionBehavior.class).startAction(action);
        }
        this.setDisobedienceTimer(142);
    }

    public boolean isBlanket(ItemStack stack) {
        TackItem tack;
        Item item = stack.m_41720_();
        return item instanceof TackItem && (tack = (TackItem)item).getType() == TackType.BLANKET;
    }

    public ItemStack getBlanket() {
        return this.f_30520_.m_8020_(1);
    }

    public boolean isSaddle(ItemStack stack) {
        return TackType.SADDLE.is(stack);
    }

    public boolean hasSaddleBag() {
        return !this.getSaddleBag().m_41619_();
    }

    public float getJumpHeight() {
        float jumpStrength = (float)this.m_30626_();
        return (float)(-0.1817584952 * (double)((float)Math.pow(jumpStrength, 3.0)) + 3.689713992 * (double)((float)Math.pow(jumpStrength, 2.0)) + 2.128599134 * (double)jumpStrength - 0.343930367);
    }

    public Component getOwnerDisplayName() {
        UUID playerUUID = this.m_21805_();
        if (playerUUID == null) {
            return Component.m_237115_((String)"Not owned.");
        }
        Player owner = this.m_9236_().m_46003_(playerUUID);
        if (owner == null) {
            ModRef.LOGGER.error("Getting the owner display name failed.");
            return Component.m_237113_((String)"Something went wrong.");
        }
        return owner.m_5446_();
    }

    public Vec3 m_7939_() {
        return super.m_7939_().m_82520_(0.0, 0.0, (double)this.m_20205_() * 0.7);
    }

    protected boolean isBeingMovedByPlayer() {
        return (Boolean)this.m_20088_().m_135370_(IS_MOVING_FORWARD) != false || (Boolean)this.m_20088_().m_135370_(IS_MOVING_BACKWARDS) != false || (Boolean)this.m_20088_().m_135370_(IS_MOVING_LEFT) != false || (Boolean)this.m_20088_().m_135370_(IS_MOVING_RIGHT) != false;
    }

    public boolean canToggleIceEffect() {
        return this.getArmorTier().is(HorseArmorTier.GOLD);
    }

    public void toggleIceEffect() {
        if (!this.canToggleIceEffect()) {
            this.getControllingPlayer().m_5661_((Component)Component.m_237115_((String)"text.swem.status.generic.can_not_do_that"), true);
            return;
        }
        if (this.isIceEffectActive) {
            this.getControllingPlayer().m_5661_((Component)Component.m_237115_((String)"text.swem.horse.ice.off"), true);
        } else {
            this.getControllingPlayer().m_5661_((Component)Component.m_237115_((String)"text.swem.horse.ice.on"), true);
        }
        this.isIceEffectActive = !this.isIceEffectActive;
    }

    public boolean canAttack() {
        TackItem bridle;
        TackItem blanket;
        TackItem girthStrap;
        TackItem saddle;
        Item item = this.getSaddle().m_41720_();
        return item instanceof TackItem && (saddle = (TackItem)item).getData().canWearArmor() && (item = this.getGirthStrap().m_41720_()) instanceof TackItem && (girthStrap = (TackItem)item).getData().canWearArmor() && (item = this.getBlanket().m_41720_()) instanceof TackItem && (blanket = (TackItem)item).getData().canWearArmor() && (item = this.getHalterOrBridle().m_41720_()) instanceof TackItem && (bridle = (TackItem)item).getData().canWearArmor();
    }

    public void executeBuck() {
        this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26883_(5.0), (LivingEntity)this, this.m_20191_().m_82400_(2.0)).forEach(entity -> {
            if (entity.m_20202_() != this) {
                entity.m_6469_(this.m_269291_().m_269264_(), 5.0f);
                entity.m_147240_(0.5, 0.5, 0.5);
            }
        });
    }

    public boolean canBite() {
        return !this.getBehavior(ActionBehavior.class).hasActiveAction() && this.canAttack() && this.getGait() == Gait.WALK;
    }

    public boolean isBiting() {
        return this.getBehavior(ActionBehavior.class).getActiveAction() == ActionBehavior.Action.BITE;
    }

    public void startBite() {
        if (this.canBite() && this.progressionManager.getAffinityLeveling().getLevel() >= 7) {
            this.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.BITE);
        } else {
            ((ServerPlayer)this.m_20197_().get(0)).m_5661_((Component)Component.m_237115_((String)"text.swem.status.generic.can_not_do_that"), true);
            this.setGait(Gait.WALK);
        }
    }

    public void executeBite() {
        Vec3 positionVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        AABB biteBox = new AABB(positionVec, positionVec).m_82363_(0.0, 2.0, 0.0).m_82377_(0.75, 0.0, 0.75);
        biteBox = biteBox.m_82386_((double)this.m_20205_() * 1.5 * this.m_20154_().m_82541_().m_7096_(), 0.0, (double)this.m_20205_() * 1.5 * this.m_20154_().m_82541_().m_7094_());
        List attackableEntities = this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, biteBox);
        Collections.shuffle(attackableEntities);
        if (!attackableEntities.isEmpty()) {
            LivingEntity entityToAttack = (LivingEntity)attackableEntities.get(0);
            entityToAttack.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 4.0f);
        }
    }

    public boolean canKick() {
        return !this.getBehavior(ActionBehavior.class).hasActiveAction() && this.canAttack() && this.getGait() == Gait.WALK;
    }

    public boolean isKicking() {
        return this.getBehavior(ActionBehavior.class).getActiveAction() == ActionBehavior.Action.KICK;
    }

    public void startKick() {
        if (this.canKick() && this.progressionManager.getAffinityLeveling().getLevel() >= 8) {
            this.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.KICK);
        } else {
            if (!this.m_20197_().isEmpty()) {
                ((ServerPlayer)this.m_20197_().get(0)).m_5661_((Component)Component.m_237115_((String)"text.swem.status.generic.can_not_do_that"), true);
            }
            this.setGait(Gait.WALK);
        }
    }

    public void executeKick() {
        Vec3 positionVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        AABB kickBox = new AABB(positionVec, positionVec).m_82363_(0.0, 2.0, 0.0).m_82377_(0.75, 0.01, 0.75);
        kickBox = kickBox.m_82386_((double)(this.m_20205_() * 1.0f) * this.m_20154_().m_82548_().m_82541_().m_7096_(), 0.0, (double)(this.m_20205_() * 1.0f) * this.m_20154_().m_82548_().m_82541_().m_7094_());
        List attackableEntities = this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, kickBox);
        Collections.shuffle(attackableEntities);
        if (!attackableEntities.isEmpty()) {
            LivingEntity entityToAttack = (LivingEntity)attackableEntities.get(0);
            entityToAttack.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
        }
    }

    public boolean canStomp() {
        return !this.getBehavior(ActionBehavior.class).hasActiveAction() && this.canAttack() && this.getGait() == Gait.WALK;
    }

    public boolean isStomping() {
        return this.getBehavior(ActionBehavior.class).getActiveAction() == ActionBehavior.Action.STOMP;
    }

    public void startStomp() {
        if (this.canStomp() && this.progressionManager.getAffinityLeveling().getLevel() >= 9) {
            this.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.STOMP);
        } else {
            ((ServerPlayer)this.m_20197_().get(0)).m_5661_((Component)Component.m_237115_((String)"text.swem.status.generic.can_not_do_that"), true);
            this.setGait(Gait.WALK);
        }
    }

    public void executeStomp() {
        AABB stompBox = this.m_20191_().m_82377_(2.0, 0.0, 2.0).m_82363_(0.0, -1.0, 0.0);
        this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, stompBox).forEach(entityToKnockback -> {
            double d1 = this.m_20185_() - entityToKnockback.m_20185_();
            double d0 = this.m_20189_() - entityToKnockback.m_20189_();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            entityToKnockback.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f);
            entityToKnockback.m_147240_(1.0, d1, d0);
        });
    }

    public boolean canEat() {
        return !this.m_6162_() && !this.m_20160_() && !this.m_21523_() && !this.isBridleLeashed() && !this.hasBridle() && TimeUtil.isEatingTime(this.m_9236_().m_46468_());
    }

    public boolean canDrink() {
        return !this.m_6162_() && !this.m_20160_() && !this.m_21523_() && !this.hasBridle() && this.needs.getThirst().canDrink();
    }

    public boolean m_5803_() {
        return this.getBehavior(SleepingBehavior.class).isActuallySleeping();
    }

    public void setTotalTimesFed(int amount) {
        this.m_20088_().m_135381_(TOTAL_TIMES_FED, (Object)amount);
    }

    public int getTotalTimesFed() {
        return (Integer)this.m_20088_().m_135370_(TOTAL_TIMES_FED);
    }

    public void addJumpModifier(String name, double debuff) {
        AttributeInstance attr = this.m_21051_(Attributes.f_22288_);
        attr.m_22125_(new AttributeModifier(name, -debuff, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public void addSpeedModifier(String name, double debuff) {
        AttributeInstance attr = this.m_21051_(Attributes.f_22279_);
        attr.m_22125_(new AttributeModifier(name, -debuff, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public <T extends IBehavior> T getBehavior(Class<T> clazz) {
        return this.behaviorManager.getBehavior(clazz);
    }

    public boolean hasEatenSpecialFeed(SpecialFeedItem feed) {
        return this.eatenSpecialFeeds.contains(feed.getId());
    }

    public void addSpecialFeedToList(ResourceLocation id) {
        this.eatenSpecialFeeds.add(id);
    }

    public BreedingBehavior getBreeding() {
        return this.getBehavior(BreedingBehavior.class);
    }

    public void setHome(Level pLevel, BlockPos pPos) {
        this.m_20088_().m_135381_(HOME, Optional.of(GlobalPos.m_122643_((ResourceKey)pLevel.m_46472_(), (BlockPos)pPos)));
    }

    public Component m_5446_() {
        if (!ClientConfig.showGenderIcons) {
            return super.m_5446_();
        }
        return this.getBreeding().addSymbol(super.m_5446_());
    }

    public GlobalPos getHome() {
        return ((Optional)this.m_20088_().m_135370_(HOME)).orElse(GlobalPos.m_122643_((ResourceKey)Level.f_46428_, (BlockPos)this.m_9236_().m_220360_()));
    }

    public boolean isInPanic() {
        return this.panicGoal.m_25703_();
    }

    public boolean isVisuallySad() {
        return (Boolean)this.m_20088_().m_135370_(RRP_SAD) != false || (Boolean)this.m_20088_().m_135370_(IS_SAD) != false;
    }

    public static enum Gait {
        WALK(0, new AttributeModifier("WALK", 0.0, AttributeModifier.Operation.ADDITION), 0.05f, "Walk", "horse.swem.gait.walk", horse -> horse.isVisuallySad() ? HorseAnimations.SAD_WALK : HorseAnimations.WALK),
        TROT(1, new AttributeModifier("TROT", 0.0, AttributeModifier.Operation.ADDITION), 0.1f, "Trot", "horse.swem.gait.trot", horse -> HorseAnimations.TROT),
        CANTER(2, new AttributeModifier("CANTER", 0.0, AttributeModifier.Operation.ADDITION), 0.5f, "Canter", "horse.swem.gait.canter", horse -> HorseAnimations.CANTER),
        CANTER_EXT(3, new AttributeModifier("CANTER_EXT", 0.0, AttributeModifier.Operation.ADDITION), 0.8f, "Extended Canter", "horse.swem.gait.extended_canter", horse -> HorseAnimations.EXTENDED_CANTER),
        GALLOP(4, new AttributeModifier("GALLOP", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL), 1.0f, "Gallop", "horse.swem.gait.gallop", horse -> HorseAnimations.GALLOP);

        private final int gaitId;
        private final AttributeModifier modifier;
        private final float skillMultiplier;
        private final String text;
        private final String translationKey;
        private final Function<SWEMHorseEntityBase, RawAnimation> animation;

        private Gait(int gaitId, AttributeModifier modifier, float skillMultiplier, String text, String translationKey, Function<SWEMHorseEntityBase, RawAnimation> animation) {
            this.gaitId = gaitId;
            this.modifier = modifier;
            this.skillMultiplier = skillMultiplier;
            this.text = text;
            this.translationKey = translationKey;
            this.animation = animation;
        }

        public static Gait fromId(int gaitId) {
            for (Gait gait : Gait.values()) {
                if (gait.gaitId != gaitId) continue;
                return gait;
            }
            throw new IllegalArgumentException("Invalid gait id " + gaitId);
        }

        public RawAnimation getAnimation(SWEMHorseEntityBase horse) {
            return this.animation.apply(horse);
        }

        public AttributeModifier getModifier() {
            return this.modifier;
        }

        public int getGaitId() {
            return this.gaitId;
        }

        public float getSkillMultiplier() {
            return this.skillMultiplier;
        }

        public String getText() {
            return this.text;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static enum RidingPermission {
        NONE,
        TRUST,
        ALL;

    }

    public static class SWEMHorseData
    extends AgeableMob.AgeableMobGroupData {
        public final HorseCoat coat;

        public SWEMHorseData(HorseCoat coat) {
            super(0.05f);
            this.coat = coat;
        }
    }
}

