/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.behaviors;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.IBehavior;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BehaviorManager
implements Iterable<IBehavior> {
    private final SWEMHorseEntityBase horse;
    private final Map<ResourceLocation, IBehavior> behaviors = new HashMap<ResourceLocation, IBehavior>();
    private final Map<Class<?>, IBehavior> behaviorsByClass = new HashMap();

    public BehaviorManager(SWEMHorseEntityBase horse) {
        this.horse = horse;
    }

    public void add(IBehavior behavior) {
        this.behaviors.put(behavior.getId(), behavior);
        this.behaviorsByClass.put(behavior.getClass(), behavior);
    }

    public CompoundTag save(CompoundTag tag) {
        ListTag behaviorTags = new ListTag();
        this.behaviors.forEach((? super K id, ? super V behavior) -> {
            CompoundTag behaviorTag = new CompoundTag();
            behaviorTag.m_128359_("Id", id.toString());
            behavior.save(behaviorTag);
            behaviorTags.add((Object)behaviorTag);
        });
        tag.m_128365_("Behaviors", (Tag)behaviorTags);
        return tag;
    }

    public void deserialize(CompoundTag tag) {
        ListTag behaviorTags = tag.m_128437_("Behaviors", 10);
        behaviorTags.forEach(baseTag -> {
            if (!(baseTag instanceof CompoundTag)) {
                return;
            }
            CompoundTag behaviorTag = (CompoundTag)baseTag;
            ResourceLocation id = new ResourceLocation(behaviorTag.m_128461_("Id"));
            if (this.behaviors.containsKey(id)) {
                this.behaviors.get(id).load(behaviorTag);
            }
        });
    }

    public <T extends IBehavior> T getBehavior(Class<T> clazz) {
        return (T)this.behaviorsByClass.get(clazz);
    }

    public void defineData(SynchedEntityData dataManager) {
        this.behaviors.values().forEach(behavior -> behavior.defineData(dataManager));
    }

    @Override
    @NotNull
    public Iterator<IBehavior> iterator() {
        return ImmutableSet.copyOf(this.behaviors.values()).iterator();
    }
}

