/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.behaviors.impl;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.AbstractBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;

public class LayingBehavior
extends AbstractBehavior {
    public static final ResourceLocation ID = ModRef.res("laying");
    public static final EntityDataAccessor<Boolean> VISUAL_LAYING_DOWN = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_LAYING_DOWN = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);

    public LayingBehavior(SWEMHorseEntityBase horse) {
        super(ID, horse);
    }

    private void triggerAnimation(boolean isLayingDown) {
        if (this.isVisuallyLayingDown() != isLayingDown) {
            this.horse.triggerAnim("horse", isLayingDown ? HorseAnimations.Keys.LAYING_DOWN : HorseAnimations.Keys.GETTING_UP);
        }
    }

    public void setLayingDown(boolean isLayingDown) {
        this.triggerAnimation(isLayingDown);
        this.setData(IS_LAYING_DOWN, isLayingDown);
    }

    public void setVisualLayingDown(boolean isLayingDown) {
        this.triggerAnimation(isLayingDown);
        this.setData(VISUAL_LAYING_DOWN, isLayingDown);
    }

    public boolean isActuallyLayingDown() {
        return this.getData(IS_LAYING_DOWN);
    }

    public boolean isVisuallyLayingDown() {
        return this.getData(VISUAL_LAYING_DOWN) != false || this.getData(IS_LAYING_DOWN) != false;
    }

    @Override
    public void defineData(SynchedEntityData dataManager) {
        dataManager.m_135372_(IS_LAYING_DOWN, (Object)false);
        dataManager.m_135372_(VISUAL_LAYING_DOWN, (Object)false);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
    }
}

