/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.coats;

import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseColor;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public final class HorseCoat {
    private ResourceLocation id;
    private final Map<HorseModelType, ResourceLocation> models;
    private final String credits;
    private final String inspiration;
    @SerializedName(value="lapis_cyclable")
    private final boolean lapisCyclable;
    @SerializedName(value="obtainable_by_breeding")
    private final boolean obtainableByBreeding;
    @SerializedName(value="base_colors")
    private final List<HorseColor> baseColors;
    private final boolean hasWings;

    public HorseCoat(ResourceLocation id, Map<HorseModelType, ResourceLocation> models, String credits, String inspiration, boolean lapisCyclable, boolean obtainableByBreeding, List<HorseColor> baseColors, boolean hasWings) {
        this.id = id;
        this.models = models;
        this.credits = credits;
        this.inspiration = inspiration;
        this.lapisCyclable = lapisCyclable;
        this.obtainableByBreeding = obtainableByBreeding;
        this.baseColors = baseColors;
        this.hasWings = hasWings;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public boolean isBlacklisted() {
        return ((List)ServerConfig.BLACKLISTED_COAT_IDS.get()).contains(this.id().toString());
    }

    public ResourceLocation modelTexture(HorseModelType model) {
        return this.models.get((Object)model);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResourceLocation id() {
        return this.id;
    }

    public String credits() {
        return this.credits;
    }

    public String inspiration() {
        return this.inspiration;
    }

    public boolean lapisCyclable() {
        return this.lapisCyclable;
    }

    public boolean obtainableByBreeding() {
        return this.obtainableByBreeding;
    }

    public List<HorseColor> baseColors() {
        return this.baseColors;
    }

    public boolean hasWings() {
        return this.hasWings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HorseCoat that = (HorseCoat)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.models, that.models) && Objects.equals(this.credits, that.credits) && Objects.equals(this.inspiration, that.inspiration) && this.lapisCyclable == that.lapisCyclable && this.obtainableByBreeding == that.obtainableByBreeding && Objects.equals(this.baseColors, that.baseColors);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.models, this.credits, this.inspiration, this.lapisCyclable, this.obtainableByBreeding, this.baseColors);
    }

    public String toString() {
        return "HorseCoat[id=" + this.id + ", models=" + this.models + ", credits=" + this.credits + ", inspiration=" + this.inspiration + ", lapisCyclable=" + this.lapisCyclable + ", obtainableByBreeding=" + this.obtainableByBreeding + ", baseColors=" + this.baseColors + ", renderWings=" + this.hasWings + "]";
    }

    public static class Builder {
        private Map<HorseModelType, ResourceLocation> models = new HashMap<HorseModelType, ResourceLocation>();
        private String credits;
        private String inspiration;
        private boolean lapisCyclable;
        private boolean obtainableByBreeding;
        private List<HorseColor> baseColors = new ArrayList<HorseColor>();
        private boolean renderWings = false;

        Builder() {
        }

        public Builder model(String type, ResourceLocation texture) {
            return this.model(HorseModelType.fromName(type), texture);
        }

        public Builder model(HorseModelType type, ResourceLocation texture) {
            this.models.put(type, texture);
            return this;
        }

        public Builder credits(String credits) {
            this.credits = credits;
            return this;
        }

        public Builder inspiration(String inspiration) {
            this.inspiration = inspiration;
            return this;
        }

        public Builder lapisCyclable() {
            this.lapisCyclable = true;
            return this;
        }

        public Builder obtainableByBreeding() {
            this.obtainableByBreeding = true;
            return this;
        }

        public Builder baseColors(HorseColor ... baseColors) {
            this.baseColors.addAll(Arrays.asList(baseColors));
            return this;
        }

        public Builder renderWings() {
            this.renderWings = true;
            return this;
        }

        public HorseCoat build(ResourceLocation id) {
            return new HorseCoat(id, this.models, this.credits, this.inspiration, this.lapisCyclable, this.obtainableByBreeding, this.baseColors, this.renderWings);
        }
    }
}

