/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.needs;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedBlock;
import com.google.common.collect.Sets;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FeedItem {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final Category category;
    private final int pointsGiven;
    private final int maxPerDay;
    private final boolean horseyMustHaveYumYum;
    private final BiConsumer<SWEMHorseEntityBase, Boolean> onEaten;

    public FeedItem(ResourceLocation id, Ingredient ingredient, Category category, int pointsGiven, int maxPerDay, boolean horseyMustHaveYumYum, BiConsumer<SWEMHorseEntityBase, Boolean> onEaten) {
        this.id = id;
        this.ingredient = ingredient;
        this.category = category;
        this.pointsGiven = pointsGiven;
        this.maxPerDay = maxPerDay;
        this.horseyMustHaveYumYum = horseyMustHaveYumYum;
        this.onEaten = onEaten;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public Ingredient ingredient() {
        return this.ingredient;
    }

    public Category category() {
        return this.category;
    }

    public int pointsGiven() {
        return this.pointsGiven;
    }

    public int maxPerDay() {
        return this.maxPerDay;
    }

    public int getPointsForState(BlockState state) {
        return this.pointsGiven();
    }

    public boolean horseyMustHaveYumYum() {
        return this.horseyMustHaveYumYum;
    }

    public BiConsumer<SWEMHorseEntityBase, Boolean> onEaten() {
        return this.onEaten;
    }

    public static Builder builder(Ingredient ingredient, Category category) {
        return new Builder(ingredient, category);
    }

    public static enum Category {
        TREATS(100, 13),
        GRAINS(50, 112),
        GRASS_FEED(0, 224);

        public final int priority;
        public final int pointLimit;

        private Category(int priority, int pointLimit) {
            this.priority = priority;
            this.pointLimit = pointLimit;
        }
    }

    public static class Builder {
        private final Ingredient ingredient;
        private final Category category;
        private int pointsGiven = 1;
        private int maxPerDay = 1;
        private boolean horseyMustHaveYumYum;
        private BiConsumer<SWEMHorseEntityBase, Boolean> onEaten = (horse, limited) -> {};
        private Function<BlockState, Integer> pointsForState = state -> this.pointsGiven;

        private Builder(Ingredient ingredient, Category category) {
            this.ingredient = ingredient;
            this.category = category;
        }

        public Builder points(int points) {
            this.pointsGiven = points;
            return this;
        }

        public Builder blockPoints(Function<BlockState, Integer> points) {
            this.pointsForState = points;
            return this;
        }

        public Builder max(int max) {
            this.maxPerDay = max;
            return this;
        }

        public Builder onEaten(BiConsumer<SWEMHorseEntityBase, Boolean> onEaten) {
            this.onEaten = onEaten;
            return this;
        }

        public Builder yumYumForHorseys() {
            this.horseyMustHaveYumYum = true;
            return this;
        }

        FeedItem build(String id) {
            return this.build(ModRef.res(id));
        }

        public FeedItem build(ResourceLocation id) {
            return new FeedItem(id, this.ingredient, this.category, this.pointsGiven, this.maxPerDay, this.horseyMustHaveYumYum, this.onEaten);
        }

        public FeedBlock buildBlock(ResourceLocation id, Function<BlockState, BlockState> eatenBlock, Block ... blocks) {
            return new FeedBlock(id, Sets.newHashSet((Object[])blocks), eatenBlock, this.ingredient, this.category, this.pointsGiven, this.maxPerDay, this.horseyMustHaveYumYum, this.onEaten, this.pointsForState);
        }

        FeedBlock buildBlock(String id, Function<BlockState, BlockState> eatenBlock, Block ... blocks) {
            return this.buildBlock(ModRef.res(id), eatenBlock, blocks);
        }
    }
}

