/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.needs;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedBlock;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedItem;
import com.alaharranhonor.swem.forge.entities.horse.needs.SpecialFeedItem;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class Feeds {
    private static final Map<ResourceLocation, FeedItem> ALL_FEEDS = new HashMap<ResourceLocation, FeedItem>();
    private static final Map<Block, FeedBlock> BLOCK_FEEDS = new HashMap<Block, FeedBlock>();
    private static final Map<ResourceLocation, SpecialFeedItem> SPECIAL_FEEDS = new HashMap<ResourceLocation, SpecialFeedItem>();
    public static final FeedItem BAMBOO = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41911_}), FeedItem.Category.TREATS).points(3).max(7).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(1.0f);
        }
    }).build("bamboo"));
    public static final FeedItem BEETROOT = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42732_}), FeedItem.Category.TREATS).points(3).max(7).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(1.0f);
        }
    }).build("beetroot"));
    public static final FeedItem CARROT = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_}), FeedItem.Category.TREATS).points(5).max(5).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(2.0f);
        }
    }).build("carrot"));
    public static final FeedItem SUGAR_CUBE = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.SUGAR_CUBE.get()}), FeedItem.Category.TREATS).points(5).max(5).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(2.0f);
        }
    }).build("sugar_cube"));
    public static final FeedItem MELON_SLICE = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42575_}), FeedItem.Category.TREATS).points(5).max(5).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(2.0f);
        }
    }).build("melon_slice"));
    public static final FeedItem SWEET_BERRIES = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_}), FeedItem.Category.TREATS).points(7).max(3).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(3.0f);
        }
    }).build("sweet_berries"));
    public static final FeedItem HONEY = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42787_}), FeedItem.Category.TREATS).points(7).max(3).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(3.0f);
        }
    }).build("honey"));
    public static final FeedItem APPLE = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_}), FeedItem.Category.TREATS).points(7).max(3).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(3.0f);
        }
    }).build("apple"));
    public static final FeedItem HONEYCOMB = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42784_}), FeedItem.Category.TREATS).points(11).max(2).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(5.0f);
        }
    }).build("honeycomb"));
    public static final FeedBlock PUMPKIN = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42046_}), FeedItem.Category.TREATS).points(11).max(2).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(5.0f);
        }
    }).buildBlock("pumpkin", state -> Blocks.f_50016_.m_49966_(), Blocks.f_50133_));
    public static final FeedBlock MELON = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42028_}), FeedItem.Category.TREATS).points(11).max(2).onEaten((horse, limited) -> {
        if (!limited.booleanValue()) {
            horse.progressionManager.getAffinityLeveling().addXP(5.0f);
        }
    }).buildBlock("melon", state -> Blocks.f_50016_.m_49966_(), Blocks.f_50186_));
    public static final FeedItem WHEAT = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), FeedItem.Category.GRASS_FEED).points(0).max(1).build("wheat"));
    public static final FeedItem HAY_BALE = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42129_}), FeedItem.Category.GRASS_FEED).points(0).max(1).build("hay_bale"));
    public static final FeedItem RED_MUSHROOM = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41953_}), FeedItem.Category.GRASS_FEED).points(10).max(20).build("red_mushroom"));
    public static final FeedBlock FOLIAGE = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50440_, Blocks.f_50034_, Blocks.f_50072_, Blocks.f_50359_}), FeedItem.Category.GRASS_FEED).points(2).max(Integer.MAX_VALUE).buildBlock("foliage", state -> {
        if (state.m_60713_(Blocks.f_50440_)) {
            return Blocks.f_50493_.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }, Blocks.f_50440_, Blocks.f_50034_, Blocks.f_50072_, Blocks.f_50359_));
    public static final FeedItem OAT_BUSHEL = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.OAT_BUSHEL.get()}), FeedItem.Category.GRASS_FEED).points(10).max(5).build("oat_bushel"));
    public static final FeedItem TIMOTHY_BUSHEL = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.TIMOTHY_BUSHEL.get()}), FeedItem.Category.GRASS_FEED).points(14).max(5).build("timothy_bushel"));
    public static final FeedItem ALFALFA_BUSHEL = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.ALFALFA_BUSHEL.get()}), FeedItem.Category.GRASS_FEED).points(14).max(5).build("alfalfa_bushel"));
    public static final FeedBlock TIMOTHY_BALE = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockSetup.TIMOTHY_BALE.get()}), FeedItem.Category.GRASS_FEED).points(56).blockPoints(state -> 28).max(3).buildBlock("timothy_bale", state -> ((Block)BlockSetup.TIMOTHY_BALE_SLAB.get()).m_49966_(), (Block)BlockSetup.TIMOTHY_BALE.get()));
    public static final FeedBlock TIMOTHY_BALE_SLAB = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockSetup.TIMOTHY_BALE_SLAB.get()}), FeedItem.Category.GRASS_FEED).points(28).max(4).buildBlock("timothy_bale_slab", Feeds::eatSlab, (Block)BlockSetup.TIMOTHY_BALE_SLAB.get()));
    public static final FeedBlock ALFALFA_BALE = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockSetup.ALFALFA_BALE.get()}), FeedItem.Category.GRASS_FEED).points(56).blockPoints(state -> 28).max(3).buildBlock("alfalfa_bale", state -> ((Block)BlockSetup.ALFALFA_BALE_SLAB.get()).m_49966_(), (Block)BlockSetup.ALFALFA_BALE.get()));
    public static final FeedBlock ALFALFA_BALE_SLAB = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockSetup.ALFALFA_BALE_SLAB.get()}), FeedItem.Category.GRASS_FEED).points(28).max(4).buildBlock("alfalfa_bale_slab", Feeds::eatSlab, (Block)BlockSetup.ALFALFA_BALE_SLAB.get()));
    public static final FeedBlock QUALITY_BALE = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockSetup.QUALITY_BALE.get()}), FeedItem.Category.GRASS_FEED).points(224).blockPoints(state -> 112).max(2).buildBlock("quality_bale", state -> ((Block)BlockSetup.QUALITY_BALE_SLAB.get()).m_49966_(), (Block)BlockSetup.QUALITY_BALE.get()));
    public static final FeedBlock QUALITY_BALE_SLAB = Feeds.registerBlockFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockSetup.QUALITY_BALE_SLAB.get()}), FeedItem.Category.GRASS_FEED).points(112).max(3).buildBlock("quality_bale_slab", Feeds::eatSlab, (Block)BlockSetup.QUALITY_BALE_SLAB.get()));
    public static final FeedItem SWEET_FEED = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.SWEET_FEED_OPENED.get(), (ItemLike)ItemSetup.SCOOP_FEED_SWEET.get()}), FeedItem.Category.GRAINS).points(112).max(3).yumYumForHorseys().build("feed_sweet"));
    public static final FeedItem ROSE_FEED = Feeds.registerItemFeed(FeedItem.builder(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemSetup.FEED_ROSE_OPENED.get(), (ItemLike)ItemSetup.SCOOP_FEED_ROSE.get()}), FeedItem.Category.GRAINS).points(112).max(3).build("feed_rose"));
    public static final SpecialFeedItem GOLDEN_APPLE = Feeds.registerSpecialFeed("golden_apple", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_})).setOnEaten(horse -> Feeds.healAndAffinity(horse, 2000));
    public static final SpecialFeedItem ENCHANTED_GOLDEN_APPLE = Feeds.registerSpecialFeed("enchanted_golden_apple", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42437_})).setOnEaten(horse -> Feeds.healAndAffinity(horse, 5000));
    public static final SpecialFeedItem GOLDEN_CARROT = Feeds.registerSpecialFeed("golden_carrot", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42677_})).setOnEaten(horse -> Feeds.healAndAffinity(horse, 1000));
    public static final SpecialFeedItem GLISTERING_MELON = Feeds.registerSpecialFeed("glistering_melon", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42546_})).setOnEaten(horse -> Feeds.healAndAffinity(horse, 1000));

    public static FeedItem registerItemFeed(FeedItem feed) {
        ALL_FEEDS.put(feed.id(), feed);
        return feed;
    }

    public static FeedBlock registerBlockFeed(FeedBlock feed) {
        ALL_FEEDS.put(feed.id(), feed);
        for (Block block : feed.blocks()) {
            BLOCK_FEEDS.put(block, feed);
        }
        return feed;
    }

    public static SpecialFeedItem registerSpecialFeed(String name, Ingredient itemTester) {
        ResourceLocation id = ModRef.res(name);
        SpecialFeedItem feed = new SpecialFeedItem(id, itemTester);
        SPECIAL_FEEDS.put(id, feed);
        return feed;
    }

    public static FeedItem fromItem(ItemStack stack) {
        for (FeedItem feed : ALL_FEEDS.values()) {
            if (!feed.ingredient().test(stack)) continue;
            return feed;
        }
        return null;
    }

    public static SpecialFeedItem getSpecialFeed(ItemStack stack) {
        for (SpecialFeedItem feed : SPECIAL_FEEDS.values()) {
            if (!feed.test(stack)) continue;
            return feed;
        }
        return null;
    }

    public static FeedBlock fromBlock(Block block) {
        return BLOCK_FEEDS.get(block);
    }

    private static BlockState eatSlab(BlockState state) {
        if (state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
            return (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
        }
        return Blocks.f_50016_.m_49966_();
    }

    private static void healAndAffinity(SWEMHorseEntityBase horse, int affinityXp) {
        horse.m_21153_(horse.m_21233_());
        horse.progressionManager.getAffinityLeveling().addXP(affinityXp);
    }
}

