/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.registry.ParticleSetup;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class WhistleItem
extends Item {
    public WhistleItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level pLevel, Entity entity, int slot, boolean isSelected) {
        if (!(pLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)pLevel;
        CompoundTag boundTag = stack.m_41737_("Bound");
        if (boundTag == null) {
            return;
        }
        UUID horseId = boundTag.m_128342_("HorseId");
        Entity entity2 = level.m_8791_(horseId);
        if (!(entity2 instanceof SWEMHorseEntityBase)) {
            return;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity2;
        boundTag.m_128359_("HorseName", Component.Serializer.m_130703_((Component)horse.m_7755_()));
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int remainder) {
        if (level.m_5776_()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Pair<Boolean, SWEMHorseEntityBase> bind = WhistleItem.getBoundHorse(level, stack);
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)bind.getB();
        if (horse == null || !horse.isOwner(player)) {
            return;
        }
        if (!horse.m_20183_().m_123314_((Vec3i)player.m_20183_(), 100.0)) {
            return;
        }
        horse.onPlayerWhistle(player, this.getWhistleSpeed(this.m_8105_(stack) - remainder));
        player.m_36335_().m_41524_((Item)this, 40);
        level.m_7106_((ParticleOptions)ParticleSetup.YAY.get(), horse.m_20185_(), horse.m_20186_(), horse.m_20189_(), 20.0, 0.0, 0.0);
    }

    public SWEMHorseEntityBase.Gait getWhistleSpeed(int whistleTime) {
        if (whistleTime == 40) {
            return SWEMHorseEntityBase.Gait.CANTER_EXT;
        }
        if (whistleTime > 20) {
            return SWEMHorseEntityBase.Gait.CANTER;
        }
        return SWEMHorseEntityBase.Gait.TROT;
    }

    public int m_8105_(ItemStack pStack) {
        return 40;
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        pLivingEntity.m_21253_();
        return pStack;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        ItemStack stack = pContext.m_43722_();
        Level level = pContext.m_43725_();
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Pair<Boolean, SWEMHorseEntityBase> bind = WhistleItem.getBoundHorse(level, stack);
        if (!((Boolean)bind.getA()).booleanValue()) {
            player.m_213846_((Component)Component.m_237113_((String)"Whistle is not bound to a SWEM Horse"));
            return InteractionResult.FAIL;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)bind.getB();
        Component horseName = WhistleItem.getBoundHorseName(level, stack);
        if (horse == null || !horse.m_20183_().m_123314_((Vec3i)player.m_20183_(), 100.0)) {
            player.m_213846_((Component)Component.m_237119_().m_7220_(horseName).m_7220_((Component)Component.m_237113_((String)" did not hear the whistle.")));
            return InteractionResult.FAIL;
        }
        BlockPos markedHome = pContext.m_8083_().m_121945_(pContext.m_43719_());
        player.m_213846_((Component)Component.m_237113_((String)"You have marked a new home for ").m_7220_(horseName));
        if (!level.m_5776_()) {
            horse.setHome(pContext.m_43725_(), markedHome);
        }
        CompoundTag tag = stack.m_41737_("Bound");
        CompoundTag homeTag = new CompoundTag();
        homeTag.m_128359_("Dimension", level.m_46472_().m_135782_().toString());
        homeTag.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)markedHome));
        tag.m_128365_("Home", (Tag)homeTag);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public static Pair<Boolean, SWEMHorseEntityBase> getBoundHorse(Level level, ItemStack stack) {
        CompoundTag boundTag = stack.m_41737_("Bound");
        if (boundTag == null) {
            return new Pair((Object)false, null);
        }
        UUID horseId = boundTag.m_128342_("HorseId");
        return new Pair((Object)true, (Object)((SWEMHorseEntityBase)((ServerLevel)level).m_8791_(horseId)));
    }

    public static Component getBoundHorseName(Level level, ItemStack stack) {
        CompoundTag boundTag = stack.m_41737_("Bound");
        if (boundTag == null) {
            return null;
        }
        return Component.Serializer.m_130701_((String)boundTag.m_128461_("HorseName"));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!(target instanceof SWEMHorseEntityBase)) {
            return InteractionResult.PASS;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)target;
        if (playerIn.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        UUID horseOwnerId = horse.m_21805_();
        UUID playerId = playerIn.m_20148_();
        if (!Objects.equals(playerId, horseOwnerId)) {
            playerIn.m_213846_((Component)Component.m_237113_((String)"You are not the owner."));
            return InteractionResult.FAIL;
        }
        CompoundTag boundTag = new CompoundTag();
        boundTag.m_128362_("HorseId", horse.m_20148_());
        boundTag.m_128359_("HorseName", Component.Serializer.m_130703_((Component)horse.m_7755_()));
        stack.m_41700_("Bound", (Tag)boundTag);
        return InteractionResult.m_19078_((boolean)playerIn.m_9236_().m_5776_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        CompoundTag boundTag = stack.m_41737_("Bound");
        if (boundTag == null) {
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)"Bound to ").m_7220_((Component)Component.Serializer.m_130701_((String)boundTag.m_128461_("HorseName"))).m_130940_(ChatFormatting.GRAY));
        CompoundTag homeTag = boundTag.m_128469_("Home");
        if (level == null || homeTag == null) {
            return;
        }
        ResourceLocation dimension = new ResourceLocation(homeTag.m_128461_("Dimension"));
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)homeTag.m_128469_("Pos"));
        tooltip.add((Component)Component.m_237113_((String)"Home").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD));
        tooltip.add((Component)Component.m_237113_((String)"Dimension: ").m_7220_((Component)Component.m_237113_((String)dimension.toString())));
        tooltip.add((Component)Component.m_237113_((String)"Position: ").m_7220_((Component)Component.m_237113_((String)pos.toString())));
    }
}

