/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items.potions;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.BreedingBehavior;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GenderChangePotionItem
extends Item {
    private final GenderChangeType changeTo;

    public GenderChangePotionItem(GenderChangeType changeTo, Item.Properties pProperties) {
        super(pProperties);
        this.changeTo = changeTo;
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (!(pInteractionTarget instanceof SWEMHorseEntityBase)) {
            return InteractionResult.PASS;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)pInteractionTarget;
        BreedingBehavior breeding = horse.getBehavior(BreedingBehavior.class);
        if (breeding.isFemale() && this.changeTo == GenderChangeType.FEMALE || breeding.isMale() && this.changeTo == GenderChangeType.MALE) {
            return InteractionResult.FAIL;
        }
        if (!horse.isOwner(pPlayer) && !Keys.hasPermission(pPlayer, PermissionNodes.CAN_BREED)) {
            return InteractionResult.FAIL;
        }
        if (pPlayer.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Component oldGender = breeding.getName();
        boolean wasMale = breeding.isMale();
        boolean changeToFemale = this.changeTo == GenderChangeType.FEMALE || this.changeTo == GenderChangeType.RANDOM && (double)pInteractionTarget.m_217043_().m_188501_() > 0.49;
        breeding.setFemale(changeToFemale);
        if (!pPlayer.m_150110_().f_35937_) {
            pStack.m_41774_(1);
        }
        MutableComponent text = Component.m_237110_((String)"chat.swem.gender_potion.changed", (Object[])new Object[]{horse.m_5446_(), oldGender, breeding.getName()});
        pPlayer.m_5661_((Component)text, false);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pPlayer;
            String owner = horse.m_30614_() ? "(Owned by " + horse.getOwnerName() + ") " : "";
            player.f_8924_.m_213846_((Component)Component.m_237113_((String)(player.m_5446_().getString() + " changed " + horse.m_5446_().getString() + " " + owner + "from " + (wasMale ? "Male" : "Female") + " to " + (breeding.isFemale() ? "Female" : "Male"))));
        }
        return InteractionResult.CONSUME;
    }

    public static enum GenderChangeType {
        MALE,
        FEMALE,
        RANDOM;

    }
}

