/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.armor.GoldRidingBoots;
import com.alaharranhonor.swem.forge.container.CantazariteAnvilContainer;
import com.alaharranhonor.swem.forge.container.JumpContainer;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseAttackPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorsePermissionPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseSpeedPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseXPPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundIceTogglePacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundRenameItemPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.jumps.ServerboundJumpsActionPacket;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class ServerPacketHandler {
    public static void handleHorseXP(ServerboundHorseXPPacket packet, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            if (!horse.m_20148_().equals(packet.getEntityUUID())) {
                Entity tryingToLevel = player.m_284548_().m_8791_(packet.getEntityUUID());
                ModRef.LOGGER.warn("{} | {} is trying to add xp to a horse (\"{}\" {}) they don't ride on!", (Object)player.m_20149_(), (Object)player.m_5446_().toString(), tryingToLevel != null ? tryingToLevel.m_5446_() : "???", (Object)packet.getEntityUUID());
                return;
            }
            switch (packet.getSkillToIncrease()) {
                case JUMP: {
                    horse.progressionManager.getJumpLeveling().addXP(packet.getXpToAdd());
                    break;
                }
                case SPEED: {
                    horse.progressionManager.getSpeedLeveling().addXP(packet.getXpToAdd());
                    break;
                }
                case HEALTH: {
                    horse.progressionManager.getHealthLeveling().addXP(packet.getXpToAdd());
                    break;
                }
                case AFFINITY: {
                    horse.progressionManager.getAffinityLeveling().addXP(packet.getXpToAdd());
                    break;
                }
                default: {
                    ModRef.LOGGER.warn("{} | {} is trying to level invalid horse skill {} with amount: {}", (Object)player.m_20149_(), (Object)player.m_5446_().toString(), (Object)packet.getSkillToIncrease(), (Object)Float.valueOf(packet.getXpToAdd()));
                }
            }
        }
    }

    public static void handleHorseSpeedChange(ServerboundHorseSpeedPacket packet, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            if (!horse.m_20148_().equals(packet.getEntityUUID())) {
                Entity tryingToLevel = player.m_284548_().m_8791_(packet.getEntityUUID());
                ModRef.LOGGER.warn("{} | {} is trying to change speed of a horse (\"{}\" {}) they don't ride on!", (Object)player.m_20149_(), (Object)player.m_5446_().toString(), tryingToLevel != null ? tryingToLevel.m_5446_() : "???", (Object)packet.getEntityUUID());
                return;
            }
            switch (packet.getAction()) {
                case RESET: {
                    horse.setGait(SWEMHorseEntityBase.Gait.WALK);
                    break;
                }
                case INCREMENT: {
                    horse.incrementSpeed();
                    break;
                }
                case DECREMENT: {
                    horse.decrementSpeed();
                    break;
                }
                default: {
                    ModRef.LOGGER.warn("{} | {} is trying to change the speed of a horse ({} | {}) but did not provide a valid action", (Object)player.m_20149_(), (Object)player.m_5446_().toString(), (Object)horse.m_5446_(), (Object)horse.m_20148_());
                }
            }
        }
    }

    public static void handleHorseAction(ServerboundHorsePermissionPacket packet, NetworkEvent.Context ctx) {
        SWEMHorseEntityBase horse;
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Entity entity = player.m_284548_().m_8791_(packet.getEntityUUID());
        if (entity instanceof SWEMHorseEntityBase && (horse = (SWEMHorseEntityBase)entity).canAccessHorse((Player)player)) {
            switch (packet.getAction()) {
                case CYCLE_PERMISSION: {
                    horse.cycleRidingPermission();
                }
            }
        }
    }

    public static void handleRenameItem(ServerboundRenameItemPacket packet, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof CantazariteAnvilContainer) {
            CantazariteAnvilContainer anvilContainer = (CantazariteAnvilContainer)abstractContainerMenu;
            String s = SharedConstants.m_136190_((String)packet.getName());
            if (s.length() <= 50) {
                anvilContainer.setItemName(s);
            }
        }
    }

    public static void handleJumpsAction(ServerboundJumpsActionPacket packet, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof JumpContainer) {
            JumpContainer container = (JumpContainer)abstractContainerMenu;
            switch (packet.getAction()) {
                case ADD_LAYER: {
                    container.controller.addLayer();
                    break;
                }
                case REMOVE_LAYER: {
                    container.controller.deleteLayer();
                    break;
                }
                case DESTROY: {
                    container.controller.destroyJump();
                    break;
                }
                case CHANGE_STANDARD_FORWARDS: {
                    container.controller.changeStandardForward();
                    break;
                }
                case CHANGE_STANDARD_BACKWARDS: {
                    container.controller.changeStandardBackwards();
                    break;
                }
                case CHANGE_COLOR_FORWARD: {
                    container.controller.incrementColorVariant(packet.getLayerToEffect());
                    break;
                }
                case CHANGE_COLOR_BACKWARDS: {
                    container.controller.decrementColorVariant(packet.getLayerToEffect());
                    break;
                }
                case CHANGE_LAYER_FORWARDS: {
                    container.controller.changeLayerForward(packet.getLayerToEffect());
                    break;
                }
                case CHANGE_LAYER_BACKWARDS: {
                    container.controller.changeLayerBackwards(packet.getLayerToEffect());
                }
            }
        }
    }

    public static void handleHorseAttack(ServerboundHorseAttackPacket packet, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            if (!horse.m_20148_().equals(packet.getEntityUUID())) {
                Entity tryingToAttackWith = player.m_284548_().m_8791_(packet.getEntityUUID());
                ModRef.LOGGER.warn("{} | {} is trying to make (\"{}\" {}) attack, which they don't ride on!", (Object)player.m_20149_(), (Object)player.m_5446_().toString(), tryingToAttackWith != null ? tryingToAttackWith.m_5446_() : "???", (Object)packet.getEntityUUID());
                return;
            }
            switch (packet.getAction()) {
                case BITE: {
                    horse.startBite();
                    break;
                }
                case KICK: {
                    horse.startKick();
                    break;
                }
                case STOMP: {
                    horse.startStomp();
                }
            }
        } else {
            player.m_5661_((Component)ModRef.getSwemTextComponent().m_7220_((Component)Component.m_237115_((String)"text.swem.status.not_riding_swem_horse")), true);
        }
    }

    public static void handleIceToggle(ServerboundIceTogglePacket packet, NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            if (horse.m_6688_() == null || !horse.m_6688_().m_20148_().equals(player.m_20148_())) {
                player.m_5661_((Component)Component.m_237115_((String)"text.swem.status.horse.needs_to_be_in_control"), true);
                return;
            }
            horse.toggleIceEffect();
        } else {
            boolean canToggleBoots = player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof GoldRidingBoots;
            if (canToggleBoots) {
                if (player.getPersistentData().m_128441_("swem:blockIceEffect")) {
                    player.getPersistentData().m_128473_("swem:blockIceEffect");
                    player.m_5661_((Component)Component.m_237115_((String)"text.swem.status.ice.on"), true);
                } else {
                    player.getPersistentData().m_128379_("swem:blockIceEffect", true);
                    player.m_5661_((Component)Component.m_237115_((String)"text.swem.status.ice.off"), true);
                }
            }
        }
    }
}

