/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class CSyncMovementIdentifiersPacket {
    private MovementPacketData packetData;
    private UUID entityUUID;
    private final boolean failed;

    public CSyncMovementIdentifiersPacket(MovementPacketData packetData, UUID entity) {
        this.packetData = packetData;
        this.entityUUID = entity;
        this.failed = false;
    }

    public CSyncMovementIdentifiersPacket(boolean failed) {
        this.failed = failed;
    }

    public MovementPacketData getPacketData() {
        return this.packetData;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public static CSyncMovementIdentifiersPacket decode(ByteBuf buf) {
        try {
            MovementPacketData packetData = MovementPacketData.decode(buf);
            UUID entity = ((FriendlyByteBuf)buf).m_130259_();
            return new CSyncMovementIdentifiersPacket(packetData, entity);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("CSyncMovementIdentifiersPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new CSyncMovementIdentifiersPacket(true);
        }
    }

    public static void encode(CSyncMovementIdentifiersPacket msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.getPacketData().isMovingForward);
        buffer.writeBoolean(msg.getPacketData().isMovingBackwards);
        buffer.writeBoolean(msg.getPacketData().isMovingLeft);
        buffer.writeBoolean(msg.getPacketData().isMovingRight);
        buffer.m_130077_(msg.getEntityUUID());
    }

    public static void handle(CSyncMovementIdentifiersPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity entity = player.m_284548_().m_8791_(msg.getEntityUUID());
            if (entity instanceof SWEMHorseEntityBase) {
                SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
                if (entity.m_20363_((Entity)player)) {
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_FORWARD, (Object)msg.getPacketData().isMovingForward());
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_BACKWARDS, (Object)msg.getPacketData().isMovingBackwards());
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_LEFT, (Object)msg.getPacketData().isMovingLeft());
                    horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_RIGHT, (Object)msg.getPacketData().isMovingRight());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class MovementPacketData {
        private final boolean isMovingForward;
        private final boolean isMovingBackwards;
        private final boolean isMovingLeft;
        private final boolean isMovingRight;

        public MovementPacketData(boolean isMovingFoward, boolean isMovingBackwards, boolean isMovingLeft, boolean isMovingRight) {
            this.isMovingForward = isMovingFoward;
            this.isMovingBackwards = isMovingBackwards;
            this.isMovingLeft = isMovingLeft;
            this.isMovingRight = isMovingRight;
        }

        public static MovementPacketData decode(ByteBuf buf) {
            boolean isMovingForward = buf.readBoolean();
            boolean isMovingBackwards = buf.readBoolean();
            boolean isMovingLeft = buf.readBoolean();
            boolean isMovingRight = buf.readBoolean();
            return new MovementPacketData(isMovingForward, isMovingBackwards, isMovingLeft, isMovingRight);
        }

        public boolean isMovingForward() {
            return this.isMovingForward;
        }

        public boolean isMovingBackwards() {
            return this.isMovingBackwards;
        }

        public boolean isMovingLeft() {
            return this.isMovingLeft;
        }

        public boolean isMovingRight() {
            return this.isMovingRight;
        }
    }
}

