/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.network.protocol.ClientPacketHandler;
import com.alaharranhonor.swem.forge.network.protocol.Packet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundHorseJumpPacket
extends Packet {
    private final int entityId;
    private final float jumpHeight;

    public ClientboundHorseJumpPacket(int entityId, float jumpHeight) {
        this.entityId = entityId;
        this.jumpHeight = jumpHeight;
    }

    public ClientboundHorseJumpPacket(FriendlyByteBuf reader) {
        super(reader);
        this.entityId = reader.readInt();
        this.jumpHeight = reader.readFloat();
    }

    @Override
    public void encode(FriendlyByteBuf writer) {
        writer.writeInt(this.entityId);
        writer.writeFloat(this.jumpHeight);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientPacketHandler.handleHorseJump(this));
        ctx.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public float getJumpHeight() {
        return this.jumpHeight;
    }
}

